/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.ui.Ui;
import com.tridiumx.analytics.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.zip.GZIPInputStream;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.bajax.analytics.AnalyticConstants;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="clearFilter"), @NiagaraAction(name="filterModified"), @NiagaraAction(name="dataSelection")})
public class BDataSelectionFe
extends BWbFieldEditor
implements AnalyticConstants {
    @Generated
    public static final Action clearFilter = BDataSelectionFe.newAction((int)0, null);
    @Generated
    public static final Action filterModified = BDataSelectionFe.newAction((int)0, null);
    @Generated
    public static final Action dataSelection = BDataSelectionFe.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDataSelectionFe.class);
    private BButton clearButton;
    private ArrayList<String> data = new ArrayList();
    private BList dataList;
    private static ArrayList<String> history = new ArrayList();
    private BTextField filter;
    private BTextDropDown selectionText;
    private boolean showAlgorithms = true;
    private BAnalyticService svc;

    @Generated
    public void clearFilter() {
        this.invoke(clearFilter, null, null);
    }

    @Generated
    public void filterModified() {
        this.invoke(filterModified, null, null);
    }

    @Generated
    public void dataSelection() {
        this.invoke(dataSelection, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDataSelectionFe() {
        BEdgePane content = new BEdgePane();
        BFlowPane top = new BFlowPane(BHalign.left);
        this.filter = new BTextField("", 40, true);
        this.clearButton = new BButton(Ui.close);
        top.add(null, (BValue)new BLabel(Ui.lex("filter")));
        top.add(null, (BValue)this.filter);
        top.add(null, (BValue)Ui.toolButton(this.clearButton));
        BBorderPane border = Ui.pad(Ui.solid((BWidget)top, 1, 1, 1, 1), 4.0, 4.0, 4.0, 4.0);
        content.setTop((BWidget)border);
        this.dataList = new BList();
        this.dataList.setMultipleSelection(false);
        content.setCenter((BWidget)Ui.pad(Ui.solid((BWidget)new BScrollPane((BWidget)this.dataList), 0, 1, 0, 1), 4.0, 4.0, 4.0, 4.0));
        this.selectionText = new BTextDropDown(true);
        content.setBottom((BWidget)Ui.pad(Ui.solid((BWidget)this.selectionText, 1, 1, 1, 1), 4.0, 4.0, 4.0, 4.0));
        BConstrainedPane cp = new BConstrainedPane((BWidget)content);
        cp.setMinWidth(300.0);
        cp.setMinHeight(400.0);
        cp.setMaxHeight(700.0);
        this.setContent((BWidget)cp);
        this.linkTo((BComponent)this.filter, (Slot)BTextField.textModified, (Slot)filterModified);
        this.linkTo((BComponent)this.dataList, (Slot)BList.selectionModified, (Slot)dataSelection);
        this.linkTo((BComponent)this.clearButton, (Slot)BButton.actionPerformed, (Slot)clearFilter);
    }

    public void doClearFilter() {
        this.dataList.getSelection().deselectAll();
        this.filter.setText("");
        this.clearButton.setEnabled(false);
        this.loadDataList();
    }

    public void doDataSelection() {
        Object o = this.dataList.getSelectedItem();
        if (o == null) {
            return;
        }
        String s = o.toString();
        if (s.length() == 0) {
            return;
        }
        this.updateText(s);
    }

    public void doFilterModified() {
        String txt = this.filter.getText();
        this.clearButton.setEnabled(txt.length() > 0);
        this.loadDataList();
    }

    public BDataSelectionFe setShowAlgorithms(boolean arg) {
        this.showAlgorithms = arg;
        return this;
    }

    public void started() throws Exception {
        super.started();
        this.loadData();
        this.loadDataList();
        this.filter.requestFocus();
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.loadHistory();
        this.updateText(value.toString(null));
        this.updateHistory();
        this.linkTo((BComponent)this.selectionText.getEditor(), (Slot)BTextField.textModified, (Slot)setModified);
        this.clearButton.setEnabled(false);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        this.updateHistory();
        return BString.make((String)this.selectionText.getText());
    }

    protected void doSetReadonly(boolean readonly) {
        this.selectionText.setEnabled(!readonly);
    }

    private void loadData() {
        this.data.clear();
        try {
            this.loadData(BOrd.NULL);
            Collections.sort(this.data);
        }
        catch (Exception x) {
            Ui.showError((BWidget)this, x);
        }
    }

    private void loadData(BOrd ord) {
        try {
            if (this.svc == null) {
                this.svc = (BAnalyticService)Ui.resolveOrd((BWbPlugin)this, "service:analytics:AnalyticService");
            }
            if (this.svc == null) {
                return;
            }
            BBlob blob = this.svc.findData(ord);
            ByteArrayInputStream bin = new ByteArrayInputStream(blob.copyBytes());
            GZIPInputStream gin = new GZIPInputStream(bin);
            DataInputStream in = new DataInputStream(gin);
            int size = in.readInt();
            while (--size >= 0) {
                String s = in.readUTF();
                if (!this.showAlgorithms && s.startsWith("alg")) continue;
                this.data.add(s);
            }
            in.close();
        }
        catch (Exception x) {
            Ui.showError((BWidget)this, x);
        }
    }

    private void loadHistory() {
        BList list = this.selectionText.getList();
        list.removeAllItems();
        int len = history.size();
        for (int i = 0; i < len; ++i) {
            list.addItem((Object)history.get(i));
        }
    }

    private synchronized void loadDataList() {
        this.dataList.removeAllItems();
        String[] f = Strings.fields((String)this.filter.getText(), (char)' ');
        if (f.length == 0) {
            f = null;
        } else {
            int i = f.length;
            while (--i > 0) {
                f[i] = f[i].toLowerCase();
            }
        }
        int len = this.data.size();
        for (int i = 0; i < len; ++i) {
            String cur = this.data.get(i);
            if (f != null) {
                boolean add = true;
                String lc = cur.toLowerCase();
                int j = f.length;
                while (--j >= 0) {
                    if (lc.indexOf(f[j]) >= 0) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
            }
            this.dataList.addItem((Object)cur);
        }
    }

    private void updateText(String value) {
        if (this.isReadonly()) {
            return;
        }
        this.selectionText.setText(value);
    }

    private void updateHistory() {
        String val = this.selectionText.getText();
        history.remove(val);
        history.add(0, val);
        int i = history.size();
        while (--i >= 25) {
            history.remove(i);
        }
    }
}

