/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.ui;

import com.tridium.workbench.util.WbUtil;
import com.tridium.workbench.web.browser.BWebWidget;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.algorithm.missingdata.BMissingDataStrategy;
import com.tridiumx.analytics.chart.ux.configuration.BAnalyticsChartBaselineDetails;
import com.tridiumx.analytics.ui.AnalyticBinding;
import com.tridiumx.analytics.ui.BCellValue;
import com.tridiumx.analytics.ui.BOptionalCellValue;
import com.tridiumx.analytics.ui.utils.AnalyticsWbUtil;
import com.tridiumx.analytics.util.Strings;
import java.io.IOException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BEnum;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.units.BUnit;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BFormat;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbViewBinding;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.time.BAnalyticTimeRange;
import javax.bajax.analytics.time.BInterval;

@NiagaraType(agent={@AgentOn(types={"bajaui:Widget", "baja:Component"})})
@NiagaraProperties(value={@NiagaraProperty(name="ord", type="BOrd", defaultValue="BOrd.NULL", flags=4, override=true), @NiagaraProperty(name="data", type="BCellValue", defaultValue="new BCellValue(\"analytics:DataSelectionFe\", BString.make(\"n:history\"))"), @NiagaraProperty(name="node", type="BCellValue", defaultValue="new BCellValue(\"analytics:NodeSelectionFe\", BString.make(\"slot:\"))"), @NiagaraProperty(name="dataFilter", type="String", defaultValue=""), @NiagaraProperty(name="timeRange", type="BAnalyticTimeRange", defaultValue="BAnalyticTimeRange.today"), @NiagaraProperty(name="interval", type="BCellValue", defaultValue="new BOptionalCellValue(BInterval.fifteenMinutes)"), @NiagaraProperty(name="aggregation", type="BCellValue", defaultValue="new BOptionalCellValue(BCombination.first)"), @NiagaraProperty(name="rollup", type="BCellValue", defaultValue="new BOptionalCellValue(BCombination.first)"), @NiagaraProperty(name="unit", type="BCellValue", defaultValue="new BOptionalCellValue(BUnit.NULL)"), @NiagaraProperty(name="brush", type="BCellValue", defaultValue="new BOptionalCellValue(BBrush.DEFAULT)", flags=4), @NiagaraProperty(name="seriesName", type="BFormat", defaultValue="BFormat.make(\"%node.navDisplayName%-%data.name%\")"), @NiagaraProperty(name="daysOfWeek", type="BCellValue", defaultValue="new BCellValue(\"workbench:DaysOfWeekBitsFE\",BDaysOfWeekBits.DEFAULT)"), @NiagaraProperty(name="totalize", type="boolean", defaultValue="true"), @NiagaraProperty(name="missingDataStrategy", type="BCellValue", defaultValue="new BCellValue(new BMissingDataStrategy())"), @NiagaraProperty(name="baselineValue", type="BAnalyticsChartBaselineDetails", defaultValue="BAnalyticsChartBaselineDetails.DEFAULT")})
public class BAnalyticWebChartBinding
extends BWbViewBinding
implements AnalyticBinding,
AnalyticConstants {
    @Generated
    public static final Property ord = BAnalyticWebChartBinding.newProperty((int)4, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property data = BAnalyticWebChartBinding.newProperty((int)0, (BValue)new BCellValue("analytics:DataSelectionFe", (BValue)BString.make((String)"n:history")), null);
    @Generated
    public static final Property node = BAnalyticWebChartBinding.newProperty((int)0, (BValue)new BCellValue("analytics:NodeSelectionFe", (BValue)BString.make((String)"slot:")), null);
    @Generated
    public static final Property dataFilter = BAnalyticWebChartBinding.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property timeRange = BAnalyticWebChartBinding.newProperty((int)0, (BValue)BAnalyticTimeRange.today, null);
    @Generated
    public static final Property interval = BAnalyticWebChartBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BInterval.fifteenMinutes), null);
    @Generated
    public static final Property aggregation = BAnalyticWebChartBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BCombination.first), null);
    @Generated
    public static final Property rollup = BAnalyticWebChartBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BCombination.first), null);
    @Generated
    public static final Property unit = BAnalyticWebChartBinding.newProperty((int)0, (BValue)new BOptionalCellValue((BValue)BUnit.NULL), null);
    @Generated
    public static final Property brush = BAnalyticWebChartBinding.newProperty((int)4, (BValue)new BOptionalCellValue((BValue)BBrush.DEFAULT), null);
    @Generated
    public static final Property seriesName = BAnalyticWebChartBinding.newProperty((int)0, (BValue)BFormat.make((String)"%node.navDisplayName%-%data.name%"), null);
    @Generated
    public static final Property daysOfWeek = BAnalyticWebChartBinding.newProperty((int)0, (BValue)new BCellValue("workbench:DaysOfWeekBitsFE", (BValue)BDaysOfWeekBits.DEFAULT), null);
    @Generated
    public static final Property totalize = BAnalyticWebChartBinding.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property missingDataStrategy = BAnalyticWebChartBinding.newProperty((int)0, (BValue)new BCellValue((BValue)new BMissingDataStrategy()), null);
    @Generated
    public static final Property baselineValue = BAnalyticWebChartBinding.newProperty((int)0, (BValue)BAnalyticsChartBaselineDetails.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAnalyticWebChartBinding.class);

    @Generated
    public BCellValue getData() {
        return (BCellValue)this.get(data);
    }

    @Generated
    public void setData(BCellValue v) {
        this.set(data, (BValue)v, null);
    }

    @Override
    @Generated
    public BCellValue getNode() {
        return (BCellValue)this.get(node);
    }

    @Generated
    public void setNode(BCellValue v) {
        this.set(node, (BValue)v, null);
    }

    @Generated
    public String getDataFilter() {
        return this.getString(dataFilter);
    }

    @Generated
    public void setDataFilter(String v) {
        this.setString(dataFilter, v, null);
    }

    @Generated
    public BAnalyticTimeRange getTimeRange() {
        return (BAnalyticTimeRange)this.get(timeRange);
    }

    @Generated
    public void setTimeRange(BAnalyticTimeRange v) {
        this.set(timeRange, (BValue)v, null);
    }

    @Generated
    public BCellValue getInterval() {
        return (BCellValue)this.get(interval);
    }

    @Generated
    public void setInterval(BCellValue v) {
        this.set(interval, (BValue)v, null);
    }

    @Generated
    public BCellValue getAggregation() {
        return (BCellValue)this.get(aggregation);
    }

    @Generated
    public void setAggregation(BCellValue v) {
        this.set(aggregation, (BValue)v, null);
    }

    @Generated
    public BCellValue getRollup() {
        return (BCellValue)this.get(rollup);
    }

    @Generated
    public void setRollup(BCellValue v) {
        this.set(rollup, (BValue)v, null);
    }

    @Generated
    public BCellValue getUnit() {
        return (BCellValue)this.get(unit);
    }

    @Generated
    public void setUnit(BCellValue v) {
        this.set(unit, (BValue)v, null);
    }

    @Generated
    public BCellValue getBrush() {
        return (BCellValue)this.get(brush);
    }

    @Generated
    public void setBrush(BCellValue v) {
        this.set(brush, (BValue)v, null);
    }

    @Generated
    public BFormat getSeriesName() {
        return (BFormat)this.get(seriesName);
    }

    @Generated
    public void setSeriesName(BFormat v) {
        this.set(seriesName, (BValue)v, null);
    }

    @Generated
    public BCellValue getDaysOfWeek() {
        return (BCellValue)this.get(daysOfWeek);
    }

    @Generated
    public void setDaysOfWeek(BCellValue v) {
        this.set(daysOfWeek, (BValue)v, null);
    }

    @Generated
    public boolean getTotalize() {
        return this.getBoolean(totalize);
    }

    @Generated
    public void setTotalize(boolean v) {
        this.setBoolean(totalize, v, null);
    }

    @Generated
    public BCellValue getMissingDataStrategy() {
        return (BCellValue)this.get(missingDataStrategy);
    }

    @Generated
    public void setMissingDataStrategy(BCellValue v) {
        this.set(missingDataStrategy, (BValue)v, null);
    }

    @Generated
    public BAnalyticsChartBaselineDetails getBaselineValue() {
        return (BAnalyticsChartBaselineDetails)this.get(baselineValue);
    }

    @Generated
    public void setBaselineValue(BAnalyticsChartBaselineDetails v) {
        this.set(baselineValue, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        if (this.isRunning() && !p.equals(ord)) {
            this.buildOrd();
        }
        if (p.equals(timeRange)) {
            this.getBaselineValue().setChartTimeRange(this.getTimeRange().encodeToString());
        }
        super.changed(p, cx);
    }

    public void started() {
        this.buildOrd();
        this.getBaselineValue().setChartTimeRange(this.getTimeRange().encodeToString());
        Optional chartType = ((BWebWidget)this.getWidget()).getTypeInfoFromJs();
        chartType.ifPresent(typeInfo -> this.getBaselineValue().setChartType(typeInfo.toString()));
        super.started();
    }

    private void buildOrd() {
        BMissingDataStrategy mds;
        if (this.getData().toString(null).length() == 0 || this.getNode().isNull()) {
            this.setOrd(BOrd.NULL);
            return;
        }
        TreeMap<String, String> args = new TreeMap<String, String>();
        args.put("data", this.getData().toString(null));
        args.put("timeRange", this.getTimeRange().toString(null));
        if (this.getUnit().getEnabled()) {
            args.put("unit", ((BUnit)this.getUnit().getValue()).getUnitName());
        }
        if (this.getDataFilter().length() > 0) {
            args.put("dataFilter", this.getDataFilter());
        }
        if (this.getAggregation().getEnabled()) {
            args.put("aggregation", ((BEnum)this.getAggregation().getValue()).getTag());
        }
        if (this.getInterval().getEnabled()) {
            args.put("interval", ((BEnum)this.getInterval().getValue()).getTag());
        }
        if (this.getRollup().getEnabled()) {
            args.put("rollup", ((BEnum)this.getRollup().getValue()).getTag());
        }
        if (this.getBrush().getEnabled()) {
            try {
                args.put("brush", ((BBrush)this.getBrush().getValue()).encodeToString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.getDaysOfWeek().getEnabled()) {
            args.put("dow", ((BDaysOfWeekBits)this.getDaysOfWeek().getValue()).encodeToString());
        }
        if (this.getBaselineValue().getEnabled()) {
            args.put("baselineTimeRangeEnum", this.getBaselineValue().getTimeRange().getTag());
            args.put("baselineTimeRange", this.getBaselineValue().getStartTime().encodeToString() + ";" + this.getBaselineValue().getEndTime().encodeToString());
            args.put("baselineEndTimeEnabled", String.valueOf(this.getBaselineValue().getEndTimeEnabled()));
            args.put("baselineAlignDOW", String.valueOf(this.getBaselineValue().getAlignDOW()));
        }
        args.put("seriesName", this.getSeriesName().toString());
        args.put("hisTotEnabled", Boolean.toString(!this.getTotalize()));
        args.put("uniqueKey", UUID.randomUUID().toString());
        BCellValue cv = this.getMissingDataStrategy();
        BMissingDataStrategy bMissingDataStrategy = mds = cv.getEnabled() ? (BMissingDataStrategy)cv.getValue() : BMissingDataStrategy.DEFAULT;
        if (mds.getEnabled()) {
            args.put("aggStrategy", mds.getAggregationStrategy().getTag());
            args.put("intpAlgorithm", mds.getInterpolationAlgorithm().getTag());
            args.put("knnValue", Integer.toString(mds.getKValue()));
        }
        String nodeName = this.getNode().toString(null);
        StringBuffer buf = AnalyticsWbUtil.getStringBuffer(nodeName);
        buf.append(nodeName);
        Version remoteVersion = this.getAnalyticRemoteVersion();
        if (remoteVersion == null || remoteVersion.compareTo(new Version("4.13")) >= 0) {
            buf.append("|analyticBaselineTrend:");
        } else {
            buf.append("|analytictrend:");
        }
        buf.append(Strings.encodeQueryString(args));
        this.setOrd(BOrd.make((String)buf.toString()));
    }

    public Version getAnalyticRemoteVersion() {
        BAnalyticService analyticService;
        Version remoteVersion = null;
        if (this.getWidget().getShell() instanceof BWbShell && (analyticService = (BAnalyticService)WbUtil.findService((BWidget)this.getWidget(), (Type)BAnalyticService.TYPE, (BWbShell)((BWbShell)this.getWidget().getShell()))) != null) {
            remoteVersion = (Version)analyticService.fw(404, (Object)"analytics", (Object)"wb", null, null);
        }
        return remoteVersion;
    }
}

