/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.ui;

import com.tridium.help.ui.BHelpSideBar;
import com.tridium.help.ui.HelpTreeNode;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.nav.BINavNode;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.util.Lexicon;
import javax.baja.workbench.sidebar.BIWbSideBar;

public class HelpSyncTreeCommand
extends Command {
    private final String JS_DOC = "module://docDeveloper/doc/jsdoc/";
    private final BOrd DEVELOPER_DOC_INDEX = BOrd.make((String)"local:|module://docDeveloper/doc/index.html");
    private static final Lexicon LEX = Lexicon.make((String)"help");

    public HelpSyncTreeCommand(BWidget owner) {
        super(owner, LEX, "HelpProfile.syncTree");
    }

    public CommandArtifact doInvoke() {
        boolean found;
        BNiagaraWbShell shell = (BNiagaraWbShell)this.getOwner();
        BOrd activeOrd = shell.getActiveOrd();
        OrdTarget activeOrdTarget = shell.getActiveOrdTarget();
        boolean bl = found = this.sync(activeOrdTarget, activeOrd, null, true) != null;
        if (!found) {
            BGridPane g = new BGridPane(1);
            g.setHalign(BHalign.left);
            g.add(null, (BValue)new BLabel(LEX.getText("HelpProfile.syncTree.nodeNotFound")));
            g.add(null, (BValue)new BLabel(activeOrd.toString()));
            BDialog.open((BWidget)this.getOwner(), (String)BDialog.TITLE_ERROR, (Object)g, (int)1, (BImage)BDialog.ERROR_ICON);
        }
        return null;
    }

    private HelpTreeNode sync(OrdTarget activeOrdTarget, BOrd activeOrd, BOrd overrideOrd, boolean lookForFragment) {
        String moduleName;
        BOrd navOrd;
        BObject o;
        OrdTarget target;
        BOrd ord;
        BHelpSideBar sideBar = this.getPrimaryHelpSideBar();
        if (sideBar == null) {
            return null;
        }
        if (overrideOrd != null) {
            ord = BOrd.make((BOrd)BOrd.make((String)"local:"), (BOrd)overrideOrd).normalize();
            target = ord.resolve();
        } else {
            ord = BOrd.make((BOrd)BOrd.make((String)"local:"), (BOrd)activeOrd).normalize();
            target = activeOrdTarget;
        }
        String pathFragment = target.getFilePathFragment();
        FilePath filePath = target.getFilePath();
        if (pathFragment == null) {
            lookForFragment = false;
        }
        if (pathFragment != null && !lookForFragment && (o = target.get()) instanceof BINavNode && (navOrd = ((BINavNode)o).getNavOrd()) != null && !navOrd.isNull()) {
            ord = navOrd.normalize();
        }
        if ((moduleName = HelpSyncTreeCommand.getModuleName(ord)) == null) {
            return null;
        }
        BOrd tocRootNoteFallback = null;
        boolean isBajaDoc = false;
        boolean isJsDoc = false;
        BOrd jsDocModuleIndexOrd = null;
        if (filePath != null) {
            String name = filePath.getName();
            if (name.endsWith(".bajadoc")) {
                isBajaDoc = true;
            }
            if (filePath.toString().startsWith("module://docDeveloper/doc/jsdoc/")) {
                isJsDoc = true;
                if (overrideOrd == null) {
                    String jsDocModuleName = filePath.toString().substring("module://docDeveloper/doc/jsdoc/".length()).split("/")[0];
                    jsDocModuleIndexOrd = BOrd.make((String)("local:|module://docDeveloper/doc/jsdoc/" + jsDocModuleName + "/index.html"));
                    if (jsDocModuleIndexOrd.equals((Object)ord)) {
                        jsDocModuleIndexOrd = null;
                    }
                }
            } else if (overrideOrd == null && filePath.toString().startsWith("module://") && (tocRootNoteFallback = BOrd.make((String)("local:|module://" + moduleName + "/doc/index.html"))).equals((Object)ord)) {
                tocRootNoteFallback = null;
            }
        }
        BTreePane treeNode = isBajaDoc ? sideBar.getApiWidget() : sideBar.getTocWidget();
        BTree tree = treeNode.getTree();
        HelpTreeNode helpNode = null;
        for (int i = 0; i < tree.getModel().getRootCount(); ++i) {
            HelpTreeNode rootNode = (HelpTreeNode)tree.getModel().getRoot(i);
            String rootModuleName = HelpSyncTreeCommand.getModuleName(rootNode.getContentOrd());
            if (rootModuleName != null && rootModuleName.equals(moduleName)) {
                helpNode = this.findTreeNode((HelpTreeNode)tree.getModel().getRoot(i), ord);
            }
            if (helpNode != null) break;
        }
        if (helpNode != null) {
            tree.expandToNode(helpNode);
            tree.getSelection().select(helpNode);
            tree.scrollNodeToVisible(helpNode);
            sideBar.setSelectedTab((BWidget)treeNode);
            return helpNode;
        }
        if (lookForFragment) {
            return this.sync(activeOrdTarget, activeOrd, null, false);
        }
        if (isJsDoc) {
            if (jsDocModuleIndexOrd != null) {
                return this.sync(activeOrdTarget, activeOrd, jsDocModuleIndexOrd, true);
            }
            if (overrideOrd == null || !overrideOrd.equals((Object)this.DEVELOPER_DOC_INDEX)) {
                return this.sync(activeOrdTarget, activeOrd, BOrd.make((String)"module://docDeveloper/doc/index.html"), false);
            }
        }
        if (tocRootNoteFallback != null) {
            return this.sync(activeOrdTarget, activeOrd, tocRootNoteFallback, false);
        }
        return null;
    }

    private BHelpSideBar getPrimaryHelpSideBar() {
        BIWbSideBar[] bars;
        BNiagaraWbShell shell = (BNiagaraWbShell)this.getOwner();
        for (BIWbSideBar bar : bars = shell.pane.getSideBar().list()) {
            if (!(bar instanceof BHelpSideBar)) continue;
            return (BHelpSideBar)bar;
        }
        return null;
    }

    private static String getModuleName(BOrd ord) {
        try {
            OrdQuery[] queries;
            ord = ord.normalize();
            for (OrdQuery query : queries = ord.parse()) {
                if (!query.getScheme().equals("module")) continue;
                return query.getBody().split("/")[2];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private HelpTreeNode findTreeNode(HelpTreeNode node, BOrd ord) {
        if (node.getContentOrd().equals((Object)ord)) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            HelpTreeNode foundNode = this.findTreeNode((HelpTreeNode)node.getChild(i), ord);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }
}

