/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.ui;

import com.tridium.help.Hierarchy;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.html.HtmlCompiler;
import com.tridium.help.bajadoc.parser.BajadocParser;
import com.tridium.help.bajadoc.ui.BBajadocOptions;
import com.tridium.help.bajadoc.ui.BajadocCommands;
import com.tridium.workbench.web.browser.BWebBrowserView;
import java.io.StringWriter;
import java.util.Arrays;
import javax.baja.file.BIFile;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BToolBar;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.menu.BIMenu;

@NiagaraType(agent={@AgentOn(types={"file:BajadocFile"}, requiredPermissions="r")})
public final class BBajadocViewer
extends BWebBrowserView {
    @Generated
    public static final Type TYPE = Sys.loadType(BBajadocViewer.class);
    private final BajadocCommands commands = new BajadocCommands(this);
    private Doc doc;
    private String js;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.commands.init();
        BIFile file = (BIFile)value;
        BString out = this.compileOutput(file);
        this.setDependsCommandEnableState();
        super.doLoadValue((BObject)out, cx);
    }

    protected void onLoaded() {
        super.onLoaded();
        if (this.js != null) {
            this.executeScriptAsync(this.js);
        }
    }

    public CommandArtifact invokeCommand(int id) throws Exception {
        if (id == 6) {
            this.expandAll();
        }
        return super.invokeCommand(id);
    }

    private BString compileOutput(BIFile value) throws Exception {
        Hierarchy.instance().ensureDepersisted();
        this.doc = new BajadocParser().parse(value);
        StringWriter out = new StringWriter();
        HtmlCompiler.BajadocHtmlCompilerOptions opts = new HtmlCompiler.BajadocHtmlCompilerOptions(BBajadocOptions.make());
        opts.setIncludeExpansionToggle(true);
        opts.setIncludeIcons(true);
        opts.setIncludeMemberIndex(false);
        opts.setIncludeSubclassHierarchy(true);
        HtmlCompiler.compile(out, this.doc, opts);
        this.js = HtmlCompiler.getDocumentReadyScript(opts);
        out.flush();
        return BString.make((String)out.toString());
    }

    private void recompileOutput() throws Exception {
        BString out = this.compileOutput((BIFile)this.getCurrentValue());
        this.loadBrowser((BObject)out, this.getCurrentContext());
    }

    public void reloadViewer() throws Exception {
        this.recompileOutput();
        this.setDependsCommandEnableState();
    }

    public Doc getDoc() {
        return this.doc;
    }

    public void expandAll(boolean expand) {
        if (expand) {
            this.expandAll();
        } else {
            this.collapseAll();
        }
    }

    private void expandAll() {
        this.executeScriptAsync("window.niagara.bajadoc.expandAll();");
    }

    private void collapseAll() {
        this.executeScriptAsync("window.niagara.bajadoc.collapseAll();");
    }

    public String getDefaultOptionsId() {
        return "bajadoc";
    }

    public BIMenu[] getViewMenus() {
        BIMenu[] menus;
        BIMenu[] browserMenu = super.getViewMenus();
        if (browserMenu != null) {
            menus = Arrays.copyOf(browserMenu, browserMenu.length + 1);
            menus[menus.length - 1] = this.commands.getViewMenu();
        } else {
            menus = new BIMenu[]{this.commands.getViewMenu()};
        }
        return menus;
    }

    public BToolBar getViewToolBar() {
        BToolBar toolbar = super.getViewToolBar();
        this.commands.updateToolBar(toolbar);
        return toolbar;
    }

    private void setDependsCommandEnableState() {
        this.commands.depends.setEnabled(this.doc instanceof ClassDoc);
    }
}

