/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc.html;

import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.FrameworkDoc;
import com.tridium.help.bajadoc.JavaType;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.PackageDoc;
import javax.baja.nre.util.TextUtil;

public class UriPath {
    private static final String[] NO_NAMES = new String[0];
    private String body;
    private String[] names = NO_NAMES;

    public UriPath(String body) {
        this.body = body;
        if (body.charAt(0) != '/') {
            throw new IllegalStateException(body + " is not absolute.");
        }
        if (body.length() > 0) {
            this.names = TextUtil.split((String)body.substring(1), (char)'/');
            for (int i = 0; i < this.names.length; ++i) {
                if (this.names[i] != null && !this.names[i].equals("") && !this.names[i].equals(".") && !this.names[i].equals("..")) continue;
                throw new IllegalStateException(body + " is malformed.");
            }
        }
    }

    public static UriPath makeResourceURI(String resourcePath) {
        return new UriPath("/rc/" + resourcePath);
    }

    public static UriPath makeFrameworkURI() {
        return new UriPath("/framework.html");
    }

    public static UriPath makeModuleURI(String modulePartName) {
        return new UriPath("/" + modulePartName + "-module-index.html");
    }

    public static UriPath makePackageURI(String packageName) {
        return new UriPath("/" + packageName.replace('.', '/') + ".html");
    }

    public static UriPath makeTypeURI(JavaType type) {
        if (!type.isResolved()) {
            return null;
        }
        return UriPath.makeTypeURI(type.packageName(), type.name());
    }

    public static UriPath makeTypeURI(String pkgName, String clsName) {
        return new UriPath("/" + pkgName.replace('.', '/') + "/" + clsName + ".html");
    }

    public static UriPath makeDocURI(Doc doc) {
        if (doc instanceof ModuleDoc) {
            ModuleDoc m = (ModuleDoc)doc;
            return UriPath.makeModuleURI(m.modulePart());
        }
        if (doc instanceof PackageDoc) {
            PackageDoc p = (PackageDoc)doc;
            return UriPath.makePackageURI(p.name());
        }
        if (doc instanceof ClassDoc) {
            ClassDoc c = (ClassDoc)doc;
            return UriPath.makeTypeURI(c.packageName(), c.name());
        }
        if (doc instanceof FrameworkDoc) {
            return UriPath.makeFrameworkURI();
        }
        throw new IllegalStateException(doc.toString());
    }

    public String getFrameworkHref() {
        return this.getRelativePath(UriPath.makeFrameworkURI());
    }

    public String getModuleHref(String modulePartName) {
        return this.getRelativePath(UriPath.makeModuleURI(modulePartName));
    }

    public String getPackageHref(String packageName) {
        return this.getRelativePath(UriPath.makePackageURI(packageName));
    }

    public String getTypeHref(JavaType type) {
        return this.getRelativePath(UriPath.makeTypeURI(type));
    }

    public String getTypeHref(String pkgName, String clsName) {
        return this.getRelativePath(UriPath.makeTypeURI(pkgName, clsName));
    }

    public String getResourceHref(String resourceName) {
        return this.getRelativePath(new UriPath("/rc/" + resourceName));
    }

    public String body() {
        return this.body;
    }

    public String toString() {
        return this.body();
    }

    private String getRelativePath(UriPath path) {
        int i;
        int n;
        if (this.body.equals(path.body)) {
            if (this.body.equals("/")) {
                throw new IllegalStateException("Cannot get relative path from a root to itself");
            }
            return this.names[this.names.length - 1];
        }
        String[] from = this.names;
        String[] to = path.names;
        int fromLen = from.length;
        int toLen = to.length;
        for (n = 0; n < fromLen && n < toLen && from[n].equals(to[n]); ++n) {
        }
        StringBuilder sb = new StringBuilder();
        for (i = n + 1; i < fromLen; ++i) {
            sb.append("../");
        }
        for (i = n; i < toLen; ++i) {
            if (i > n) {
                sb.append("/");
            }
            sb.append(to[i]);
        }
        return sb.toString();
    }
}

