/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help.bajadoc;

import com.tridium.help.bajadoc.Annotation;
import com.tridium.help.bajadoc.DescriptionPart;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.Tag;
import java.lang.reflect.Modifier;

public abstract class ModifierDoc
extends Doc {
    protected final int modifiers;

    protected ModifierDoc(int modifiers, DescriptionPart[] description, Tag[] tags, Annotation[] annotations) {
        super(description, tags, annotations);
        this.modifiers = modifiers;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.modifiers);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.modifiers);
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public static String modifiersToString(int flags) {
        StringBuilder s = new StringBuilder();
        if (Modifier.isPrivate(flags)) {
            s.append("private ");
        }
        if (Modifier.isProtected(flags)) {
            s.append("protected ");
        }
        if (Modifier.isPublic(flags)) {
            s.append("public ");
        }
        if (Modifier.isAbstract(flags)) {
            s.append("abstract ");
        }
        if (Modifier.isFinal(flags)) {
            s.append("final ");
        }
        if (Modifier.isStatic(flags)) {
            s.append("static ");
        }
        if (Modifier.isTransient(flags)) {
            s.append("transient ");
        }
        if (Modifier.isVolatile(flags)) {
            s.append("volatile ");
        }
        if (Modifier.isNative(flags)) {
            s.append("native ");
        }
        if (Modifier.isSynchronized(flags)) {
            s.append("synchronized ");
        }
        return s.toString();
    }

    public String modifiersToString() {
        return ModifierDoc.modifiersToString(this.modifiers);
    }
}

