/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.help;

import com.tridium.help.BajadocIndex;
import com.tridium.help.HelpSystem;
import com.tridium.help.Hierarchy;
import com.tridium.help.HierarchyBuilder;
import com.tridium.help.SearchBuilder;
import com.tridium.help.Searcher;
import com.tridium.help.bajadoc.ClassDoc;
import com.tridium.help.bajadoc.ClassSummary;
import com.tridium.help.bajadoc.Doc;
import com.tridium.help.bajadoc.ModuleDoc;
import com.tridium.help.bajadoc.PackageDoc;
import com.tridium.help.bajadoc.parser.BajadocParser;
import com.tridium.sys.module.NModule;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.util.UiLexicon;

public class SearchLoader
extends BProgressDialog.Worker {
    private final Map<String, List<BajadocIndex.Entry>> bajadocEntries = new TreeMap<String, List<BajadocIndex.Entry>>();
    private static final String WORDS = "doc/words.dat";
    private static final String WORDDOCS = "doc/worddocs.dat";
    private static final String POSTINGS = "doc/postings.dat";
    private static final String DOCUMENTS = "doc/documents.dat";
    static boolean succeeded;
    private int totalTasks;
    private int currentTask;
    private boolean isAlive;
    private final HierarchyBuilder hbuilder = new HierarchyBuilder();
    private final Map<String, String> qnamesToModulePart = new HashMap<String, String>();
    private NModule[] modules;
    private Consumer<Boolean> onComplete;

    public void doRun() {
        try {
            succeeded = false;
            this.isAlive = true;
            this.findModules();
            if (!this.isAlive) {
                return;
            }
            this.initProgress();
            if (!this.isAlive) {
                return;
            }
            this.createSearch();
            if (!this.isAlive) {
                return;
            }
            this.persist();
            if (!this.isAlive) {
                return;
            }
            succeeded = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.finished(succeeded);
            try {
                if (this.onComplete != null) {
                    this.onComplete.accept(succeeded);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doCancel() {
        this.isAlive = false;
    }

    public void setOnComplete(Consumer<Boolean> onComplete) {
        this.onComplete = onComplete;
    }

    private void initProgress() throws Exception {
        this.updateProgress(UiLexicon.bajaui().getText("help.load.scanning"));
        this.currentTask = 0;
        this.totalTasks = 1 + 2 * this.modules.length;
    }

    private void updateProgressBar() {
        if (this.getDialog() == null) {
            return;
        }
        ++this.currentTask;
        double prog = (double)this.currentTask / (double)this.totalTasks;
        this.updateProgress((int)(prog * 100.0));
    }

    private void findModules() {
        this.modules = (NModule[])HelpSystem.getModulesForHelp().toArray(NModule[]::new);
    }

    private void saveBajadocEntry(String docModule, String fileName, Doc doc) {
        String entryName = this.makeEntryName(fileName);
        List<BajadocIndex.Entry> entries = this.bajadocEntries.get(entryName);
        if (entries == null) {
            entries = new ArrayList<BajadocIndex.Entry>();
            this.bajadocEntries.put(entryName, entries);
        }
        entries.add(this.makeEntry(docModule, doc));
    }

    private String makeEntryName(String name) {
        String[] parts = name.split("/");
        if (name.endsWith("module-index.bajadoc")) {
            return parts[1];
        }
        if (name.endsWith("package-index.bajadoc")) {
            StringBuilder sb = new StringBuilder();
            for (int i = 2; i < parts.length - 1; ++i) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(parts[i]);
            }
            return sb.toString();
        }
        return name.substring(name.lastIndexOf(47) + 1, name.length() - ".bajadoc".length());
    }

    private BajadocIndex.Entry makeEntry(String docModule, Doc doc) {
        if (doc instanceof ModuleDoc) {
            ModuleDoc modDoc = (ModuleDoc)doc;
            return new BajadocIndex.Entry(docModule, modDoc.modulePart(), null, null);
        }
        if (doc instanceof PackageDoc) {
            PackageDoc packageDoc = (PackageDoc)doc;
            return new BajadocIndex.Entry(docModule, packageDoc.modulePart(), packageDoc.name(), null);
        }
        if (doc instanceof ClassDoc) {
            ClassDoc classDoc = (ClassDoc)doc;
            return new BajadocIndex.Entry(docModule, classDoc.modulePart(), classDoc.packageName(), classDoc.name());
        }
        return null;
    }

    private void persistBajadocEntries() throws Exception {
        AccessController.doPrivileged(() -> {
            File file = new File(HelpSystem.HELP, "bajadoc.dat");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                for (Map.Entry<String, List<BajadocIndex.Entry>> e : this.bajadocEntries.entrySet()) {
                    List<BajadocIndex.Entry> entries = e.getValue();
                    writer.write(e.getKey());
                    writer.write("|");
                    for (int i = 0; i < entries.size(); ++i) {
                        if (i > 0) {
                            writer.write(";");
                        }
                        writer.write(entries.get(i).encodeForIndex());
                    }
                    writer.write("\n");
                }
                Iterator<Map.Entry<String, List<BajadocIndex.Entry>>> iterator = null;
                return iterator;
            }
        });
    }

    private static void transfer(ZipFile zip, ZipEntry entry, File outBase, String outName) throws Exception {
        try (BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
             FileOutputStream out = new FileOutputStream(new File(outBase, outName));){
            byte[] buf = new byte[1024];
            int len = in.read(buf, 0, 1024);
            while (len > 0) {
                out.write(buf, 0, len);
                len = in.read(buf);
            }
        }
    }

    private void preProcessBajadocs(NModule nModule) throws Exception {
        ZipFile zip = nModule.getZipFile();
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (this.isAlive && entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().endsWith("module-index.bajadoc")) continue;
            BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
            Throwable throwable = null;
            try {
                ModuleDoc doc = (ModuleDoc)new BajadocParser().parse(in, nModule.getModuleName());
                for (ClassSummary cls : doc.types()) {
                    this.qnamesToModulePart.put(cls.qualifiedName(), doc.modulePart());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    private void loadEntries(String module, ZipFile zip, File base, boolean unpack) throws Exception {
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (this.isAlive && entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (unpack) {
                if (entry.getName().equals(WORDS)) {
                    SearchLoader.transfer(zip, entry, base, "words.dat");
                } else if (entry.getName().equals(WORDDOCS)) {
                    SearchLoader.transfer(zip, entry, base, "worddocs.dat");
                } else if (entry.getName().equals(POSTINGS)) {
                    SearchLoader.transfer(zip, entry, base, "postings.dat");
                } else if (entry.getName().equals(DOCUMENTS)) {
                    SearchLoader.transfer(zip, entry, base, "documents.dat");
                }
            }
            if (!entry.getName().endsWith(".bajadoc")) continue;
            BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
            Throwable throwable = null;
            try {
                Doc doc = new BajadocParser().parse(in, module);
                this.hbuilder.loadBajadoc(doc, this.qnamesToModulePart);
                this.saveBajadocEntry(module, entry.getName(), doc);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    private void decompress(NModule nModule) throws Exception {
        AccessController.doPrivileged(() -> {
            File moduleDir = new File(HelpSystem.HELP, nModule.getModuleName());
            if (!moduleDir.exists() && !moduleDir.mkdirs()) {
                throw new BajaRuntimeException("cannot create " + moduleDir.getAbsolutePath());
            }
            File partDir = new File(moduleDir, nModule.getModulePartName());
            if (!partDir.exists() && !partDir.mkdirs()) {
                throw new BajaRuntimeException("cannot create " + partDir.getAbsolutePath());
            }
            ZipFile zip = nModule.getZipFile();
            ZipEntry zipKeys = zip.getEntry(WORDS);
            if (zipKeys == null) {
                this.loadEntries(nModule.getModuleName(), zip, partDir, false);
                new SearchBuilder().build(partDir, nModule.getZipFile());
            } else {
                this.loadEntries(nModule.getModuleName(), zip, partDir, true);
            }
            return null;
        });
    }

    private void createSearch() throws Exception {
        AccessController.doPrivileged(() -> {
            BajaFileUtil.delete((File)HelpSystem.HELP);
            if (!HelpSystem.HELP.exists() && !HelpSystem.HELP.mkdirs()) {
                throw new BajaRuntimeException("cannot mkdirs " + HelpSystem.HELP.getAbsolutePath());
            }
            for (NModule nModule : this.modules) {
                this.preProcessBajadocs(nModule);
                this.updateProgressBar();
            }
            for (NModule nModule : this.modules) {
                this.decompress(nModule);
                this.updateProgressBar();
            }
            return null;
        });
    }

    private void persist() throws Exception {
        this.hbuilder.persist();
        this.persistBajadocEntries();
        Searcher.getInstance();
    }

    private void finished(boolean success) {
        if (!success) {
            try {
                AccessController.doPrivileged(() -> {
                    BajaFileUtil.delete((File)HelpSystem.HELP);
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                e.printStackTrace();
            }
        } else {
            Hierarchy.instance().helpCreated();
            BajadocIndex.instance().helpCreated();
        }
    }
}

