/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.states;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsCanvas;
import com.tridium.wiresheet.WsState;
import com.tridium.wiresheet.states.NormalState;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.event.BMouseEvent;

public class RubberBandState
extends WsState {
    private double x;
    private double y;
    private double w;
    private double h;
    private Point lock;

    public RubberBandState(BWireSheetPane ws, Point lock, double mx, double my) {
        super(ws);
        this.lock = lock;
        this.computePoints(mx, my);
        ws.getScrollPane().setMouseCursor(rubberBandCursor);
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        this.transition(new NormalState(this.ws));
        double mx = event.getX();
        double my = event.getY();
        this.computePoints(mx, my);
        this.selection.unselectAll();
        BWsCanvas canvas = this.ws.getCanvas();
        canvas.getRootGlyph().selectAllInPixelRect(new RectGeom(this.x, this.y, this.w, this.h));
        canvas.repaint();
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        double ox = this.x;
        double oy = this.y;
        double ow = this.w;
        double oh = this.h;
        double mx = event.getX();
        double my = event.getY();
        this.computePoints(mx, my);
        double dx = Math.min(this.x, ox);
        double dy = Math.min(this.y, oy);
        double dw = Math.max(this.x + this.w, ox + ow) - dx;
        double dh = Math.max(this.y + this.h, oy + oh) - dy;
        this.ws.getCanvas().repaint(dx - 1.0, dy - 1.0, dw + 2.0, dh + 2.0);
    }

    @Override
    public void mousePulsed(BMouseEvent event) {
        if (this.pulseViewport(event)) {
            this.mouseDragged(event);
        }
    }

    @Override
    public void paintFx(Graphics g) {
        g.setBrush(BColor.black);
        g.strokeRect(this.x, this.y, this.w, this.h);
    }

    private void computePoints(double mx, double my) {
        this.x = Math.min(this.lock.x, mx);
        this.y = Math.min(this.lock.y, my);
        this.w = Math.abs(this.lock.x - mx);
        this.h = Math.abs(this.lock.y - my);
    }
}

