/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet.commands;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.LinkKnobGlyph;
import com.tridium.wiresheet.LinkLinkGlyph;
import com.tridium.workbench.util.WbUtil;
import javax.baja.nre.util.Array;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public class DeleteLinksCommand
extends Command {
    BWireSheetPane ws;

    public DeleteLinksCommand(BWireSheetPane ws) {
        super((BWidget)(ws.getShell() != null ? ws.getShell() : ws), UiLexicon.bajaui().module, "commands.deleteLinks");
        this.accelerator = BAccelerator.make((String)"Ctrl+Delete");
        this.ws = ws;
    }

    public CommandArtifact doInvoke() throws Exception {
        LinkGlyph[] glyphs = this.ws.selection.getLinkGlyphs();
        if (glyphs.length == 0) {
            return null;
        }
        Array linkArray = new Array(BLink.class);
        for (int i = 0; i < glyphs.length; ++i) {
            BLink link = null;
            if (glyphs[i] instanceof LinkLinkGlyph) {
                link = ((LinkLinkGlyph)glyphs[i]).link;
            } else if (glyphs[i] instanceof LinkKnobGlyph) {
                link = ((LinkKnobGlyph)glyphs[i]).getLink();
            }
            if (link == null) continue;
            linkArray.add((Object)link);
            this.ws.grid.set(glyphs[i].getMinP(), glyphs[i].getMinQ(), glyphs[i].getMaxP(), glyphs[i].getMaxQ(), 0);
        }
        BLink[] links = (BLink[])linkArray.trim();
        if (WbUtil.compositeDeletionWarning((BWidget)this.ws, (BComplex[])links) == 2) {
            return null;
        }
        Artifact art = new Artifact(links);
        art.redo();
        return art;
    }

    class Artifact
    implements CommandArtifact {
        BComponent[] parents;
        BLink[] links;
        boolean undone;

        Artifact(BLink[] links) {
            this.links = links;
        }

        public void redo() throws Exception {
            if (this.undone) {
                throw new Exception("Cannot redo delete links command");
            }
            this.parents = new BComponent[this.links.length];
            BComponent comp = DeleteLinksCommand.this.ws.controller.container;
            Context tx = Transaction.start((BComponent)comp, null);
            for (int i = 0; i < this.links.length; ++i) {
                this.parents[i] = this.links[i].getParent().asComponent();
                this.parents[i].remove(this.links[i].getPropertyInParent(), tx);
            }
            Transaction.end((BComponent)comp, (Context)tx);
        }

        public void undo() throws Exception {
            BComponent comp = DeleteLinksCommand.this.ws.controller.container;
            Context tx = Transaction.start((BComponent)comp, null);
            for (int i = 0; i < this.links.length; ++i) {
                this.parents[i].add(null, (BValue)this.links[i], tx);
            }
            Transaction.end((BComponent)comp, (Context)tx);
            this.undone = true;
        }
    }
}

