/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.WsConst;
import com.tridium.wiresheet.commands.ArrangeCommand;
import com.tridium.wiresheet.commands.DeleteRelationsCommand;
import com.tridium.wiresheet.commands.EditRelationCommand;
import com.tridium.wiresheet.commands.EditRelationTagsCommand;
import com.tridium.wiresheet.commands.SelectAllCommand;
import com.tridium.wiresheet.commands.ZoomInCommand;
import com.tridium.wiresheet.commands.ZoomOutCommand;
import com.tridium.wiresheet.commands.ZoomResetCommand;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.util.UiLexicon;

public class WsCommands
implements WsConst {
    static boolean lastThumbnailVisible = true;
    public final BWireSheetPane ws;
    public BWidgetShell wsShell;
    public BWsOptions wsOptions;
    public SelectAllCommand selectAll;
    public DeleteRelationsCommand deleteRelations;
    public EditRelationCommand editRelation;
    public EditRelationTagsCommand editRelationTags;
    public ZoomInCommand zoomIn;
    public ZoomOutCommand zoomOut;
    public ZoomResetCommand zoomReset;
    public OptionToggle showThumbnail;
    public OptionToggle showGrid;
    public OptionToggle showStatusColors;
    public ArrangeCommand arrange;
    public OptionToggle showRelations;
    public OptionToggle showLinks;

    public WsCommands(BWireSheetPane ws) {
        this.ws = ws;
    }

    public void init() {
        this.wsShell = this.ws.getShell();
        this.wsOptions = BWsOptions.make();
        this.arrange = new ArrangeCommand(this.ws);
        this.selectAll = new SelectAllCommand(this.ws);
        this.deleteRelations = new DeleteRelationsCommand(this.ws);
        this.editRelation = new EditRelationCommand(this.ws);
        this.editRelationTags = new EditRelationTagsCommand(this.ws);
        this.zoomIn = new ZoomInCommand(this.ws);
        this.zoomOut = new ZoomOutCommand(this.ws);
        this.zoomReset = new ZoomResetCommand(this.ws);
        this.showThumbnail = new OptionToggle(BWsOptions.showThumbnail);
        this.showGrid = new OptionToggle(BWsOptions.showGrid);
        this.showStatusColors = new OptionToggle(BWsOptions.showStatusColors);
        this.showRelations = new OptionToggle(BWsOptions.showRelations);
        this.showLinks = new OptionToggle(BWsOptions.showLinks);
        this.ws.controller.updateTransferStates();
    }

    public BMenu[] getViewMenus() {
        BMenu menu = UiLexicon.bajaui().buildMenu("menu.wireSheet.label");
        menu.add("deleteLinks", (Command)this.deleteRelations);
        menu.add("sep1", (BValue)new BSeparator());
        menu.add("arrange", (Command)this.arrange);
        menu.add("selectAll", (Command)this.selectAll);
        menu.add("sep2", (BValue)new BSeparator());
        menu.add("showThumbnail", (Command)this.showThumbnail);
        menu.add("showGrid", (Command)this.showGrid);
        menu.add("showStatusColors", (Command)this.showStatusColors);
        menu.add("showRelations", (Command)this.showRelations);
        menu.add("showLinks", (Command)this.showLinks);
        return new BMenu[]{menu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        bar.add("zoomIn", (Command)this.zoomIn);
        bar.add("zoomOut", (Command)this.zoomOut);
        bar.add("zoomReset", (Command)this.zoomReset);
        bar.add("sep1", (BValue)new BSeparator());
        bar.add("delLinks", (Command)this.deleteRelations);
        bar.add("showRelations", (Command)this.showRelations);
        return bar;
    }

    public class OptionToggle
    extends WsToggleCommand {
        Property prop;

        public OptionToggle(Property prop) {
            super("commands." + prop.getName());
            this.prop = prop;
            this.setSelected(WsCommands.this.wsOptions.getBoolean(prop));
        }

        public void setSelected(boolean s) {
            super.setSelected(s);
            WsCommands.this.wsOptions.setBoolean(this.prop, s);
            WsCommands.this.ws.repaint();
        }
    }

    public class WsToggleCommand
    extends ToggleCommand {
        public WsToggleCommand(String keyBase) {
            super((BWidget)(WsCommands.this.wsShell != null ? WsCommands.this.wsShell : WsCommands.this.ws), UiLexicon.bajaui().module, keyBase);
        }
    }

    public class WsCommand
    extends Command {
        public WsCommand(String keyBase) {
            super((BWidget)WsCommands.this.wsShell, UiLexicon.bajaui().module, keyBase);
        }
    }
}

