/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wiresheet;

import com.tridium.ui.theme.Theme;
import com.tridium.wiresheet.BWireSheetPane;
import com.tridium.wiresheet.BWsOptions;
import com.tridium.wiresheet.ComponentGlyph;
import com.tridium.wiresheet.LinkGlyph;
import com.tridium.wiresheet.SlotBarGlyph;
import com.tridium.wiresheet.WsController;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelation;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.style.IStylable;

public class PropertyBarGlyph
extends SlotBarGlyph {
    final Property property;
    final boolean isLink;
    final boolean isRelation;
    final boolean isComponent;
    private String valueString = "?";
    LinkGlyph linkGlyph;

    protected PropertyBarGlyph(BWireSheetPane ws, ComponentGlyph parent, BComponent component, Property property) {
        super(ws, parent, component, (Slot)property);
        this.property = property;
        BValue value = component.get(property);
        this.isLink = value instanceof BLink;
        this.isRelation = !this.isLink && value instanceof BRelation;
        this.isComponent = value instanceof BComponent;
    }

    public void updateValueString() {
        BValue value = this.component.get(this.property);
        BFacets facets = this.component.getSlotFacets((Slot)this.property);
        this.valueString = value.toString((Context)new BasicContext(this.ws.context, facets));
        if (value instanceof BIStatus && BWsOptions.make().getShowStatusColors()) {
            BStatus status = ((BIStatus)value).getStatus();
            this.statusBg = (BColor)status.getBackgroundColor(null);
            this.statusFg = (BColor)status.getForegroundColor(null);
        }
        this.repaint();
    }

    @Override
    public void paintValue(Graphics g) {
        double w = g.getFont().width(this.valueString);
        double valueX = Math.max(3.0 + this.nameWidth + 5.0, (double)this.pw - w - 2.0);
        g.drawString(this.valueString, valueX, (double)(this.ws.grid.wixel - 2));
    }

    @Override
    double calcWidth() {
        this.updateValueString();
        BFont font = Theme.wiresheet().glyph().getFont((IStylable)this);
        return super.calcWidth() + WsController.getFont(font, this.ws.grid.wixel - 2).width(this.valueString) + 10.0;
    }
}

