/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx.tab;

import com.tridium.hx.ErrorDialog;
import com.tridium.smartTableHx.BHxFieldSheet;
import com.tridium.smartTableHx.IValidator;
import com.tridium.smartTableHx.SaveCommand;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.HxTabUtil;
import com.tridium.smartTableHx.tab.Tab;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
public abstract class BHxTabbedView
extends BHxView {
    @Generated
    public static final Type TYPE = Sys.loadType(BHxTabbedView.class);
    public static final String DEFAULT_TAB = "defaultTab";
    public static final String PROPERTY_TAB = "propertyTab";
    public static final String FIRST_TAB = "firstTab";
    public static final String TYPE_TAB = "typeTab";
    public static final String NO_HEADER = "noHeader";
    public static final String NO_TITLE = "noTitle";
    public static final BFacets noHeader = BFacets.make((String)"noHeader", (boolean)true);
    public static final BFacets defaultFirstTab = BFacets.make((String)"defaultTab", (String)"firstTab");
    public static final BFacets defaultPropertyTab = BFacets.make((String)"defaultTab", (String)"propertyTab");
    protected SmartCommand save = new Save(this);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxTabbedView() {
        this.registerEvent((Event)this.save);
    }

    public abstract Tab[] getTabs(HxOp var1) throws Exception;

    public BObject getPropertyObject(HxOp op) throws Exception {
        return null;
    }

    public PropertyTab getPropertyTab(HxOp op) throws Exception {
        HxOp propOp = op.make("prop", (OrdTarget)op);
        BObject object = this.getPropertyObject(propOp);
        if (object != null) {
            propOp = op.make("prop", object, null);
        }
        SmartCommand.matchReadonly(propOp, op);
        Lexicon lex = op.getLexicon(this.getType().getTypeSpec().getModuleName());
        return new PropertyTab(BHxFieldSheet.INSTANCE, lex.get(op.get().getType().getTypeSpec().getTypeName() + ".propTabName", op.get().getType().getDisplayName((Context)op)), propOp);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        return new SmartCommand[]{this.save};
    }

    public static void writeResources(HxOp op) throws Exception {
        op.jQuery();
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/tab.js"));
        op.addStyleSheet(BOrd.make((String)"module://smartTableHx/rc/smartTable.css"));
        op.addJavaScript(BOrd.make((String)"module://smartTableHx/rc/smartTable.js"));
        String themeName = (String)op.getRequest().getSession().getAttribute("themeName");
        if (themeName != null) {
            op.addStyleSheet(BOrd.make((String)("module://theme" + themeName + "/ux/theme.css")));
        }
    }

    public String getPageTitle(HxOp op) throws Exception {
        BObject o = op.get();
        String displayName = o.toString((Context)op);
        if (o instanceof BINavNode) {
            displayName = ((BINavNode)o).getNavDisplayName((Context)op);
        }
        return displayName;
    }

    public String getViewPageTitle(HxOp op) throws Exception {
        return this.getType().getDisplayName((Context)op);
    }

    public void writeHeader(HxOp op) throws Exception {
        if (BHxTabbedView.hasHeader(op)) {
            HxTabUtil.writeHeader(this.getPageTitle(op), this.getButtonCommands(op), op);
        }
    }

    public void write(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        BHxTabbedView.writeResources(op);
        this.writeHeader(op);
        Tab[] tabs = this.getTabs(op);
        SmartCommand[] commands = BHxTabbedView.hasHeader(op) ? null : this.getButtonCommands(op);
        int showTab = HxTabUtil.startTabs(tabs, commands, op);
        for (int i = 0; i < tabs.length; ++i) {
            Tab tab = tabs[i];
            HxTabUtil.startTab(tab, showTab == i, tabs.length, out, op);
            tab.write();
            HxTabUtil.endTab(out, op);
        }
        HxTabUtil.endTabs(out, op);
    }

    public BObject save(HxOp op) throws Exception {
        int i;
        BObject o = op.get();
        Tab[] tabs = this.getTabs(op);
        for (i = 0; i < tabs.length; ++i) {
            try {
                if (!(tabs[i].view instanceof IValidator)) continue;
                ((IValidator)tabs[i].view).validate(tabs[i].op);
                continue;
            }
            catch (Exception e) {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)("tab.exception('" + op.scope("label" + SlotPath.escape((String)tabs[i].title)) + "');"));
                throw e;
            }
        }
        for (i = 0; i < tabs.length; ++i) {
            try {
                BObject tabSave = tabs[i].save();
                if (!(tabs[i] instanceof PropertyTab)) continue;
                o = tabSave;
                continue;
            }
            catch (Exception e) {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)("tab.exception('" + op.scope("label" + SlotPath.escape((String)tabs[i].title)) + "');"));
                throw e;
            }
        }
        return o;
    }

    public boolean process(HxOp op) throws Exception {
        if (super.process(op)) {
            return true;
        }
        BObject o = op.get();
        Tab[] tabs = this.getTabs(op);
        for (int i = 0; i < tabs.length; ++i) {
            if (!tabs[i].process()) continue;
            return true;
        }
        SmartCommand[] commands = this.getButtonCommands(op);
        for (int i = 0; i < commands.length; ++i) {
            if (!commands[i].process(op)) continue;
            return true;
        }
        return false;
    }

    public void update(HxOp op) throws Exception {
        super.update(op);
        BObject o = op.get();
        Tab[] tabs = this.getTabs(op);
        for (int i = 0; i < tabs.length; ++i) {
            Tab tab = tabs[i];
            tab.update();
        }
        SmartCommand[] commands = this.getButtonCommands(op);
        for (int i = 0; i < commands.length; ++i) {
            commands[i].update(op);
        }
    }

    public String getSaveConfirmMessage(HxOp op) throws Exception {
        return null;
    }

    public void saved(HxOp op) throws Exception {
        this.save.refresh(op);
    }

    public BFacets getDefaultAddTabFacets(HxOp op) {
        return defaultPropertyTab;
    }

    public static boolean hasHeader(HxOp op) {
        return op.getFacets() == null || !op.getFacets().getb(NO_HEADER, false);
    }

    public static boolean hasTitle(HxOp op) {
        return op.getFacets() == null || !op.getFacets().getb(NO_TITLE, false);
    }

    public static int getDefaultTabIndex(Tab[] tabs, HxOp op) {
        String defaultTab = null;
        if (op.getPath().length() == 0) {
            defaultTab = HxTabUtil.getParam(op.getViewQuery(), DEFAULT_TAB);
        }
        for (int i = 0; i < tabs.length; ++i) {
            Tab tab = tabs[i];
            if (defaultTab != null) {
                if (tab.title == null || !SlotPath.escape((String)tab.title).equals(defaultTab)) continue;
                return i;
            }
            if (op.getFacets().gets(DEFAULT_TAB, FIRST_TAB).equals(PROPERTY_TAB) && tab instanceof PropertyTab) {
                return i;
            }
            if (op.getFacets().gets(DEFAULT_TAB, FIRST_TAB).equals(FIRST_TAB) || !tab.view.getType().getTypeSpec().toString().equals(op.getFacets().gets(DEFAULT_TAB, null))) continue;
            return i;
        }
        return 0;
    }

    public static BFacets getDefaultViewTab(BTypeSpec typeSpec, HxOp op) {
        return BFacets.make((String)DEFAULT_TAB, (String)typeSpec.toString());
    }

    public class RecursivePropertyTab
    extends PropertyTab {
        public Tab extraTab;

        public RecursivePropertyTab(PropertyTab mainTab, Tab extraTab) {
            super(mainTab.view, mainTab.title, mainTab.op);
            this.extraTab = extraTab;
        }

        @Override
        public void write() throws Exception {
            this.op.mergeFacets(BHxFieldSheet.noTableStart);
            this.extraTab.op.mergeFacets(BHxFieldSheet.noTableStart);
            this.op.getHtmlWriter().w((Object)"<table>");
            super.write();
            this.extraTab.write();
            this.op.getHtmlWriter().w((Object)"</table>");
        }

        @Override
        public boolean process() throws Exception {
            return super.process() || this.extraTab.process();
        }
    }

    public class PropertyTab
    extends Tab {
        public PropertyTab(BHxView view, HxOp op) {
            super(view, "", op);
        }

        public PropertyTab(BHxView view, String title, HxOp op) {
            super(view, title, op);
        }

        public PropertyTab(BHxView view, String title, HxOp op, HxOp parentOp) {
            super(view, title, op, parentOp);
        }
    }

    public class Save
    extends SaveCommand {
        public Save(BHxView view) {
            super(view);
        }

        @Override
        public boolean registerOnInputs() {
            return true;
        }

        @Override
        public String getRegistrationElement(HxOp op) {
            String quote = HxUtil.getInnerQuote((HxOp)op);
            return "smartTable.$$(" + quote + op.scope("container") + quote + ")";
        }

        @Override
        public String getConfirmMessage(HxOp op) throws Exception {
            return BHxTabbedView.this.getSaveConfirmMessage(op);
        }

        @Override
        public void onHandle(HxOp op) throws Exception {
            try {
                BHxTabbedView.this.save(op);
                BHxTabbedView.this.saved(op);
            }
            catch (CannotSaveException e) {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"save.pending();");
                e.printStackTrace();
            }
            catch (Exception e) {
                HtmlWriter out = op.getHtmlWriter();
                out.w((Object)"save.pending();");
                new ErrorDialog("Cannot Save", (Command)this, (Throwable)e).open(op);
                e.printStackTrace();
            }
        }
    }
}

