/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.hx.ErrorDialog;
import com.tridium.hx.fieldeditors.BHxStringFE;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.DynamicDialog;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.util.BNameMap;
import javax.baja.util.Lexicon;
import javax.baja.util.LexiconModule;

public class RenameCommand
extends SmartCommand {
    protected RenameCommandDialog dlg = new RenameCommandDialog(this, this.getDisplayName(null));

    public RenameCommand(BHxView view) {
        this(view, smartTableHxLexModule);
    }

    @Deprecated
    public RenameCommand(BHxView view, Lexicon lex) {
        this(view, LexiconModule.make((BModule)lex.module));
    }

    public RenameCommand(BHxView view, LexiconModule lex) {
        super(view, lex);
    }

    @Override
    public String getName(HxOp op) {
        return "rename";
    }

    @Override
    public BCommandEnablePolicy getEnablePolicy() {
        return BCommandEnablePolicy.always;
    }

    public void handle(HxOp op) throws Exception {
        HtmlWriter out = op.getHtmlWriter();
        if (!this.dlg.isSubmit(op)) {
            if (!(this.getView() instanceof BHxSmartTableView)) {
                SmartCommand.setFormValue("renameNeedsSave", "save.isModified()", false, op);
            }
            this.dlg.open(op);
            return;
        }
        String renameNeedsSave = op.getFormValue("renameNeedsSave");
        if (renameNeedsSave != null && renameNeedsSave.equals("true")) {
            out.w((Object)"save.saved();");
            try {
                this.getView().save(op);
            }
            catch (Exception e) {
                new ErrorDialog("Cannot Rename because Cannot Save", (Command)this, (Throwable)e).open(op);
                return;
            }
        }
        BComponent renamed = (BComponent)this.save(op);
        this.completeRename(renamed, op);
    }

    public void completeRename(BComponent renamed, HxOp op) throws Exception {
        this.redirect(op, op.toUri(BOrd.make((String)("station:|" + renamed.getSlotPathOrd()))));
    }

    public BComponent getComponent(HxOp op) {
        return (BComponent)op.get();
    }

    public void renamed(String oldName, String newName, BComponent renamed, HxOp op) {
    }

    public BObject save(HxOp op) throws Exception {
        BComponent c = this.getComponent(op);
        String oldName = c.getName();
        Tab tab = this.getTab(op);
        String newName = tab.save().toString();
        String escaped = SlotPath.escape((String)newName);
        if (c.getDisplayName((Context)op).equals(newName)) {
            return op.get();
        }
        if (c.getPropertyInParent().isFrozen()) {
            String displayNames;
            BComponent parent = c.getParent().asComponent();
            BNameMap nameMap = (BNameMap)parent.get(displayNames = "displayNames");
            if (nameMap == null) {
                parent.add(displayNames, (BValue)BNameMap.make((BNameMap)BNameMap.DEFAULT, (String)c.getName(), (String)newName));
            } else {
                parent.set(displayNames, (BValue)BNameMap.make((BNameMap)nameMap, (String)c.getName(), (String)newName));
            }
        } else {
            c.getParent().asComponent().rename(c.getPropertyInParent(), escaped, (Context)op);
            this.renamed(oldName, escaped, c, op);
        }
        return c;
    }

    @Override
    public boolean process(HxOp op) throws Exception {
        if (!this.matchesScope(op)) {
            return false;
        }
        if (super.process(op)) {
            return true;
        }
        return this.getTab(op).process();
    }

    public Tab getTab(HxOp op) {
        BComponent c = this.getComponent(op);
        BHxStringFE fe = BHxStringFE.INSTANCE;
        String name = SlotPath.unescape((String)c.getName());
        if (c.getPropertyInParent().isFrozen()) {
            name = c.getDisplayName((Context)op);
        }
        HxOp fieldOp = op.make("rename", (BObject)BString.make((String)name), null);
        Tab tab = new Tab((BHxView)fe, "", fieldOp);
        op.addOnload("hx.$('" + fieldOp.scope("value") + "').select();");
        return tab;
    }

    protected class RenameCommandDialog
    extends DynamicDialog {
        RenameCommandDialog(Command handler, String title) {
            super(title, handler);
        }

        protected void writeContent(HxOp op) throws Exception {
            RenameCommand.this.getTab(op).write();
        }
    }
}

