/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.smartTableHx;

import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.tab.HxTabUtil;
import java.io.StringWriter;
import java.io.Writer;
import javax.baja.gx.BImage;
import javax.baja.hx.Command;
import javax.baja.hx.Dialog;
import javax.baja.hx.HxOp;
import javax.baja.hx.HxUtil;
import javax.baja.io.HtmlWriter;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BFacets;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public class JobLogDialog
extends Dialog {
    BJob job;
    static BImage unknown = BImage.make((String)"module://icons/x16/job/unknown.png");
    static BImage running = BImage.make((String)"module://icons/x16/job/running.png");
    static BImage success = BImage.make((String)"module://icons/x16/job/success.png");
    static BImage failed = BImage.make((String)"module://icons/x16/job/failed.png");
    static BImage info = BImage.make((String)"module://icons/x16/info.png");
    static final int UNKNOWN = 1;
    static final int RUNNING = 2;
    static final int CANCELED = 4;
    static final int FAILED = 8;
    static final int SUCCESS = 16;
    public static final String FORCE_DETAILS = "forceDetails";
    public static BFacets forceDetailsFacets = BFacets.make((String)"forceDetails", (boolean)true);
    private static Lexicon lex = Lexicon.make((String)Sys.getModuleForClass(JobLogDialog.class).getModuleName());

    public JobLogDialog(Command handler, BJob job) {
        super(JobLogDialog.getJobDisplayName(job), handler);
        this.job = job;
    }

    public JobLogDialog(Command handler, BJob job, String title) {
        super(title == null ? JobLogDialog.getJobDisplayName(job) : title, handler);
        this.job = job;
    }

    public static String getJobDisplayName(BJob job) {
        String jobName = job.getType().getDisplayName(null);
        if (jobName.endsWith(" Job")) {
            jobName = jobName.substring(0, jobName.length() - 4);
        }
        return jobName;
    }

    public Command[] getCommands() {
        return new Command[]{new Close(), new Export()};
    }

    public static String getJobSummary(BJob job, boolean title) {
        if (job.getJobState() != BJobState.success) {
            return job.getJobState().getDisplayTag(null);
        }
        int errorCount = 0;
        JobLogItem[] items = job.log().getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getId() != 2 && items[i].getId() != 4) continue;
            ++errorCount;
        }
        if (errorCount == 0) {
            return job.getJobState().getDisplayTag(null);
        }
        if (title) {
            return lex.getText("jobDetails");
        }
        return lex.getText("partialSuccess", new Object[]{"" + errorCount});
    }

    public static boolean forceDetails(BJob job, HxOp op) {
        if (job.getJobState() != BJobState.success) {
            return true;
        }
        int errorCount = 0;
        JobLogItem[] items = job.log().getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getId() != 2 && items[i].getId() != 4) continue;
            ++errorCount;
        }
        if (errorCount == 0) {
            return op.getFacets().getb(FORCE_DETAILS, false);
        }
        return true;
    }

    protected void writeContent(HxOp op) throws Exception {
        Lexicon hxLex = Lexicon.make((String)"hx", (Context)op);
        HtmlWriter out = op.getHtmlWriter();
        StringBuilder b = new StringBuilder();
        JobLogItem[] items = this.job.log().getItems();
        for (int i = 0; i < items.length; ++i) {
            String logEncoding = items[i].toString((Context)op);
            logEncoding = TextUtil.replace((String)logEncoding, (String)"\\", (String)"/");
            logEncoding = TextUtil.replace((String)logEncoding, (String)"\n", (String)"<br/>");
            b.append(logEncoding);
            b.append("<br/>");
        }
        String encoding = b.toString();
        BHxSmartTableView.writeFormValue("exportText", encoding, op);
        out.w((Object)"<table>");
        out.w((Object)"<tr>");
        out.w((Object)"<td valign='top' >");
        HxUtil.makeImageJS((BImage)JobLogDialog.getJobStateImage(this.job.getJobState()), null, null, null, (HxOp)op);
        out.w((Object)"</td>");
        out.w((Object)"<td valign='top'>");
        out.w((Object)"<b>").safe((Object)JobLogDialog.getJobSummary(this.job, false)).w((Object)"</b>");
        out.w((Object)"<br/>");
        boolean forceDetails = JobLogDialog.forceDetails(this.job, op);
        if (!forceDetails) {
            out.w((Object)"<span class='error-show-details' id='hx-dialog-error-expand'");
            out.w((Object)"onclick='var details = document.getElementById(&quot;hx-dialog-error-details&quot;);");
            out.w((Object)"var expand = document.getElementById(&quot;hx-dialog-error-expand&quot;);");
            out.w((Object)"if(details.style.display == &quot;none&quot;)");
            out.w((Object)"{details.style.display=&quot;block&quot;; expand.innerHTML=&quot;");
            out.safe((Object)hxLex.getText("hideDetails")).w((Object)"&quot;;}else{ ");
            out.w((Object)"expand.innerHTML=&quot;");
            out.safe((Object)hxLex.getText("showDetails")).w((Object)"&quot;;");
            out.w((Object)"details.style.display=&quot;none&quot;;}hx.resizeCurrentDialog();'");
            out.w((Object)">");
            out.safe((Object)hxLex.getText("showDetails")).w((Object)"</span>");
        }
        out.w((Object)"<div id='hx-dialog-error-details'");
        if (!forceDetails) {
            out.w((Object)" style='display:none;'");
        }
        out.w((Object)">");
        out.w((Object)"<table cellspacing='0'>");
        out.w((Object)"<tr>");
        out.w((Object)"<td ").attr("class", "smartTable-fieldname").w((Object)">");
        out.safe((Object)lex.getText("status"));
        out.w((Object)"</td>");
        out.w((Object)"<td ").attr("class", "smartTable-fieldname").w((Object)">");
        out.safe((Object)lex.getText("timestamp"));
        out.w((Object)"</td>");
        out.w((Object)"<td ").attr("class", "smartTable-fieldname").w((Object)">");
        out.safe((Object)lex.getText("message"));
        out.w((Object)"</td>");
        out.w((Object)"</tr>");
        for (int i = 0; i < items.length; ++i) {
            String cls = "smartTable-row" + (i % 2 == 0 ? "1" : "2");
            out.w((Object)"<tr>");
            out.w((Object)"<td ").attr("class", cls).attr("style", "white-space:nowrap;").w((Object)">");
            HxUtil.makeImageJS((BImage)JobLogDialog.getJobLogItemImage(items[i]), null, null, null, (HxOp)op);
            out.w((Object)" ");
            out.safe((Object)items[i].getIdString((Context)op));
            out.w((Object)"</td>");
            out.w((Object)"<td ").attr("class", cls).attr("style", "white-space:nowrap;").w((Object)">");
            out.safe((Object)items[i].getTimestamp().toString((Context)op));
            out.w((Object)"</td>");
            out.w((Object)"<td ").attr("class", cls).attr("style", "white-space:nowrap;").w((Object)">");
            out.safe((Object)items[i].getMessage((Context)op));
            if (items[i].getDetails((Context)op) != null) {
                out.w((Object)"&nbsp;&nbsp;&nbsp;");
                StringWriter result = new StringWriter();
                HtmlWriter printWriter = new HtmlWriter((Writer)result);
                String details = items[i].getDetails((Context)op);
                details = TextUtil.replace((String)details, (String)"\\", (String)"/");
                details = TextUtil.replace((String)details, (String)"\n", (String)"<br/>");
                StringBuilder a = new StringBuilder();
                a.append("javascript:smartTable.showDialog(&quot;").append(HxTabUtil.safeWithBreaksForJavascript(details));
                a.append("&quot;,&quot;");
                a.append(lex.getText("details"));
                a.append("&quot;,&quot;");
                a.append(lex.getHtmlSafe("done"));
                a.append("&quot;");
                a.append(");");
                out.w((Object)"<span style='cursor:pointer; color:blue; text-decoration:underline;' onclick='").w((Object)a.toString()).w((Object)"'>");
                out.safe((Object)lex.getText("detailsLink"));
                out.w((Object)"</span>");
            }
            out.w((Object)"</td>");
            out.w((Object)"</tr>");
        }
        out.w((Object)"</table>");
        out.w((Object)"</div>");
        out.w((Object)"</td></tr></table>");
    }

    public static BImage getJobLogItemImage(JobLogItem item) {
        boolean state = false;
        switch (item.getId()) {
            case 2: {
                return failed;
            }
            case 4: {
                return failed;
            }
            case 0: {
                return info;
            }
            case 1: {
                return running;
            }
            case 3: {
                return success;
            }
        }
        return null;
    }

    public static BImage getJobStateImage(BJobState jobState) {
        int state = 0;
        switch (jobState.getOrdinal()) {
            case 0: {
                state |= 1;
                break;
            }
            case 1: {
                state |= 2;
                break;
            }
            case 2: 
            case 3: {
                state |= 4;
                break;
            }
            case 5: {
                state |= 8;
                break;
            }
            case 4: {
                state |= 0x10;
            }
        }
        if (state == 0) {
            return null;
        }
        if ((state & 0x10) != 0) {
            return success;
        }
        if ((state & 2) != 0) {
            return running;
        }
        if ((state & 4) != 0) {
            return failed;
        }
        if ((state & 8) != 0) {
            return failed;
        }
        if ((state & 1) != 0) {
            return unknown;
        }
        return null;
    }

    public static class JobLogDialogRefresh
    extends JobLogDialog {
        private BOrd redirect;

        public JobLogDialogRefresh(Command command, BJob job) {
            super(command, job);
        }

        public JobLogDialogRefresh(Command command, BJob job, String title, BOrd redirect) {
            super(command, job, title);
            this.redirect = redirect;
        }

        @Override
        public Command[] getCommands() {
            return new Command[]{new DoneRefresh(), new Export()};
        }

        protected class DoneRefresh
        extends Dialog.Cancel {
            public DoneRefresh() {
                super((Dialog)JobLogDialogRefresh.this);
            }

            public String getDisplayName(HxOp op) {
                return lex.getText("ok");
            }

            public String getInvokeCode(HxOp op) {
                StringBuilder b = new StringBuilder();
                b.append("hx.closeDialog(null,null,null);");
                if (JobLogDialogRefresh.this.redirect == null) {
                    b.append("window.location.reload(true);");
                } else {
                    b.append("window.location=&quot;").append(op.toUri(JobLogDialogRefresh.this.redirect)).append("&quot;;");
                }
                return b.toString();
            }
        }
    }

    public class Export
    extends Dialog.DialogCommand {
        public Export() {
            super((Dialog)JobLogDialog.this, "export");
        }

        public String getDisplayName(HxOp op) {
            return lex.getText("export.label");
        }

        public String getInvokeCode(HxOp op) {
            StringBuilder b = new StringBuilder();
            b.append("var body = hx.$(&quot;");
            b.append(op.scope("exportText"));
            b.append("&quot;).value;");
            b.append("smartTable.showDialog(body, &quot;");
            b.append(lex.getText("export.label"));
            b.append("&quot;, &quot;");
            b.append(lex.getHtmlSafe("ok"));
            b.append("&quot;);");
            return b.toString();
        }
    }

    protected class Close
    extends Dialog.Cancel {
        public Close() {
            super((Dialog)JobLogDialog.this);
        }

        public String getDisplayName(HxOp op) {
            return lex.getText("close");
        }
    }
}

