/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.util;

import com.tridiumX.knxnetIp.util.Queuable;
import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BWorker;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxQueueSize", type="int", defaultValue="Constants.KNXNETIP_WORKER_MAX_QUEUE_SIZE_DEFAULT"), @NiagaraProperty(name="avgQueueTime", type="long", defaultValue="0")})
public class BKnxWorker
extends BWorker {
    public static final Property maxQueueSize = BKnxWorker.newProperty((int)0, (int)5, null);
    public static final Property avgQueueTime = BKnxWorker.newProperty((int)0, (int)0, null);
    public static final Type TYPE = Sys.loadType(BKnxWorker.class);
    private final Object mutex = new Object();
    private CoalesceQueue queue;
    private Worker worker;
    private long dequeued;
    private long totalQueueTime;
    private String workerName = "";
    private static final Logger log = Logger.getLogger(TYPE.getModule().getModuleName());

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    public long getAvgQueueTime() {
        return this.getLong(avgQueueTime);
    }

    public void setAvgQueueTime(long v) {
        this.setLong(avgQueueTime, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BKnxWorker make(String workerName, int queueSize) {
        return BKnxWorker.factory(workerName, queueSize);
    }

    private static BKnxWorker factory(String workerName, int queueSize) {
        BKnxWorker wrk = new BKnxWorker();
        wrk.workerName = workerName;
        wrk.setMaxQueueSize(queueSize);
        return wrk;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (property.equals(maxQueueSize)) {
            if (!this.isRunning()) {
                return;
            }
            this.stopWorker();
            this.queue = null;
            this.worker = null;
            this.getWorker();
            this.startWorker();
        }
    }

    public Worker getWorker() {
        if (this.worker == null) {
            this.queue = new KnxCoalesceQueue(this.getMaxQueueSize());
            this.worker = new Worker((Worker.ITodo)this.queue);
        }
        return this.worker;
    }

    protected String getWorkerThreadName() {
        if (this.workerName.equals("")) {
            return super.getWorkerThreadName();
        }
        return this.workerName;
    }

    public IFuture post(Runnable r) {
        if (!this.isRunning() || this.queue == null) {
            throw new NotRunningException();
        }
        this.queue.enqueue((Object)r);
        return null;
    }

    public int getQueueCount() {
        if (this.queue == null) {
            return 0;
        }
        return this.queue.size();
    }

    public long getDequeuedCount() {
        return this.dequeued;
    }

    public String getWorkerName() {
        return this.getWorkerThreadName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        Object object = this.mutex;
        synchronized (object) {
            Object[] a = this.queue.toArray();
            log.info("BKnxWorker dump (" + a.length + " entries):");
            for (int i = 0; i < a.length; ++i) {
                log.info("" + i + ": " + a[i]);
            }
        }
    }

    class KnxCoalesceQueue
    extends CoalesceQueue {
        public KnxCoalesceQueue(int maxQueueSize) {
            super(maxQueueSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object dequeue() {
            Object entry = super.dequeue();
            if (entry instanceof Queuable) {
                long queueTime = System.currentTimeMillis() - ((Queuable)entry).getEnqueueTime();
                Object object = BKnxWorker.this.mutex;
                synchronized (object) {
                    BKnxWorker.this.totalQueueTime = BKnxWorker.this.totalQueueTime + queueTime;
                    BKnxWorker.this.setAvgQueueTime(BKnxWorker.this.totalQueueTime / ++BKnxWorker.this.dequeued);
                }
            }
            return entry;
        }
    }
}

