/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.point;

import com.tridiumX.knxnetIp.comms.cemi.CemiMessageData;
import com.tridiumX.knxnetIp.knxDataDefs.BDataValueTypeDef;
import com.tridiumX.knxnetIp.point.BKnxProxyExt;
import javax.baja.control.BStringPoint;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BKnxStringProxyExt
extends BKnxProxyExt {
    public static final Type TYPE = Sys.loadType(BKnxStringProxyExt.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BStringPoint;
    }

    @Override
    public BStatusValue decodeFromBytes(CemiMessageData msgData) {
        byte[] b = msgData.data;
        BDataValueTypeDef def = this.getActingDataValueTypeDef();
        if (def != null) {
            def.checkReservedBitsAreZero(b);
            if (!BKnxStringProxyExt.isEncodingFormatValid(def)) {
                throw new IllegalArgumentException("decodeFromBytes() of DataValueType '" + def.getKNX_ID() + "' to '" + this.getParentPoint().getTypeDisplayName(null) + "' is not supported.");
            }
            BValue value = def.bytesToBValue(msgData);
            if (value instanceof BBoolean) {
                return new BStatusString(def.getDefinedFacets().gets(!((BBoolean)value).getBoolean() ? "falseText" : "trueText", !((BBoolean)value).getBoolean() ? "false" : "true"));
            }
            if (value instanceof BDouble) {
                return new BStatusString(value.toString());
            }
            if (value instanceof BInteger) {
                BEnumRange enumRange = def.getEnumRange();
                if (enumRange != null) {
                    return new BStatusString(enumRange.getTag(((BInteger)value).getInt()));
                }
                return new BStatusString(value.toString());
            }
            if (value instanceof BLong) {
                return new BStatusString(value.toString());
            }
            if (value instanceof BString) {
                return new BStatusString(((BString)value).getString());
            }
            throw new IllegalArgumentException("BKnxProxyExt.bytesToBValue() returned an un-expected BValue Type ('" + value.getTypeDisplayName(null) + "') not supported:" + ByteArrayUtil.toHexString((byte[])b, (String)" "));
        }
        throw new IllegalArgumentException("unknown DataValueType in bytesToString(...) (ID = '" + this.getDataValueTypeId() + "') not supported:" + ByteArrayUtil.toHexString((byte[])b, (String)" "));
    }

    @Override
    public CemiMessageData encodeToBytes(BStatusValue statVal) {
        return BKnxStringProxyExt.encodeToCemiMessageData(this.getActingDataValueTypeDef(), statVal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CemiMessageData encodeToCemiMessageData(BDataValueTypeDef def, BStatusValue statVal) {
        if (!(statVal instanceof BStatusString)) {
            throw new IllegalArgumentException("unsupported data type");
        }
        if (def == null) {
            throw new NullPointerException("no DataValueType provided");
        }
        BString value = (BString)statVal.getValueValue();
        String sValue = value.getString();
        BStatus status = statVal.getStatus();
        String sPointType = "a String";
        int iSizeInBits = def.getSizeInBits();
        switch (def.getEncodingFormat().getOrdinal()) {
            case 1: {
                return def.bytesFromBValue((BValue)value, status);
            }
            case 3: {
                if (iSizeInBits == 1) {
                    BFacets facets = def.getDefinedFacets();
                    String trueText = facets.gets("trueText", lex.getText("true"));
                    String falseText = facets.gets("falseText", lex.getText("false"));
                    if (sValue.equalsIgnoreCase(trueText) || sValue.equals("1")) {
                        BBoolean bVal = BBoolean.make((boolean)true);
                        return def.bytesFromBValue((BValue)bVal, status);
                    }
                    if (!sValue.equalsIgnoreCase(falseText) && !sValue.equals("0")) throw new IllegalArgumentException("value ('" + value + "') is not the DeviceFacets.TRUE_TEXT, DeviceFacets.FALSE_TEXT, 'true', 'false', '0' or '1'.");
                    BBoolean bVal = BBoolean.make((boolean)false);
                    return def.bytesFromBValue((BValue)bVal, status);
                }
                BLong lngVal = BLong.DEFAULT;
                try {
                    lngVal = BLong.make((long)Long.parseLong(sValue));
                    return def.bytesFromBValue((BValue)lngVal, status);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("value ('" + value + "') is not a number.");
                }
            }
            case 6: {
                BDouble dVal = BDouble.DEFAULT;
                try {
                    dVal = BDouble.make((double)Double.parseDouble(sValue));
                    return def.bytesFromBValue((BValue)dVal, status);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("value ('" + value + "') cannot be converted to a floating point number.");
                }
            }
            case 8: {
                BInteger intVal = BInteger.DEFAULT;
                if (def.getDataEncodingEnum_ID() > 0) {
                    try {
                        BEnumRange er = def.getEnumRange();
                        BEnum enumVal = er.get(sValue);
                        if (enumVal == null) throw new IllegalArgumentException("data cannot be converted from a String: " + value);
                        intVal = BInteger.make((int)enumVal.getOrdinal());
                        return def.bytesFromBValue((BValue)intVal, status);
                    }
                    catch (Exception ex) {
                        throw new IllegalArgumentException("data cannot be converted from a String: " + value + " - Cause: " + ex);
                    }
                }
                try {
                    intVal = BInteger.make((int)Integer.parseInt(sValue));
                    return def.bytesFromBValue((BValue)intVal, status);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("value ('" + value + "') is not a number.");
                }
            }
            case 11: 
            case 12: {
                BLong lngVal = BLong.DEFAULT;
                try {
                    lngVal = BLong.make((long)Long.parseLong(sValue));
                    return def.bytesFromBValue((BValue)lngVal, status);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("value ('" + value + "') is not a number.");
                }
            }
            case 13: {
                throw new IllegalArgumentException("TODO - encodeToBytes() of 'Z8' Format Encoding in BKnxStringProxyExt - NOT YET IMPLEMENTED!");
            }
            case 15: {
                return def.bytesFromBValue((BValue)value, status);
            }
        }
        throw new IllegalArgumentException("unknown Format Encoding in encodeToBytes() in BKnxStringProxyExt - Ordinal = " + def.getEncodingFormat().getOrdinal());
    }

    private static boolean isEncodingFormatValid(BDataValueTypeDef def) {
        switch (def.getEncodingFormat().getOrdinal()) {
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 15: {
                return true;
            }
            case 13: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown Format Encoding in encodeToBytes() in BKnxStringProxyExt - Ordinal = " + def.getEncodingFormat().getOrdinal());
            }
        }
        return false;
    }
}

