/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.knxDataDefs;

import com.tridiumX.knxnetIp.comms.cemi.CemiMessageData;
import com.tridiumX.knxnetIp.enums.BDateTimeFieldEnum;
import com.tridiumX.knxnetIp.enums.BKnxComObjectSizeEnum;
import com.tridiumX.knxnetIp.knxDataDefs.BEnumDef;
import com.tridiumX.knxnetIp.knxDataDefs.BEnumValueDef;
import com.tridiumX.knxnetIp.knxDataDefs.BFacetDef;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxDataDefs;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxEncodingFormatEnum;
import com.tridiumX.knxnetIp.knxDataDefs.BKnxImportableComponent;
import com.tridiumX.knxnetIp.knxDataDefs.DataIntegrityCalculator;
import com.tridiumX.knxnetIp.knxDataDefs.IDataIntegrity;
import com.tridiumX.knxnetIp.knxDataDefs.KnxCodecFuncs;
import com.tridiumX.knxnetIp.util.Dump;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.units.UnitException;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="kNX_ID", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="dPT_Name", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="comObjectSize", type="BKnxComObjectSizeEnum", defaultValue="BKnxComObjectSizeEnum.DEFAULT", flags=1), @NiagaraProperty(name="mSBitOffset", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="encodingFormat", type="BKnxEncodingFormatEnum", defaultValue="BKnxEncodingFormatEnum.DEFAULT", flags=1), @NiagaraProperty(name="nPTA_ID", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="dataEncodingEnum_ID", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="dateTimeField_ID", type="BDateTimeFieldEnum", defaultValue="BDateTimeFieldEnum.DEFAULT", flags=1), @NiagaraProperty(name="coefficient", type="float", defaultValue="Constants.DEFAULT_COEFFICIENT", flags=1, facets={@Facet(value="BFacets.make(BFacets.PRECISION, 7)")}), @NiagaraProperty(name="characterSet", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="isDateTime", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="variableLength", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="nullTerminated", type="boolean", defaultValue="false", flags=1)})
public final class BDataValueTypeDef
extends BKnxImportableComponent
implements IDataIntegrity {
    public static final Property kNX_ID = BDataValueTypeDef.newProperty((int)1, (String)"", null);
    public static final Property dPT_Name = BDataValueTypeDef.newProperty((int)1, (String)"", null);
    public static final Property comObjectSize = BDataValueTypeDef.newProperty((int)1, (BValue)BKnxComObjectSizeEnum.DEFAULT, null);
    public static final Property mSBitOffset = BDataValueTypeDef.newProperty((int)1, (int)0, null);
    public static final Property encodingFormat = BDataValueTypeDef.newProperty((int)1, (BValue)BKnxEncodingFormatEnum.DEFAULT, null);
    public static final Property nPTA_ID = BDataValueTypeDef.newProperty((int)1, (String)"", null);
    public static final Property dataEncodingEnum_ID = BDataValueTypeDef.newProperty((int)1, (int)0, null);
    public static final Property dateTimeField_ID = BDataValueTypeDef.newProperty((int)1, (BValue)BDateTimeFieldEnum.DEFAULT, null);
    public static final Property coefficient = BDataValueTypeDef.newProperty((int)1, (float)1.0f, (BFacets)BFacets.make((String)"precision", (int)7));
    public static final Property characterSet = BDataValueTypeDef.newProperty((int)1, (String)"", null);
    public static final Property isDateTime = BDataValueTypeDef.newProperty((int)1, (boolean)false, null);
    public static final Property variableLength = BDataValueTypeDef.newProperty((int)1, (boolean)false, null);
    public static final Property nullTerminated = BDataValueTypeDef.newProperty((int)1, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BDataValueTypeDef.class);
    public static final String US_ASCII = "us-ascii";
    public static final String ISO_8859_1 = "iso-8859-1";
    public static final String UTF_8 = "utf-8";

    public String getKNX_ID() {
        return this.getString(kNX_ID);
    }

    public void setKNX_ID(String v) {
        this.setString(kNX_ID, v, null);
    }

    public String getDPT_Name() {
        return this.getString(dPT_Name);
    }

    public void setDPT_Name(String v) {
        this.setString(dPT_Name, v, null);
    }

    public BKnxComObjectSizeEnum getComObjectSize() {
        return (BKnxComObjectSizeEnum)this.get(comObjectSize);
    }

    public void setComObjectSize(BKnxComObjectSizeEnum v) {
        this.set(comObjectSize, (BValue)v, null);
    }

    public int getMSBitOffset() {
        return this.getInt(mSBitOffset);
    }

    public void setMSBitOffset(int v) {
        this.setInt(mSBitOffset, v, null);
    }

    public BKnxEncodingFormatEnum getEncodingFormat() {
        return (BKnxEncodingFormatEnum)this.get(encodingFormat);
    }

    public void setEncodingFormat(BKnxEncodingFormatEnum v) {
        this.set(encodingFormat, (BValue)v, null);
    }

    public String getNPTA_ID() {
        return this.getString(nPTA_ID);
    }

    public void setNPTA_ID(String v) {
        this.setString(nPTA_ID, v, null);
    }

    public int getDataEncodingEnum_ID() {
        return this.getInt(dataEncodingEnum_ID);
    }

    public void setDataEncodingEnum_ID(int v) {
        this.setInt(dataEncodingEnum_ID, v, null);
    }

    public BDateTimeFieldEnum getDateTimeField_ID() {
        return (BDateTimeFieldEnum)this.get(dateTimeField_ID);
    }

    public void setDateTimeField_ID(BDateTimeFieldEnum v) {
        this.set(dateTimeField_ID, (BValue)v, null);
    }

    public float getCoefficient() {
        return this.getFloat(coefficient);
    }

    public void setCoefficient(float v) {
        this.setFloat(coefficient, v, null);
    }

    public String getCharacterSet() {
        return this.getString(characterSet);
    }

    public void setCharacterSet(String v) {
        this.setString(characterSet, v, null);
    }

    public boolean getIsDateTime() {
        return this.getBoolean(isDateTime);
    }

    public void setIsDateTime(boolean v) {
        this.setBoolean(isDateTime, v, null);
    }

    public boolean getVariableLength() {
        return this.getBoolean(variableLength);
    }

    public void setVariableLength(boolean v) {
        this.setBoolean(variableLength, v, null);
    }

    public boolean getNullTerminated() {
        return this.getBoolean(nullTerminated);
    }

    public void setNullTerminated(boolean v) {
        this.setBoolean(nullTerminated, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BDataValueTypeDef || child instanceof BFacetDef || child instanceof BEnumValueDef;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BKnxDataDefs || parent instanceof BDataValueTypeDef;
    }

    @Override
    public void calcDataIntegrity(DataIntegrityCalculator calc) {
        float f;
        String s;
        calc.update(this.getKNX_ID());
        calc.update(this.getDPT_Name());
        calc.update(Integer.toString(this.getComObjectSize().getOrdinal()));
        int iVal = this.getMSBitOffset();
        if (iVal != 0) {
            calc.update(Integer.toString(iVal));
        }
        if ((iVal = this.getEncodingFormat().getOrdinal()) != 0) {
            calc.update(Integer.toString(iVal));
        }
        if ((s = this.getNPTA_ID()) != "") {
            calc.update(s);
        }
        if ((iVal = this.getDataEncodingEnum_ID()) != 0) {
            calc.update(Integer.toString(iVal));
        }
        if ((iVal = this.getDateTimeField_ID().getOrdinal()) != 0) {
            calc.update(Integer.toString(iVal));
        }
        if ((f = this.getCoefficient()) != 1.0f) {
            calc.update(Float.toString(f));
        }
        if ((s = this.getCharacterSet()) != "") {
            calc.update(s);
        }
        if (this.getIsDateTime()) {
            calc.update(Boolean.toString(this.getIsDateTime()));
        }
        if (this.getVariableLength()) {
            calc.update(Boolean.toString(this.getVariableLength()));
        }
        if (this.getNullTerminated()) {
            calc.update(Boolean.toString(this.getNullTerminated()));
        }
        calc.update(this);
    }

    public String getDataValueTypeName() {
        String s = this.getDPT_Name();
        if (this.isAField()) {
            BDataValueTypeDef parentDataValueType = this.getParentDataValueType();
            s = parentDataValueType.getDPT_Name() + '.' + s;
        }
        return s;
    }

    public boolean isDateTime() {
        return this.getIsDateTime();
    }

    public boolean isCompositeDataValueType() {
        this.loadSlots();
        BDataValueTypeDef[] subDataValueTypes = (BDataValueTypeDef[])this.getChildren(BDataValueTypeDef.class);
        return subDataValueTypes.length > 1;
    }

    public boolean isAField() {
        if (this.getParent() == null) {
            throw new IllegalStateException(TYPE.getTypeName() + " must have a parent.");
        }
        return this.getParent() instanceof BDataValueTypeDef;
    }

    public void checkReservedBitsAreZero(byte[] bytes) {
        if (!this.isCompositeDataValueType()) {
            return;
        }
        byte[] mask = this.getMask();
        for (int i = 0; i < mask.length; ++i) {
            if ((bytes[i] & ~mask[i]) == 0) continue;
            throw new IllegalArgumentException("Reserved bits are not zero.");
        }
    }

    private byte[] getMask() {
        int iPacketBytes = this.getByteSizeInPacket();
        byte[] mask = new byte[iPacketBytes];
        if (this.isCompositeDataValueType()) {
            for (BDataValueTypeDef fieldDef : this.getDataValueTypeFieldDefs()) {
                fieldDef.loadSlots();
                byte[] fieldMask = fieldDef.getMask();
                for (int j = 0; j < iPacketBytes; ++j) {
                    int n = j;
                    mask[n] = (byte)(mask[n] | fieldMask[j]);
                }
            }
        } else {
            int iMSBitOffset = this.getBitOffsetFromMSB();
            int iMSByteOffset = iMSBitOffset / 8;
            int iSizeInBytes = this.getSizeInBytes();
            if (iPacketBytes == iSizeInBytes) {
                ByteArrayUtil.memset((byte[])mask, (byte)-1);
            } else {
                int iLSBitOffset = this.getBitOffsetFromLSB();
                int iShift = iLSBitOffset % 8;
                if (iSizeInBytes <= 8) {
                    int iSizeInBits = this.getSizeInBits();
                    long lngMask = iSizeInBits == 64 ? -1L : (1L << iSizeInBits) - 1L;
                    byte[] tempMask = new byte[8];
                    ByteArrayUtil.writeLong((byte[])tempMask, (int)0, (long)lngMask);
                    int iMaskByteOffset = 8 - iSizeInBytes;
                    for (int i = 0; i < iSizeInBytes; ++i) {
                        mask[i + iMSByteOffset] = tempMask[i + iMaskByteOffset];
                    }
                    if (iShift != 0) {
                        int previous = 0;
                        for (int i = iSizeInBytes - 1 + iMSByteOffset; i >= 0; --i) {
                            int val = mask[i];
                            mask[i] = (byte)((val <<= iShift) & 0xFF | previous);
                            previous = (byte)(val >> 8 & 0xFF);
                        }
                    }
                } else {
                    throw new RuntimeException("TODO - implement getMask() for fields greater than 8 bytes in length !!!");
                }
            }
        }
        return mask;
    }

    public int getSizeInBits() {
        int i = this.getComObjectSize().getSizeInBits();
        return i;
    }

    public int getBitOffsetFromMSB() {
        return this.getMSBitOffset();
    }

    public int getBitOffsetFromLSB() {
        int iOffset = 0;
        if (this.isAField()) {
            int iTotalBits = this.getByteSizeInPacket() * 8;
            iOffset = iTotalBits - (this.getMSBitOffset() + this.getSizeInBits());
        }
        return iOffset;
    }

    public int getSizeInBytes() {
        int i = this.getComObjectSize().getSizeInBytes();
        return i;
    }

    public int getByteSizeInPacket() {
        int i = this.getSizeInBits();
        if (this.isAField()) {
            BDataValueTypeDef parentDataValueType = this.getParentDataValueType();
            i = parentDataValueType.getSizeInBits();
        }
        return (i + 7) / 8;
    }

    public int getBitSizeInPacket() {
        int i = this.getSizeInBits();
        if (this.isAField()) {
            BDataValueTypeDef parentDataValueType = this.getParentDataValueType();
            i = parentDataValueType.getSizeInBits();
        }
        return i;
    }

    private BDataValueTypeDef getParentDataValueType() {
        BComplex parent = this.getParent();
        if (parent instanceof BDataValueTypeDef) {
            return (BDataValueTypeDef)parent;
        }
        return null;
    }

    public int getDatapointType(boolean subType) {
        String[] a = TextUtil.split((String)this.getKNX_ID(), (char)'-');
        return new Integer(a[subType ? 2 : 1]);
    }

    public boolean shouldOptimize() {
        BKnxComObjectSizeEnum comObjectSize = this.getComObjectSize();
        if (this.isAField()) {
            BDataValueTypeDef parentDataValueType = this.getParentDataValueType();
            comObjectSize = parentDataValueType.getComObjectSize();
        }
        return comObjectSize.shouldOptimize();
    }

    public BFacets getDefinedFacets(Object source) {
        this.loadSlots();
        if (!this.isCompositeDataValueType() && !this.isAField()) {
            return this.getDataValueTypeFieldDefs()[0].getDefinedFacets(source);
        }
        if (source instanceof BIBoolean) {
            return this.getBooleanDefinedFacets();
        }
        if (source instanceof BINumeric) {
            return this.getNumericDefinedFacets();
        }
        if (source instanceof BIEnum) {
            return this.getEnumDefinedFacets();
        }
        return BFacets.NULL;
    }

    private BFacets getBooleanDefinedFacets() {
        return this.getDefinedFacets(new String[]{"trueText", "falseText"});
    }

    private BFacets getEnumDefinedFacets() {
        return this.getDefinedFacets(new String[]{"range"});
    }

    private BFacets getNumericDefinedFacets() {
        return this.getDefinedFacets(new String[]{"units", "precision", "min", "max"});
    }

    public BFacets getDefinedFacets() {
        this.loadSlots();
        if (!this.isCompositeDataValueType() && !this.isAField()) {
            return this.getDataValueTypeFieldDefs()[0].getDefinedFacets();
        }
        return this.getDefinedFacets(new String[0]);
    }

    private BFacets getDefinedFacets(String[] keys) {
        BFacetDef[] facetDefs;
        Array array = new Array((Object[])keys);
        BFacets facets = BFacets.NULL;
        switch (this.getEncodingFormat().getOrdinal()) {
            case 3: {
                if (this.getSizeInBits() == 1) break;
            }
            case 8: 
            case 11: 
            case 12: {
                if (keys.length != 0 && !array.contains((Object)"precision")) break;
                facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"precision", (int)0));
                break;
            }
            case 6: {
                if (this.getSizeInBytes() != 2 || keys.length != 0 && !array.contains((Object)"precision")) break;
                facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"precision", (int)2));
            }
        }
        for (BFacetDef facetSpec : facetDefs = (BFacetDef[])this.getChildren(BFacetDef.class)) {
            BTypeSpec oTS;
            Object obj;
            facetSpec.loadSlots();
            if (keys.length != 0 && !array.contains((Object)facetSpec.getFacetName()) || !((obj = (oTS = BTypeSpec.make((String)"baja", (String)facetSpec.getFacetType().substring(1))).getInstance()) instanceof BIDataValue)) continue;
            try {
                if (obj instanceof BUnit) {
                    try {
                        obj = BUnit.getUnit((String)facetSpec.getDefaultValue());
                    }
                    catch (UnitException ex) {
                        obj = BUnit.make((String)facetSpec.getDefaultValue(), (String)facetSpec.getDefaultValue(), (BDimension)BDimension.DEFAULT);
                    }
                } else {
                    obj = obj instanceof BInteger ? BInteger.make((String)facetSpec.getDefaultValue()) : (obj instanceof BLong ? BLong.make((String)facetSpec.getDefaultValue()) : (obj instanceof BFloat ? BFloat.make((String)facetSpec.getDefaultValue()) : (obj instanceof BDouble ? BDouble.make((String)facetSpec.getDefaultValue()) : (obj instanceof BString ? BString.make((String)facetSpec.getDefaultValue()) : null))));
                }
                if (obj == null) continue;
                facets = BFacets.make((BFacets)facets, (String)facetSpec.getFacetName(), (BIDataValue)((BIDataValue)obj));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (keys.length == 0 || array.contains((Object)"range")) {
            facets = BFacets.make((BFacets)facets, (String)"range", (BIDataValue)this.getEnumRange());
        }
        return facets;
    }

    private BKnxDataDefs getKnxDataDefs() {
        BComplex parent = this.getParent();
        if (parent instanceof BDataValueTypeDef) {
            parent = parent.getParent();
        }
        if (!(parent instanceof BKnxDataDefs)) {
            return null;
        }
        return (BKnxDataDefs)parent;
    }

    private BEnumDef getEnumDef() {
        if (this.getDataEncodingEnum_ID() > 0) {
            return this.getKnxDataDefs().getEnumDef(this.getDataEncodingEnum_ID());
        }
        return null;
    }

    public BEnumRange getEnumRange() {
        BEnumDef enumDef = this.getEnumDef();
        if (enumDef != null) {
            return enumDef.getEnumRange();
        }
        BEnumValueDef[] enumValues = (BEnumValueDef[])this.getChildren(BEnumValueDef.class);
        int[] ordinals = new int[enumValues.length];
        String[] tags = new String[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            BEnumValueDef enumValue = enumValues[i];
            enumValue.loadSlots();
            ordinals[i] = enumValue.getOrdinal();
            tags[i] = SlotPath.escape((String)enumValue.getTag());
        }
        return BEnumRange.make((int[])ordinals, (String[])tags);
    }

    public BDataValueTypeDef[] getDataValueTypeFieldDefs() {
        this.loadSlots();
        BDataValueTypeDef[] aFieldDefs = (BDataValueTypeDef[])this.getChildren(BDataValueTypeDef.class);
        return aFieldDefs;
    }

    private String getDataValueTypeId() {
        return this.getKNX_ID();
    }

    public BValue bytesToBValue(CemiMessageData msgData) {
        BDataValueTypeDef def = this;
        def.loadSlots();
        if (def.getKNX_ID().equals("")) {
            throw new IllegalStateException("KNX_ID not set");
        }
        if (def.getDPT_Name().equals("")) {
            throw new IllegalStateException("DPT_Name not set");
        }
        if (def.getComObjectSize().getOrdinal() <= 0) {
            throw new IllegalStateException("ComObjectSize not set");
        }
        if (!def.isCompositeDataValueType() && !def.isAField()) {
            if (def.getDataValueTypeFieldDefs().length == 1) {
                return def.getDataValueTypeFieldDefs()[0].bytesToBValue(msgData);
            }
            throw new IllegalStateException("field definition missing.");
        }
        if (def.getEncodingFormat().getOrdinal() <= 0) {
            throw new IllegalStateException("EncodingFormat not set");
        }
        if (def.getByteSizeInPacket() != msgData.data.length && !def.getVariableLength()) {
            throw new IllegalArgumentException("data length (msgData.data[].length = '" + msgData.data.length + "') incorrect for " + def.getDPT_Name() + " (expecting '" + def.getByteSizeInPacket() + "' bytes):" + ByteArrayUtil.toHexString((byte[])msgData.data, (String)" "));
        }
        if (msgData.data.length == 1) {
            if (msgData.sizeInBits < def.getBitSizeInPacket()) {
                throw new IllegalArgumentException("data length ('" + msgData.sizeInBits + "' bits) too small for " + def.getDPT_Name() + " (expecting '" + def.getBitSizeInPacket() + "' bits): " + ByteArrayUtil.toHexString((byte[])msgData.data, (String)" "));
            }
            if (msgData.sizeInBits > 8) {
                throw new IllegalArgumentException("data length ('" + msgData.sizeInBits + "' bits) too big for " + def.getDPT_Name() + " (expecting upto 8 bits): " + ByteArrayUtil.toHexString((byte[])msgData.data, (String)" "));
            }
        } else if (msgData.data.length * 8 != msgData.sizeInBits) {
            throw new IllegalArgumentException("data length ('" + msgData.sizeInBits + "' bits) wrong for " + def.getDPT_Name() + " (expecting '" + def.getBitSizeInPacket() + "' bits): " + ByteArrayUtil.toHexString((byte[])msgData.data, (String)" "));
        }
        int iMSBitOffset = def.getBitOffsetFromMSB();
        int iSizeInBits = def.getSizeInBits();
        if (msgData.sizeInBits < 8 && iMSBitOffset < 8 - msgData.sizeInBits) {
            throw new IllegalArgumentException("iMSBitOffset (" + iMSBitOffset + ") < Constants.BITS_IN_A_BYTE (" + 8 + ") - msgData.sizeInBits (" + msgData.sizeInBits + ")");
        }
        if (!def.getVariableLength() && iMSBitOffset + iSizeInBits > msgData.sizeInBits + (8 - msgData.sizeInBits % 8) % 8) {
            throw new IllegalArgumentException("iMSBitOffset (" + iMSBitOffset + ") + iSizeInBits (" + iSizeInBits + ") > max. MSBit offset (" + (msgData.sizeInBits + (8 - msgData.sizeInBits % 8) % 8) + ")");
        }
        int iSizeInBytes = def.getSizeInBytes();
        int iByteOffset = iMSBitOffset / 8;
        byte[] b = msgData.data;
        switch (def.getEncodingFormat().getOrdinal()) {
            case 1: 
            case 14: {
                return BDataValueTypeDef.bytesToBString(b, iByteOffset, def);
            }
            case 3: {
                if (iSizeInBits == 1) {
                    byte bVal = b[iByteOffset];
                    byte mask = (byte)(128 >>> iMSBitOffset % 8);
                    return BBoolean.make(((bVal = (byte)(bVal & mask)) == mask ? 1 : 0) != 0);
                }
                long val = KnxCodecFuncs.getLongFromBytes(b, iMSBitOffset, iSizeInBits);
                return BLong.make((long)val);
            }
            case 6: {
                if (iSizeInBits != 16 && iSizeInBits != 32) {
                    throw new IllegalArgumentException("Floating Point values of " + iSizeInBits + " bits are not supported. Only 16 bits and 32 bits are valid.");
                }
                if (iMSBitOffset % 8 != 0) {
                    throw new IllegalArgumentException("Floating Point values must be byte aligned.");
                }
                if (iSizeInBytes == 2) {
                    return BDouble.make((double)(KnxCodecFuncs.decodeFloat16FromBytes(b, iByteOffset) * (double)def.getCoefficient()));
                }
                return BDouble.make((double)(KnxCodecFuncs.decodeFloat32FromBytes(b, iByteOffset) * def.getCoefficient()));
            }
            case 8: {
                if (iSizeInBits >= 32) {
                    throw new IllegalArgumentException("Enumeration values of " + iSizeInBits + " bits are not supported. Only 1 bit to 31 bits are valid.");
                }
                int val = KnxCodecFuncs.getIntFromBytes(b, iMSBitOffset, iSizeInBits);
                return BInteger.make((int)val);
            }
            case 11: {
                if (iSizeInBits < 1 || iSizeInBits >= 64) {
                    throw new IllegalArgumentException("Unsigned Integer values of " + iSizeInBits + " bits are not supported. Only 1 bit to 63 bits are valid.");
                }
                if (iSizeInBits >= 32) {
                    long val = KnxCodecFuncs.getLongFromBytes(b, iMSBitOffset, iSizeInBits);
                    if (def.getCoefficient() != 1.0f) {
                        double dblVal = (float)val * def.getCoefficient();
                        double defaultMax = (1L << iSizeInBits) - 1L;
                        double defaultMin = 0.0;
                        double dblMax = def.getDefinedFacets().getd("max", defaultMax);
                        double dblMin = def.getDefinedFacets().getd("min", 0.0);
                        if (dblVal > dblMax || dblVal < dblMin) {
                            throw new IllegalArgumentException("value ('" + dblVal + "') is out of range ('" + dblMin + "' to '" + dblMax + "') for data type " + this.getDataValueTypeId() + ".");
                        }
                        return BDouble.make((double)dblVal);
                    }
                    long defaultMax = (1L << iSizeInBits) - 1L;
                    long defaultMin = 0L;
                    long lngMax = def.getDefinedFacets().getl("max", defaultMax);
                    long lngMin = def.getDefinedFacets().getl("min", 0L);
                    if (val > lngMax || val < lngMin) {
                        throw new IllegalArgumentException("value ('" + val + "') is out of range ('" + lngMin + "' to '" + lngMax + "') for data type " + this.getDataValueTypeId() + ".");
                    }
                    return BLong.make((long)val);
                }
                int val = KnxCodecFuncs.getIntFromBytes(b, iMSBitOffset, iSizeInBits);
                if (def.getCoefficient() != 1.0f) {
                    double dblVal = (float)val * def.getCoefficient();
                    double defaultMax = (1L << iSizeInBits) - 1L;
                    double defaultMin = 0.0;
                    double dblMax = def.getDefinedFacets().getd("max", defaultMax);
                    double dblMin = def.getDefinedFacets().getd("min", 0.0);
                    if (dblVal > dblMax || dblVal < dblMin) {
                        throw new IllegalArgumentException("value ('" + dblVal + "') is out of range ('" + dblMin + "' to '" + dblMax + "') for data type " + this.getDataValueTypeId() + ".");
                    }
                    return BDouble.make((double)dblVal);
                }
                long defaultMax = (1L << iSizeInBits) - 1L;
                long defaultMin = 0L;
                long lngMax = def.getDefinedFacets().getl("max", defaultMax);
                long lngMin = def.getDefinedFacets().getl("min", 0L);
                if ((long)val > lngMax || (long)val < lngMin) {
                    throw new IllegalArgumentException("value ('" + val + "') is out of range ('" + lngMin + "' to '" + lngMax + "') for data type " + this.getDataValueTypeId() + ".");
                }
                switch (this.getDateTimeField_ID().getOrdinal()) {
                    case 1: {
                        if ((val += 1900) >= 1990) break;
                        val += 100;
                        break;
                    }
                    case 7: {
                        val += 1900;
                        break;
                    }
                    case 2: {
                        --val;
                    }
                }
                return BInteger.make((int)val);
            }
            case 12: {
                if (iSizeInBits != 8 && iSizeInBits != 16 && iSizeInBits != 32 && iSizeInBits != 64) {
                    throw new IllegalArgumentException("Signed Intger (2's compliment) values of " + iSizeInBits + " bits are not supported. Only 8, 16, 32 and 64 bits are valid.");
                }
                if (iMSBitOffset % 8 != 0) {
                    throw new IllegalArgumentException("Signed Integer (2's compliment) values must be byte aligned.");
                }
                if (iSizeInBits > 32) {
                    long val = KnxCodecFuncs.getLongFromBytes(b, iMSBitOffset, iSizeInBits);
                    if (iSizeInBits < 64 && (b[iByteOffset] & (byte)(128 >>> iMSBitOffset % 8)) != 0) {
                        long mask = (1L << iSizeInBits) - 1L;
                        val |= mask ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    if (def.getCoefficient() != 1.0f) {
                        double dblVal = (float)val * def.getCoefficient();
                        double defaultMax = BDataValueTypeDef.getSignedIntegerMaximum(iSizeInBits);
                        double defaultMin = BDataValueTypeDef.getSignedIntegerMinimum(iSizeInBits);
                        double dblMax = def.getDefinedFacets().getd("max", defaultMax);
                        double dblMin = def.getDefinedFacets().getd("min", defaultMin);
                        if (dblVal > dblMax || dblVal < dblMin) {
                            throw new IllegalArgumentException("value ('" + dblVal + "') is out of range ('" + dblMin + "' to '" + dblMax + "') for data type " + this.getDataValueTypeId() + ".");
                        }
                        return BDouble.make((double)dblVal);
                    }
                    long defaultMax = BDataValueTypeDef.getSignedIntegerMaximum(iSizeInBits);
                    long defaultMin = BDataValueTypeDef.getSignedIntegerMinimum(iSizeInBits);
                    long lngMax = def.getDefinedFacets().getl("max", defaultMax);
                    long lngMin = def.getDefinedFacets().getl("min", defaultMin);
                    if (val > lngMax || val < lngMin) {
                        throw new IllegalArgumentException("value ('" + val + "') is out of range ('" + lngMin + "' to '" + lngMax + "') for data type " + this.getDataValueTypeId() + ".");
                    }
                    return BLong.make((long)val);
                }
                int val = KnxCodecFuncs.getIntFromBytes(b, iMSBitOffset, iSizeInBits);
                if (iSizeInBits < 32 && (b[iByteOffset] & (byte)(128 >>> iMSBitOffset % 8)) != 0) {
                    int mask = (1 << iSizeInBits) - 1;
                    val |= ~mask;
                }
                if (def.getCoefficient() != 1.0f) {
                    double dblVal = (float)val * def.getCoefficient();
                    double defaultMax = BDataValueTypeDef.getSignedIntegerMaximum(iSizeInBits);
                    double defaultMin = BDataValueTypeDef.getSignedIntegerMinimum(iSizeInBits);
                    double dblMax = def.getDefinedFacets().getd("max", defaultMax);
                    double dblMin = def.getDefinedFacets().getd("min", defaultMin);
                    if (dblVal > dblMax || dblVal < dblMin) {
                        throw new IllegalArgumentException("value ('" + dblVal + "') is out of range ('" + dblMin + "' to '" + dblMax + "') for data type " + this.getDataValueTypeId() + ".");
                    }
                    return BDouble.make((double)dblVal);
                }
                long defaultMax = BDataValueTypeDef.getSignedIntegerMaximum(iSizeInBits);
                long defaultMin = BDataValueTypeDef.getSignedIntegerMinimum(iSizeInBits);
                long lngMax = def.getDefinedFacets().getl("max", defaultMax);
                long lngMin = def.getDefinedFacets().getl("min", defaultMin);
                if ((long)val > lngMax || (long)val < lngMin) {
                    throw new IllegalArgumentException("value ('" + val + "') is out of range ('" + lngMin + "' to '" + lngMax + "') for data type " + this.getDataValueTypeId() + ".");
                }
                return BInteger.make((int)val);
            }
            case 13: {
                if (iSizeInBits != 8) {
                    throw new IllegalArgumentException("'General Status' values of " + iSizeInBits + " bits are not supported. Only 8 bits are valid.");
                }
                int bits = BStatus.ok.getBits();
                byte val = b[iByteOffset];
                if ((val & 1) != 0) {
                    bits |= 4;
                }
                if ((val & 2) != 0) {
                    bits |= 2;
                }
                if ((val & 4) != 0) {
                    bits |= 0x20;
                }
                if ((val & 8) != 0) {
                    bits |= 8;
                }
                if ((val & 0x10) != 0) {
                    bits |= 0x80;
                }
                return BStatus.make((int)bits);
            }
            case 15: {
                String s = ByteArrayUtil.toHexString((byte[])b);
                return BString.make((String)s);
            }
        }
        throw new IllegalArgumentException("unknown Format Encoding in bytesToBValue() - Ordinal = " + def.getEncodingFormat().getOrdinal());
    }

    private static BValue bytesToBString(byte[] bytes, int byteOffset, BDataValueTypeDef def) {
        String charSet = def.getCharacterSet();
        if (charSet.equals("")) {
            charSet = US_ASCII;
        }
        int byteLen = def.getSizeInBytes();
        boolean stringNullTerminated = false;
        int max = charSet.equals(US_ASCII) ? 127 : 255;
        int bytesRead = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (max < 255 && (bytes[i] & 0xFF) > max) {
                throw new IllegalArgumentException("bytes[" + i + "] (" + (bytes[i] & 0xFF) + ") is not valid for character set '" + charSet + '\'');
            }
            if (bytes[i] == 0) {
                byteLen = i;
                stringNullTerminated = true;
                break;
            }
            ++bytesRead;
        }
        if (def.getNullTerminated() && !stringNullTerminated) {
            throw new IllegalArgumentException(String.format("Received string seq not null terminated for type: %s, received bytes: %s", def.getDataValueTypeId(), ByteArrayUtil.toHexString((byte[])bytes)));
        }
        try {
            int bytesToRead = def.getVariableLength() ? Math.min(bytesRead, def.getSizeInBytes()) : byteLen;
            String sData = new String(bytes, byteOffset, bytesToRead, charSet);
            return BString.make((String)sData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("data cannot be converted to a String (using '" + charSet + "' encoding) : " + ByteArrayUtil.toHexString((byte[])bytes));
        }
    }

    public CemiMessageData bytesFromBValue(BValue value, BStatus status) {
        int i;
        byte[] b;
        BDataValueTypeDef def = this;
        def.loadSlots();
        if (def.getKNX_ID().equals("")) {
            throw new IllegalStateException("KNX_ID not set");
        }
        if (def.getDPT_Name().equals("")) {
            throw new IllegalStateException("DPT_Name not set");
        }
        if (def.getComObjectSize().getOrdinal() <= 0) {
            throw new IllegalStateException("ComObjectSize not set");
        }
        if (BDataValueTypeDef.isTestTraceOn()) {
            System.out.println("bytesFromBValue()def = " + Dump.dump((BComplex)def));
        }
        if (!def.isCompositeDataValueType() && !def.isAField()) {
            if (def.getDataValueTypeFieldDefs().length == 1) {
                if (BDataValueTypeDef.isTestTraceOn()) {
                    System.out.println("def.isCompositeDataValueType() == false && def.isAField() == false - DELEGATING to first & only Field Definition");
                }
                return def.getDataValueTypeFieldDefs()[0].bytesFromBValue(value, status);
            }
            throw new IllegalStateException("field definition missing.");
        }
        if (def.getEncodingFormat().getOrdinal() <= 0) {
            throw new IllegalStateException("EncodingFormat not set");
        }
        int iBytesInPacket = def.getByteSizeInPacket();
        int iMSBitOffset = def.getBitOffsetFromMSB();
        int iSizeInBits = def.getSizeInBits();
        int iSizeInBytes = def.getSizeInBytes();
        if (iMSBitOffset + iSizeInBits > iBytesInPacket * 8) {
            throw new IllegalStateException("Invalid DataDef - (iMSBitOffset{" + iMSBitOffset + "} + iSizeInBits{" + iSizeInBits + "}) > (iBytesInPacket{" + iBytesInPacket + "} * Constants.BITS_IN_A_BYTE{" + 8 + "})");
        }
        switch (def.getEncodingFormat().getOrdinal()) {
            case 1: 
            case 14: {
                b = BDataValueTypeDef.bytesFromBString(value, def);
                break;
            }
            case 3: {
                if (iSizeInBits == 1) {
                    boolean bVal;
                    if (!(value instanceof BBoolean)) {
                        BDataValueTypeDef.unsupportedDataTypeForConversion(value, "'B' (Bit)");
                    }
                    if (bVal = ((BIBoolean)value).getBoolean()) {
                        b = new byte[]{1};
                        break;
                    }
                    b = new byte[]{0};
                    break;
                }
                if (!(value instanceof BLong)) {
                    BDataValueTypeDef.unsupportedDataTypeForConversion(value, "'B' (Bit)");
                }
                long lngVal = ((BNumber)value).getLong();
                long defaultMax = (1L << iSizeInBits) - 1L;
                long defaultMin = 0L;
                long lngMax = def.getDefinedFacets().getl("max", defaultMax);
                long lngMin = def.getDefinedFacets().getl("min", defaultMin);
                if (lngVal > lngMax || lngVal < lngMin) {
                    throw new IllegalArgumentException("value ('" + lngVal + "') is out of range ('" + lngMin + "' to '" + lngMax + "') for data type " + this.getDataValueTypeId() + ".");
                }
                b = new byte[iSizeInBytes];
                for (int i2 = iSizeInBytes - 1; i2 >= 0; --i2) {
                    b[i2] = (byte)(lngVal & 0xFFL);
                    lngVal >>>= 8;
                }
                break;
            }
            case 6: {
                if (iSizeInBits != 16 && iSizeInBits != 32) {
                    throw new IllegalArgumentException("Floating Point values of " + iSizeInBits + " bits are not supported. Only 16 bits and 32 bits are valid.");
                }
                if (iMSBitOffset % 8 != 0) {
                    throw new IllegalArgumentException("Floating Point values must be byte aligned.");
                }
                if (!(value instanceof BDouble)) {
                    BDataValueTypeDef.unsupportedDataTypeForConversion(value, "'F' (Floating point number)");
                }
                double fVal = ((BNumber)value).getDouble();
                double defaultMax = Double.MAX_VALUE;
                double defaultMin = -1.7976931348623157E308;
                if (iSizeInBytes == 2) {
                    defaultMax = 670433.28;
                    defaultMin = -671088.64;
                }
                double fMax = def.getDefinedFacets().getd("max", defaultMax);
                double fMin = def.getDefinedFacets().getd("min", defaultMin);
                if ((iSizeInBytes == 2 || Math.abs(fVal) != Double.POSITIVE_INFINITY) && (fVal > fMax || fVal < fMin)) {
                    throw new IllegalArgumentException("value ('" + fVal + "') is out of range ('" + fMin + "' to '" + fMax + "') for data type " + this.getDataValueTypeId() + ".");
                }
                if (iSizeInBytes == 2) {
                    b = KnxCodecFuncs.encodeFloat16ToBytes(fVal / (double)def.getCoefficient());
                    break;
                }
                b = KnxCodecFuncs.encodeFloat32ToBytes(fVal / (double)def.getCoefficient());
                break;
            }
            case 8: {
                if (iSizeInBits >= 32) {
                    throw new IllegalArgumentException("Enumeration values of " + iSizeInBits + " bits are not supported. Only 1 bit to 31 bits are valid.");
                }
                if (!(value instanceof BInteger)) {
                    BDataValueTypeDef.unsupportedDataTypeForConversion(value, "'N' (Enumeration)");
                }
                int intVal = ((BNumber)value).getInt();
                int defaultMax = (1 << iSizeInBits) - 1;
                boolean defaultMin = false;
                int intMax = def.getDefinedFacets().geti("max", defaultMax);
                int intMin = def.getDefinedFacets().geti("min", 0);
                if (intVal > intMax || intVal < intMin) {
                    throw new IllegalArgumentException("value ('" + intVal + "') is out of range ('" + intMin + "' to '" + intMax + "') for data type " + this.getDataValueTypeId() + ".");
                }
                b = new byte[iSizeInBytes];
                for (i = iSizeInBytes - 1; i >= 0; --i) {
                    b[i] = (byte)(intVal & 0xFF);
                    intVal >>>= 8;
                }
                break;
            }
            case 11: {
                if (iSizeInBits < 1 || iSizeInBits >= 64) {
                    throw new IllegalArgumentException("Unsigned Integer values of " + iSizeInBits + " bits are not supported. Only 1 bit to 63 bits are valid.");
                }
                if (!(value instanceof BNumber)) {
                    BDataValueTypeDef.unsupportedDataTypeForConversion(value, "'U' (Unsigned integer)");
                }
                if (BDataValueTypeDef.isTestTraceOn()) {
                    System.out.println("value = " + value);
                }
                long lngVal = 0L;
                if (def.getCoefficient() != 1.0f) {
                    double dblVal = ((BNumber)value).getDouble();
                    double defaultMax = (1L << iSizeInBits) - 1L;
                    double defaultMin = 0.0;
                    double dblMax = def.getDefinedFacets().getd("max", defaultMax);
                    double dblMin = def.getDefinedFacets().getd("min", 0.0);
                    if (dblVal > dblMax || dblVal < dblMin) {
                        throw new IllegalArgumentException("value ('" + dblVal + "') is out of range ('" + dblMin + "' to '" + dblMax + "') for data type " + this.getDataValueTypeId() + ".");
                    }
                    if (def.getCoefficient() != 1.0f) {
                        dblVal /= (double)def.getCoefficient();
                    }
                    lngVal = (long)dblVal;
                    if (BDataValueTypeDef.isTestTraceOn()) {
                        System.out.println("dblVal = " + dblVal);
                        System.out.println("lngVal = " + lngVal);
                    }
                } else {
                    lngVal = ((BNumber)value).getLong();
                    long defaultMax = (1L << iSizeInBits) - 1L;
                    long defaultMin = 0L;
                    long lngMax = def.getDefinedFacets().getl("max", defaultMax);
                    long lngMin = def.getDefinedFacets().getl("min", 0L);
                    switch (this.getDateTimeField_ID().getOrdinal()) {
                        case 1: {
                            if (lngVal >= 2000L) {
                                lngVal -= 100L;
                            }
                            lngVal -= 1900L;
                            break;
                        }
                        case 7: {
                            lngVal -= 1900L;
                            break;
                        }
                        case 2: {
                            ++lngVal;
                        }
                    }
                    if (lngVal > lngMax || lngVal < lngMin) {
                        throw new IllegalArgumentException("value ('" + lngVal + "') is out of range ('" + lngMin + "' to '" + lngMax + "') for data type " + this.getDataValueTypeId() + ".");
                    }
                }
                b = new byte[iSizeInBytes];
                for (int i3 = iSizeInBytes - 1; i3 >= 0; --i3) {
                    b[i3] = (byte)(lngVal & 0xFFL);
                    lngVal >>>= 8;
                }
                break;
            }
            case 12: {
                if (iSizeInBits != 8 && iSizeInBits != 16 && iSizeInBits != 32 && iSizeInBits != 64) {
                    throw new IllegalArgumentException("Signed Intger (2's compliment) values of " + iSizeInBits + " bits are not supported. Only 8, 16, 32 and 64 bits are valid.");
                }
                if (iMSBitOffset % 8 != 0) {
                    throw new IllegalArgumentException("Signed Integer (2's compliment) values must be byte aligned.");
                }
                if (!(value instanceof BLong) && !(value instanceof BInteger)) {
                    BDataValueTypeDef.unsupportedDataTypeForConversion(value, "'V' (Signed integer)");
                }
                long lngVal = 0L;
                if (def.getCoefficient() != 1.0f) {
                    double dblVal = ((BNumber)value).getDouble();
                    double defaultMax = BDataValueTypeDef.getSignedIntegerMaximum(iSizeInBits);
                    double defaultMin = BDataValueTypeDef.getSignedIntegerMinimum(iSizeInBits);
                    double dblMax = def.getDefinedFacets().getd("max", defaultMax);
                    double dblMin = def.getDefinedFacets().getd("min", defaultMin);
                    if ((double)lngVal > dblMax || (double)lngVal < dblMin) {
                        throw new IllegalArgumentException("value ('" + lngVal + "') is out of range ('" + dblMin + "' to '" + dblMax + "') for data type " + this.getDataValueTypeId() + ".");
                    }
                    if (def.getCoefficient() != 1.0f) {
                        dblVal /= (double)def.getCoefficient();
                    }
                    lngVal = (long)dblVal;
                } else {
                    lngVal = ((BNumber)value).getLong();
                    long defaultMax = BDataValueTypeDef.getSignedIntegerMaximum(iSizeInBits);
                    long defaultMin = BDataValueTypeDef.getSignedIntegerMinimum(iSizeInBits);
                    long lngMax = def.getDefinedFacets().getl("max", defaultMax);
                    long lngMin = def.getDefinedFacets().getl("min", defaultMin);
                    if (lngVal > lngMax || lngVal < lngMin) {
                        throw new IllegalArgumentException("value ('" + lngVal + "') is out of range ('" + lngMin + "' to '" + lngMax + "') for data type " + this.getDataValueTypeId() + ".");
                    }
                }
                b = new byte[iSizeInBytes];
                for (int i4 = iSizeInBytes - 1; i4 >= 0; --i4) {
                    b[i4] = (byte)(lngVal & 0xFFL);
                    lngVal >>>= 8;
                }
                if (iSizeInBits % 8 == 0) break;
                byte mask = (byte)((1 << iSizeInBits % 8) - 1);
                b[0] = (byte)(b[0] & mask);
                break;
            }
            case 13: {
                if (!(value instanceof BStatus)) {
                    BDataValueTypeDef.unsupportedDataTypeForConversion(value, "'Z' ('General Status')");
                }
                int bits = ((BStatus)value).getBits();
                byte byteVal = 0;
                if ((bits & 4) != 0) {
                    byteVal = (byte)(byteVal | 1);
                }
                if ((bits & 2) != 0) {
                    byteVal = (byte)(byteVal | 2);
                }
                if ((bits & 0x20) != 0) {
                    byteVal = (byte)(byteVal | 4);
                }
                if ((bits & 8) != 0) {
                    byteVal = (byte)(byteVal | 8);
                }
                if ((bits & 0x80) != 0) {
                    byteVal = (byte)(byteVal | 0x10);
                }
                b = new byte[]{byteVal};
                break;
            }
            case 15: {
                if (!(value instanceof BString)) {
                    BDataValueTypeDef.unsupportedDataTypeForConversion(value, "'H' (Hex string)");
                }
                try {
                    b = ByteArrayUtil.hexStringToBytes((String)((BString)value).getString());
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("value ('" + ((BString)value).getString() + "') is not a valid 'Hex String'.");
                }
                if (b.length == iSizeInBytes) break;
                throw new IllegalArgumentException("value ('" + ((BString)value).getString() + "') is the wrong length.");
            }
            default: {
                throw new IllegalArgumentException("unknown Format Encoding in bytesFromBValue() - Ordinal = " + def.getEncodingFormat().getOrdinal());
            }
        }
        if (b != null) {
            if (BDataValueTypeDef.isTestTraceOn()) {
                System.out.println("Shifting bits into place");
                System.out.println("iBytesInPacket = " + iBytesInPacket);
            }
            int bytesSize = def.getVariableLength() ? b.length : iBytesInPacket;
            byte[] bytes = new byte[bytesSize];
            if (BDataValueTypeDef.isTestTraceOn()) {
                System.out.println("iMSBitOffset = " + iMSBitOffset);
            }
            int iLSBitOffset = def.getBitOffsetFromLSB();
            if (BDataValueTypeDef.isTestTraceOn()) {
                System.out.println("iLSBitOffset = " + iLSBitOffset);
            }
            int iMSByteOffset = bytes.length - b.length - iLSBitOffset / 8;
            if (BDataValueTypeDef.isTestTraceOn()) {
                System.out.println("iMSByteOffset = " + iMSByteOffset);
            }
            if (BDataValueTypeDef.isTestTraceOn()) {
                System.out.println("iSizeInBytes = " + iSizeInBytes);
            }
            if (BDataValueTypeDef.isTestTraceOn()) {
                System.out.println("Copying bytes");
            }
            int bytesToCopy = def.getVariableLength() ? b.length : iSizeInBytes;
            for (i = 0; i < bytesToCopy; ++i) {
                if (BDataValueTypeDef.isTestTraceOn()) {
                    System.out.println("b = [ " + ByteArrayUtil.toHexString((byte[])b, (String)" ") + " ]");
                    System.out.println("bytes = [ " + ByteArrayUtil.toHexString((byte[])bytes, (String)" ") + " ]");
                    System.out.println("i = " + i);
                    System.out.println("bytes[" + (i + iMSByteOffset) + "] = b[" + i + "]");
                }
                bytes[i + iMSByteOffset] = b[i];
            }
            if (BDataValueTypeDef.isTestTraceOn()) {
                System.out.println("Bytes Copied");
                System.out.println("b = [ " + ByteArrayUtil.toHexString((byte[])b, (String)" ") + " ]");
                System.out.println("bytes = [ " + ByteArrayUtil.toHexString((byte[])bytes, (String)" ") + " ]");
            }
            int iShift = iLSBitOffset % 8;
            if (BDataValueTypeDef.isTestTraceOn()) {
                System.out.println("iShift = " + iShift);
            }
            if (iShift != 0) {
                int previous = 0;
                for (int i5 = iSizeInBytes - 1 + iMSByteOffset; i5 >= 0; --i5) {
                    if (BDataValueTypeDef.isTestTraceOn()) {
                        System.out.println("i = " + i5);
                        System.out.println("bytes = [ " + ByteArrayUtil.toHexString((byte[])bytes, (String)" ") + " ]");
                    }
                    int val = bytes[i5] & 0xFF;
                    if (BDataValueTypeDef.isTestTraceOn()) {
                        System.out.println("val = " + Integer.toHexString(val));
                    }
                    val <<= iShift;
                    if (BDataValueTypeDef.isTestTraceOn()) {
                        System.out.println("val = " + Integer.toHexString(val));
                        System.out.println("previous = " + Integer.toHexString(previous));
                    }
                    bytes[i5] = (byte)(val & 0xFF | previous);
                    if (BDataValueTypeDef.isTestTraceOn()) {
                        System.out.println("bytes[i] = " + bytes[i5]);
                    }
                    previous = (byte)(val >> 8 & 0xFF);
                    if (!BDataValueTypeDef.isTestTraceOn()) continue;
                    System.out.println("previous = " + Integer.toHexString(previous));
                }
            }
            if (BDataValueTypeDef.isTestTraceOn()) {
                System.out.println("Bytes Shifted");
                System.out.println("bytes = [ " + ByteArrayUtil.toHexString((byte[])bytes, (String)" ") + " ]");
            }
            CemiMessageData msgData = new CemiMessageData();
            msgData.data = bytes;
            msgData.mask = def.getMask();
            msgData.sizeInBits = def.shouldOptimize() ? 6 : bytes.length * 8;
            return msgData;
        }
        throw new IllegalArgumentException("unknown DataValueType in bytesFromBValue(...) (ID = '" + this.getDataValueTypeId() + "') is not supported: " + value);
    }

    private static byte[] bytesFromBString(BValue value, BDataValueTypeDef def) {
        byte[] sendBytes;
        String s;
        char max;
        if (!(value instanceof BString)) {
            BDataValueTypeDef.unsupportedDataTypeForConversion(value, def.getEncodingFormat().toString());
        }
        String charSet = def.getCharacterSet();
        int iSizeInBytes = def.getSizeInBytes();
        if (charSet.equals("")) {
            charSet = US_ASCII;
        }
        char c = max = charSet.equals(US_ASCII) ? (char)'\u007f' : '\u00ff';
        if (max < '\u00ff') {
            s = ((BString)value).getString();
            for (int i = 0; i < s.length() && i < iSizeInBytes; ++i) {
                if (s.charAt(i) <= max) continue;
                throw new IllegalArgumentException("s.charAt(" + i + ") (" + s.charAt(i) + ") is not valid for character set '" + charSet + "'");
            }
        }
        s = ((BString)value).getString();
        try {
            byte[] stringBytes = s.getBytes(charSet);
            if (stringBytes.length > iSizeInBytes) {
                sendBytes = new byte[iSizeInBytes];
                System.arraycopy(stringBytes, 0, sendBytes, 0, iSizeInBytes);
            } else if (stringBytes.length < iSizeInBytes) {
                int newSize = def.getVariableLength() ? (def.getNullTerminated() ? stringBytes.length + 1 : stringBytes.length) : iSizeInBytes;
                byte[] temp = new byte[newSize];
                System.arraycopy(stringBytes, 0, temp, 0, stringBytes.length);
                sendBytes = temp;
            } else {
                sendBytes = stringBytes;
            }
            if (def.getNullTerminated()) {
                sendBytes[sendBytes.length - 1] = 0;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("data cannot be converted from a String (using unsupported encoding) : " + charSet);
        }
        return sendBytes;
    }

    private static void unsupportedDataTypeForConversion(BValue value, String conversionTo) {
        throw new IllegalArgumentException(String.format("unsupported data type (%s) for conversion to KNX %s type data: %s", value.getTypeDisplayName(null), conversionTo, value));
    }

    private static long getSignedIntegerMinimum(int fieldWidth) {
        if (fieldWidth > 0 && fieldWidth <= 64) {
            return (BDataValueTypeDef.getSignedIntegerMaximum(fieldWidth) + 1L) * -1L;
        }
        throw new IllegalArgumentException("Unsupported 'Signed Integer' size - '" + fieldWidth + "' bits.  Only 1 through 64 are valid field widths for 'Signed Integer' type Datapoint Fields.");
    }

    private static long getSignedIntegerMaximum(int fieldWidth) {
        if (fieldWidth > 0 && fieldWidth <= 64) {
            return (1L << fieldWidth - 1) - 1L;
        }
        throw new IllegalArgumentException("Unsupported 'Signed Integer' size - '" + fieldWidth + "' bits.  Only 1 through 64 are valid field widths for 'Signed Integer' type Datapoint Fields.");
    }

    public static boolean isTestTraceOn() {
        Logger testLog = Logger.getLogger(TYPE.getModule().getModuleName() + ".test");
        if (testLog != null) {
            return testLog.isLoggable(Level.FINE);
        }
        return false;
    }
}

