/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.job;

import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.comms.BKnxHpai;
import com.tridiumX.knxnetIp.comms.BKnxInstallation;
import com.tridiumX.knxnetIp.comms.IDiscoveryListener;
import com.tridiumX.knxnetIp.comms.enums.BConnectionMethods;
import com.tridiumX.knxnetIp.comms.frames.CoreSearchResponse;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.parts.BDeviceInfoDIB;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import com.tridiumX.knxnetIp.enums.BConnectionMethodEnum;
import com.tridiumX.knxnetIp.job.BDiscoveredDevice;
import com.tridiumX.knxnetIp.job.IDevicesJob;
import com.tridiumX.knxnetIp.util.CatchAll;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="learnedDevices", type="BVector", defaultValue="new BVector()")
@NiagaraTopic(name="deviceLearned")
public final class BDiscoverDevicesJob
extends BSimpleJob
implements IDiscoveryListener,
IDevicesJob {
    public static final Property learnedDevices = BDiscoverDevicesJob.newProperty((int)0, (BValue)new BVector(), null);
    public static final Topic deviceLearned = BDiscoverDevicesJob.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BDiscoverDevicesJob.class);
    private BKnxInstallation[] knxInstallations;
    private BKnxInstallation knxInstallationToSearch;
    private final Object searchResponseLock = new Object();

    @Override
    public BVector getLearnedDevices() {
        return (BVector)this.get(learnedDevices);
    }

    public void setLearnedDevices(BVector v) {
        this.set(learnedDevices, (BValue)v, null);
    }

    public void fireDeviceLearned(BValue event) {
        this.fire(deviceLearned, event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDiscoverDevicesJob() {
    }

    public BDiscoverDevicesJob(BKnxInstallation[] knxInstallations, BKnxInstallation knxInstallationToSearch) {
        this.knxInstallations = knxInstallations;
        this.knxInstallationToSearch = knxInstallationToSearch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        if (this.knxInstallations == null) {
            throw new IllegalStateException("Must submit via 'Device Manager'.");
        }
        if (this.knxInstallations.length == 0) {
            throw new IllegalStateException("No 'KNX Installations' found to discover devices on.");
        }
        if (!this.isAlive()) {
            return;
        }
        if (this.knxInstallationToSearch != null && !this.knxInstallationToSearch.getStatus().isOk()) {
            this.logMessage("Cannot search on 'KNX Installation' '" + this.knxInstallationToSearch.getDisplayName(cx) + "' its status = '" + this.knxInstallationToSearch.getStatus() + "'.");
        } else {
            Vector<BKnxInstallation> v = new Vector<BKnxInstallation>(1, 1);
            if (this.knxInstallationToSearch != null && this.knxInstallationToSearch.getStatus().isOk()) {
                v.add(this.knxInstallationToSearch);
            } else {
                for (int i = 1; i < this.knxInstallations.length; ++i) {
                    if (!this.knxInstallations[i].getStatus().isOk()) continue;
                    v.add(this.knxInstallations[i]);
                }
            }
            BKnxInstallation[] knxInstallationsToSearch = v.toArray(new BKnxInstallation[v.size()]);
            if (knxInstallationsToSearch.length == 0) {
                throw new IllegalStateException("No 'KNX Installations' found to discover devices on.");
            }
            try {
                for (int i = 0; i < knxInstallationsToSearch.length; ++i) {
                    try {
                        knxInstallationsToSearch[i].registerMulticastListener(this);
                        this.progress(i * 100 / knxInstallationsToSearch.length + 5 / knxInstallationsToSearch.length);
                        this.discoverKnxDevices(knxInstallationsToSearch, i);
                        continue;
                    }
                    catch (Exception ex) {
                        if (this.getJobState().equals((Object)BJobState.canceling) || this.knxInstallationToSearch != null) {
                            throw new Exception(ex);
                        }
                        this.log().failed("Failed to discover devices on 'KNX Installation' with Id = " + knxInstallationsToSearch[i].getKnxInstallationId(), (Throwable)ex);
                        continue;
                    }
                    finally {
                        knxInstallationsToSearch[i].unregisterMulticastListener(this);
                    }
                }
            }
            catch (Exception ex) {
                throw new Exception(ex);
            }
            finally {
                for (BKnxInstallation installationsToSearch : knxInstallationsToSearch) {
                    installationsToSearch.unregisterMulticastListener(this);
                }
            }
        }
    }

    private void discoverKnxDevices(BKnxInstallation[] knxInstallationsToSearch, int i) throws IOException, InterruptedException {
        BKnxInstallation knxInstallation = knxInstallationsToSearch[i];
        if (knxInstallation.getStatus().isOk()) {
            this.logMessage("sending 'Search Request' on 'KNX Installation' with Id = " + knxInstallation.getKnxInstallationId());
            knxInstallation.sendSearchRequest();
        }
        this.progress(i * 100 / knxInstallationsToSearch.length + 10 / knxInstallationsToSearch.length);
        try {
            for (int j = 1; j <= 10; ++j) {
                Thread.sleep(1000L);
                this.progress(i * 100 / knxInstallationsToSearch.length + (10 + j * 9) / knxInstallationsToSearch.length);
            }
        }
        catch (InterruptedException ex) {
            if (!this.getJobState().equals((Object)BJobState.canceling)) {
                this.logMessage("ERROR - InterruptedException\n" + ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rcvSearchFrame(BKnxInstallation knxInstallation, KnxIpFrame frame) throws IOException {
        if (frame instanceof CoreSearchResponse) {
            CoreSearchResponse searchResponse = (CoreSearchResponse)frame;
            Object object = this.searchResponseLock;
            synchronized (object) {
                this.logMessage("received 'Search Response' on 'KNX Installation' - " + knxInstallation);
                BDiscoveredDevice disc = new BDiscoveredDevice();
                disc.getKnxInstallation().setKnxInstallationIdEnum(BDynamicEnum.make((int)knxInstallation.getKnxInstallationId(), (BEnumRange)this.getEnumRange()));
                if (!knxInstallation.getLocalInterface().isDeviceAccessible(searchResponse.getHpai().getAddress())) {
                    disc.setConnectionMethod(BConnectionMethods.make((BEnum)BConnectionMethodEnum.proxyRouting));
                    disc.setComment("This Device is not directly accessible because its IP subnet differs from the 'KNX Installation's' 'Local Interface'.");
                }
                disc.setIndividualDeviceAddress((BIndividualDeviceAddress)searchResponse.getDeviceInfoDIB().getIndividualAddress().newCopy(true));
                this.logMessage("reading 'Host Protocol Address Information' on 'KNX Installation' - " + knxInstallation);
                disc.setControlHPAI(BKnxHpai.make(searchResponse.getHpai()));
                disc.setIpAddress(disc.getControlHPAI().getIpAddress());
                this.logMessage("reading 'Hardware Description Information Blocks' on 'KNX Installation' - " + knxInstallation);
                BDeviceInfoDIB knxHardwareDib = searchResponse.getDeviceInfoDIB();
                disc.setMacAddress(knxHardwareDib.getMacAddress());
                disc.setFriendlyName(knxHardwareDib.getFriendlyName());
                String slotName = disc.getFriendlyName() + " " + disc.getIpAddress() + " on 'KNX Installation' with Id = " + disc.getKnxInstallation().getKnxInstallationIdEnum().getOrdinal();
                try {
                    this.getLearnedDevices().add(SlotPath.escape((String)slotName), (BValue)disc);
                }
                catch (DuplicateSlotException ex) {
                    try {
                        slotName = slotName + " - Duplicate ?";
                        this.getLearnedDevices().add(SlotPath.escape((String)slotName), (BValue)disc);
                    }
                    catch (Throwable t) {
                        CatchAll.throwable(t);
                    }
                }
                catch (Throwable t) {
                    CatchAll.throwable(t);
                }
                this.logMessage("firing 'DeviceLearned' topic on 'KNX Installation' - " + knxInstallation + " IpAddress=" + disc.getIpAddress() + " IndividualDeviceAddress=" + disc.getIndividualDeviceAddress() + " MacAddress=" + disc.getMacAddress() + " FriendlyName=" + disc.getFriendlyName());
                this.fireDeviceLearned((BValue)disc);
            }
        }
    }

    private BEnumRange getEnumRange() {
        int[] ordinals = new int[this.knxInstallations.length];
        String[] tags = new String[this.knxInstallations.length];
        for (int i = 0; i < this.knxInstallations.length; ++i) {
            String name;
            BKnxInstallation knxInstallation = this.knxInstallations[i];
            if (knxInstallation == null) {
                ordinals[i] = 0;
                tags[i] = SlotPath.escape((String)"No 'KNX Installation' selected");
                continue;
            }
            ordinals[i] = knxInstallation.getKnxInstallationId();
            tags[i] = name = SlotPath.escape((String)(knxInstallation.getDisplayName(null) + " (" + knxInstallation.getLocalInterface().getDisplayName(null) + " (" + knxInstallation.getLocalInterface().getAdapterId().getAdapterId() + "))"));
        }
        return BEnumRange.make((int[])ordinals, (String[])tags);
    }

    private void logMessage(String message) {
        this.log().message(message);
        Logger log = BKnxNetwork.getNetworkLog();
        if (log != null) {
            Level severity = log.getLevel();
            log.setLevel(Level.INFO);
            log.info("Discover Devices Job:" + message);
            log.setLevel(severity);
        }
    }
}

