/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.driver;

import com.tridiumX.knxnetIp.driver.BKnxDevice;
import com.tridiumX.knxnetIp.driver.BKnxNetwork;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDeviceFolder;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BKnxDeviceFolder
extends BDeviceFolder {
    public static final Type TYPE = Sys.loadType(BKnxDeviceFolder.class);
    private static final Logger log = Logger.getLogger(TYPE.getModule().getModuleName());
    private static final String PROBLEM_FINDING_PARENT_DEVICE_NETWORK = "Problem finding parent BDeviceNetwork.";

    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BKnxNetwork || parent instanceof BKnxDeviceFolder;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BKnxDeviceFolder || child instanceof BKnxDevice;
    }

    public void added(Property property, Context context) {
        BKnxNetwork network;
        super.added(property, context);
        if (context != null && !context.equals(Context.decoding) && !context.equals(Context.copying) && property.getType().equals(BKnxDevice.TYPE) && (network = this.getKnxNetwork()) != null) {
            network.deviceAdded((BKnxDevice)this.get(property));
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        super.removed(property, oldValue, context);
        if (property.getType().equals(BKnxDevice.TYPE)) {
            this.checkConfigDeviceIps();
        }
    }

    public void reordered(Context context) {
        super.reordered(context);
        if (this.isRunning()) {
            this.checkConfigDeviceIps();
        }
    }

    private void checkConfigDeviceIps() {
        BKnxNetwork network = this.getKnxNetwork();
        if (network != null) {
            network.checkConfigDeviceIps();
        }
    }

    private BKnxNetwork getKnxNetwork() {
        try {
            return (BKnxNetwork)this.getNetwork();
        }
        catch (Throwable t) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, PROBLEM_FINDING_PARENT_DEVICE_NETWORK, t);
            }
            return null;
        }
    }
}

