/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import java.io.IOException;
import java.util.logging.Level;

public final class RoutingLostMessage
extends KnxIpFrame {
    private int deviceState;
    private int numberOfLostMessages;

    public RoutingLostMessage(EmptyKnxIpFrame inFrame) throws IOException {
        super(inFrame);
        this.fromStream(inFrame.inputStream);
    }

    public RoutingLostMessage(int deviceState, int numberOfLostMessages) {
        this.deviceState = deviceState;
        this.numberOfLostMessages = numberOfLostMessages;
    }

    @Override
    protected BKnxIpFrameTypeEnum getKnxIpFrameType() {
        return BKnxIpFrameTypeEnum.routingLostMessage;
    }

    @Override
    protected int getMinimumFrameLength() {
        return 10;
    }

    @Override
    protected void fromStream(KnxInputStream in) throws IOException {
        try {
            if (in.read() != 4) {
                throw new IOException("incorrect structure length for 'Routing Lost Message Structure'");
            }
            this.deviceState = in.read();
            this.numberOfLostMessages = in.readInt();
        }
        catch (Exception ex) {
            if (RoutingLostMessage.getLogger().isLoggable(Level.FINEST)) {
                ex.printStackTrace();
            }
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toStream(KnxOutputStream out) throws IOException {
        out.write(4);
        out.write(this.deviceState);
        out.writeInt(this.numberOfLostMessages);
    }

    @Override
    protected void toLogString(StringBuffer sb) {
        sb.append("deviceState = " + this.deviceState);
        sb.append(", numberOfLostMessages = " + this.numberOfLostMessages);
    }
}

