/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.BEndPoint;
import com.tridiumX.knxnetIp.comms.BKnxHpai;
import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.enums.BKnxIpFrameValidationResultEnum;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.parts.HostProtocolAddressInformation;
import com.tridiumX.knxnetIp.comms.frames.parts.KnxIpFrameHeader;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Sys;
import javax.baja.util.Lexicon;

public abstract class KnxIpFrame {
    public DatagramPacket packet;
    public BKnxIpFrameValidationResultEnum validationResult = BKnxIpFrameValidationResultEnum.DEFAULT;
    protected KnxInputStream inputStream;
    public KnxIpFrameHeader frameHeader;
    public int rxInterfaceId;
    public InetAddress rxLocalAddress;
    public int rxLocalPort = -1;
    private boolean acked;
    private static final Logger LOG = Logger.getLogger(Sys.getModuleForClass(KnxIpFrame.class).getModuleName() + ".comms.frames");
    private static final Lexicon LEX = Lexicon.make(KnxIpFrame.class);
    private static final String KNX_IP_FRAME_FROM_STREAM_EXCEPTION_MESSAGE_FORMAT_LEX_KEY = "knxIpFrameFromStreamException.message";
    private static final String KNX_IP_FRAME_FROM_STREAM_EXCEPTION_MESSAGE_FORMAT_DEFAULT = "Failed to read ''{0}'' frame from incoming stream.";
    protected static final MessageFormat KNX_IP_FRAME_FROM_STREAM_EXCEPTION_MESSAGE_FORMAT = new MessageFormat(LEX.get("knxIpFrameFromStreamException.message", "Failed to read ''{0}'' frame from incoming stream."));

    protected KnxIpFrame() {
        this.frameHeader = new KnxIpFrameHeader(this.getKnxIpFrameType());
    }

    protected KnxIpFrame(EmptyKnxIpFrame inFrame) {
        this.validationResult = inFrame.validationResult;
        this.packet = inFrame.packet;
        this.frameHeader = inFrame.frameHeader;
        if (inFrame.inputStream.available() < this.getMinimumFrameLength()) {
            this.validationResult = BKnxIpFrameValidationResultEnum.packetTooSmall;
        }
    }

    protected abstract BKnxIpFrameTypeEnum getKnxIpFrameType();

    protected abstract int getMinimumFrameLength();

    protected abstract void fromStream(KnxInputStream var1) throws IOException;

    protected abstract void toStream(KnxOutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] getBytes() throws IOException {
        try (KnxOutputStream out = new KnxOutputStream();){
            this.frameHeader.toStream(out);
            this.toStream(out);
            byte[] bytes = out.toByteArray();
            int length = bytes.length;
            bytes[4] = (byte)(length >>> 8 & 0xFF);
            bytes[5] = (byte)(length & 0xFF);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public static KnxIpFrame make(DatagramPacket packet) {
        EmptyKnxIpFrame frame = new EmptyKnxIpFrame();
        if (packet == null) {
            frame.validationResult = BKnxIpFrameValidationResultEnum.packetIsNull;
        } else {
            frame.packet = packet;
            if (frame.packet.getLength() < 6) {
                frame.validationResult = BKnxIpFrameValidationResultEnum.packetTooSmall;
            } else {
                KnxInputStream in = KnxInputStream.make(frame.packet);
                frame.frameHeader = KnxIpFrameHeader.make(in);
                frame.validationResult = frame.frameHeader.validate();
                if (frame.validationResult.equals((Object)BKnxIpFrameValidationResultEnum.packetIsValid)) {
                    if (in.available() < frame.frameHeader.totalSize - frame.frameHeader.headerSize) {
                        frame.validationResult = BKnxIpFrameValidationResultEnum.incompletePacket;
                    } else {
                        frame.inputStream = in;
                    }
                }
            }
        }
        return frame;
    }

    public DatagramPacket getPacket() {
        return this.packet;
    }

    public boolean isAcked() {
        return this.acked;
    }

    public void setAcked() {
        this.acked = true;
    }

    protected abstract void toLogString(StringBuffer var1);

    public final String toLogString() {
        try {
            StringBuffer sb = new StringBuffer(TextUtil.toUpperCase((String)TextUtil.replace((String)this.getKnxIpFrameType().toString(), (String)" ", (String)"_")) + " [ ");
            this.toLogString(sb);
            sb.append(" ]");
            if (this.packet != null) {
                sb.append(" from Device " + this.packet.getAddress().getHostAddress() + ':' + this.packet.getPort());
            }
            sb.append(this.getInterfaceString());
            return sb.toString();
        }
        catch (Exception ex) {
            KnxIpFrame.getLogger().log(Level.SEVERE, "Failed to build log string for Ip Frame", ex);
            return "{[ Exception :- " + ex + " !!! ]}";
        }
    }

    public final String getLogString() {
        StringBuilder sb = new StringBuilder();
        if (this.packet != null) {
            sb.append("[ " + this.getHexString() + " ] from Device " + this.packet.getAddress().getHostAddress() + ':' + this.packet.getPort());
        }
        sb.append(this.getInterfaceString());
        return sb.toString();
    }

    private String getInterfaceString() {
        if (this.rxInterfaceId != 0) {
            return " via LocalInterfaceId " + this.rxInterfaceId + " - " + this.rxLocalAddress.getHostAddress() + ':' + this.rxLocalPort;
        }
        return "";
    }

    public String getHexString() {
        return ByteArrayUtil.toHexString((byte[])this.packet.getData(), (int)0, (int)this.packet.getLength(), (String)" ");
    }

    public static String getToDeviceLogString(BEndPoint endpoint) {
        try {
            return " to Device " + endpoint.getRemoteInetAddress().getHostAddress() + ":" + endpoint.getRemotePort() + " via LocalInterface " + endpoint.getLocalInetAddress().getHostAddress() + ":" + endpoint.getLocalPort();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "{[ Exception :- " + ex + " !!! ]}";
        }
    }

    public static String getToDeviceLogString(HostProtocolAddressInformation hpai, BEndPoint endpoint) {
        return " to Device " + hpai.getAddress() + ":" + hpai.getPort() + " via LocalInterface " + endpoint.getLocalInetAddress().getHostAddress() + ":" + endpoint.getLocalPort();
    }

    public static String getToDeviceLogString(BKnxHpai remoteControlHpai, BEndPoint endpoint) {
        return " to Device " + remoteControlHpai.getInetAddress().getHostAddress() + ":" + remoteControlHpai.getPort() + " via LocalInterface " + endpoint.getLocalInetAddress().getHostAddress() + ":" + endpoint.getLocalPort();
    }

    protected static Logger getLogger() {
        return LOG;
    }
}

