/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.knxSpec.BKnxErrorCodesEnum;
import java.io.IOException;
import java.util.logging.Level;

public final class CoreDisconnectResponse
extends KnxIpFrame {
    private int channelId = -1;
    private int status = 0;

    public CoreDisconnectResponse() {
    }

    public CoreDisconnectResponse(EmptyKnxIpFrame inFrame) throws IOException {
        super(inFrame);
        this.fromStream(inFrame.inputStream);
    }

    public CoreDisconnectResponse(int channelId, int status) {
        this.channelId = channelId;
        this.status = status;
    }

    @Override
    protected BKnxIpFrameTypeEnum getKnxIpFrameType() {
        return BKnxIpFrameTypeEnum.coreDisconnectResponse;
    }

    @Override
    protected int getMinimumFrameLength() {
        return 8;
    }

    @Override
    protected void fromStream(KnxInputStream stream) throws IOException {
        try {
            this.channelId = stream.read();
            this.status = stream.read();
        }
        catch (Exception ex) {
            if (CoreDisconnectResponse.getLogger().isLoggable(Level.FINEST)) {
                ex.printStackTrace();
            }
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toStream(KnxOutputStream out) throws IOException {
        if (this.channelId == -1) {
            throw new IOException("channelId == KnxSpec.NO_CHANNEL_ID (-1)");
        }
        out.write(this.channelId);
        out.write(this.status);
    }

    @Override
    protected void toLogString(StringBuffer sb) {
        sb.append("Channel_ID = " + this.channelId);
        sb.append(", Status = " + this.status + " - " + BKnxErrorCodesEnum.make(this.status).getDisplayTag(null));
    }

    public int getChannelId() {
        return this.channelId;
    }

    public int getStatus() {
        return this.status;
    }
}

