/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.frames.CoreConnectRequest;
import com.tridiumX.knxnetIp.comms.frames.CoreConnectResponse;
import com.tridiumX.knxnetIp.comms.frames.CoreConnectionStateRequest;
import com.tridiumX.knxnetIp.comms.frames.CoreConnectionStateResponse;
import com.tridiumX.knxnetIp.comms.frames.CoreDescriptionRequest;
import com.tridiumX.knxnetIp.comms.frames.CoreDescriptionResponse;
import com.tridiumX.knxnetIp.comms.frames.CoreDisconnectRequest;
import com.tridiumX.knxnetIp.comms.frames.CoreDisconnectResponse;
import com.tridiumX.knxnetIp.comms.frames.CoreSearchRequest;
import com.tridiumX.knxnetIp.comms.frames.CoreSearchResponse;
import com.tridiumX.knxnetIp.comms.frames.DeviceManagementAck;
import com.tridiumX.knxnetIp.comms.frames.DeviceManagementRequest;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.RoutingBusy;
import com.tridiumX.knxnetIp.comms.frames.RoutingIndication;
import com.tridiumX.knxnetIp.comms.frames.RoutingLostMessage;
import com.tridiumX.knxnetIp.comms.frames.TunnelAck;
import com.tridiumX.knxnetIp.comms.frames.TunnelRequest;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="unknownKnxIpFrameType"), @Range(value="coreSearchRequest", ordinal=513), @Range(value="coreSearchResponse", ordinal=514), @Range(value="coreDescriptionRequest", ordinal=515), @Range(value="coreDescriptionResponse", ordinal=516), @Range(value="coreConnectRequest", ordinal=517), @Range(value="coreConnectResponse", ordinal=518), @Range(value="coreConnectionStateRequest", ordinal=519), @Range(value="coreConnectionStateResponse", ordinal=520), @Range(value="coreDisconnectRequest", ordinal=521), @Range(value="coreDisconnectResponse", ordinal=522), @Range(value="deviceConfigurationRequest", ordinal=784), @Range(value="deviceConfigurationAck", ordinal=785), @Range(value="tunnellingRequest", ordinal=1056), @Range(value="tunnellingAck", ordinal=1057), @Range(value="routingIndication", ordinal=1328), @Range(value="routingLostMessage", ordinal=1329), @Range(value="routingBusy", ordinal=1330)})
public final class BKnxIpFrameTypeEnum
extends BFrozenEnum {
    public static final int UNKNOWN_KNX_IP_FRAME_TYPE = -1;
    public static final int CORE_SEARCH_REQUEST = 513;
    public static final int CORE_SEARCH_RESPONSE = 514;
    public static final int CORE_DESCRIPTION_REQUEST = 515;
    public static final int CORE_DESCRIPTION_RESPONSE = 516;
    public static final int CORE_CONNECT_REQUEST = 517;
    public static final int CORE_CONNECT_RESPONSE = 518;
    public static final int CORE_CONNECTION_STATE_REQUEST = 519;
    public static final int CORE_CONNECTION_STATE_RESPONSE = 520;
    public static final int CORE_DISCONNECT_REQUEST = 521;
    public static final int CORE_DISCONNECT_RESPONSE = 522;
    public static final int DEVICE_CONFIGURATION_REQUEST = 784;
    public static final int DEVICE_CONFIGURATION_ACK = 785;
    public static final int TUNNELLING_REQUEST = 1056;
    public static final int TUNNELLING_ACK = 1057;
    public static final int ROUTING_INDICATION = 1328;
    public static final int ROUTING_LOST_MESSAGE = 1329;
    public static final int ROUTING_BUSY = 1330;
    public static final BKnxIpFrameTypeEnum unknownKnxIpFrameType = new BKnxIpFrameTypeEnum(-1);
    public static final BKnxIpFrameTypeEnum coreSearchRequest = new BKnxIpFrameTypeEnum(513);
    public static final BKnxIpFrameTypeEnum coreSearchResponse = new BKnxIpFrameTypeEnum(514);
    public static final BKnxIpFrameTypeEnum coreDescriptionRequest = new BKnxIpFrameTypeEnum(515);
    public static final BKnxIpFrameTypeEnum coreDescriptionResponse = new BKnxIpFrameTypeEnum(516);
    public static final BKnxIpFrameTypeEnum coreConnectRequest = new BKnxIpFrameTypeEnum(517);
    public static final BKnxIpFrameTypeEnum coreConnectResponse = new BKnxIpFrameTypeEnum(518);
    public static final BKnxIpFrameTypeEnum coreConnectionStateRequest = new BKnxIpFrameTypeEnum(519);
    public static final BKnxIpFrameTypeEnum coreConnectionStateResponse = new BKnxIpFrameTypeEnum(520);
    public static final BKnxIpFrameTypeEnum coreDisconnectRequest = new BKnxIpFrameTypeEnum(521);
    public static final BKnxIpFrameTypeEnum coreDisconnectResponse = new BKnxIpFrameTypeEnum(522);
    public static final BKnxIpFrameTypeEnum deviceConfigurationRequest = new BKnxIpFrameTypeEnum(784);
    public static final BKnxIpFrameTypeEnum deviceConfigurationAck = new BKnxIpFrameTypeEnum(785);
    public static final BKnxIpFrameTypeEnum tunnellingRequest = new BKnxIpFrameTypeEnum(1056);
    public static final BKnxIpFrameTypeEnum tunnellingAck = new BKnxIpFrameTypeEnum(1057);
    public static final BKnxIpFrameTypeEnum routingIndication = new BKnxIpFrameTypeEnum(1328);
    public static final BKnxIpFrameTypeEnum routingLostMessage = new BKnxIpFrameTypeEnum(1329);
    public static final BKnxIpFrameTypeEnum routingBusy = new BKnxIpFrameTypeEnum(1330);
    public static final BKnxIpFrameTypeEnum DEFAULT = unknownKnxIpFrameType;
    public static final Type TYPE = Sys.loadType(BKnxIpFrameTypeEnum.class);

    public static BKnxIpFrameTypeEnum make(int ordinal) {
        return (BKnxIpFrameTypeEnum)unknownKnxIpFrameType.getRange().get(ordinal, false);
    }

    public static BKnxIpFrameTypeEnum make(String tag) {
        return (BKnxIpFrameTypeEnum)unknownKnxIpFrameType.getRange().get(tag);
    }

    private BKnxIpFrameTypeEnum(int ordinal) {
        super(ordinal);
    }

    public Type getType() {
        return TYPE;
    }

    public static KnxIpFrame makeTypedFrame(KnxIpFrame frame) throws IOException {
        BKnxIpFrameTypeEnum frameType = frame.frameHeader.frameType;
        switch (frameType.getOrdinal()) {
            case 513: {
                return new CoreSearchRequest((EmptyKnxIpFrame)frame);
            }
            case 514: {
                return new CoreSearchResponse((EmptyKnxIpFrame)frame);
            }
            case 515: {
                return new CoreDescriptionRequest((EmptyKnxIpFrame)frame);
            }
            case 516: {
                return new CoreDescriptionResponse((EmptyKnxIpFrame)frame);
            }
            case 517: {
                return new CoreConnectRequest((EmptyKnxIpFrame)frame);
            }
            case 518: {
                return new CoreConnectResponse((EmptyKnxIpFrame)frame);
            }
            case 519: {
                return new CoreConnectionStateRequest((EmptyKnxIpFrame)frame);
            }
            case 520: {
                return new CoreConnectionStateResponse((EmptyKnxIpFrame)frame);
            }
            case 521: {
                return new CoreDisconnectRequest((EmptyKnxIpFrame)frame);
            }
            case 522: {
                return new CoreDisconnectResponse((EmptyKnxIpFrame)frame);
            }
            case 784: {
                return new DeviceManagementRequest((EmptyKnxIpFrame)frame);
            }
            case 785: {
                return new DeviceManagementAck((EmptyKnxIpFrame)frame);
            }
            case 1056: {
                return new TunnelRequest((EmptyKnxIpFrame)frame);
            }
            case 1057: {
                return new TunnelAck((EmptyKnxIpFrame)frame);
            }
            case 1328: {
                return new RoutingIndication((EmptyKnxIpFrame)frame);
            }
            case 1329: {
                return new RoutingLostMessage((EmptyKnxIpFrame)frame);
            }
            case 1330: {
                return new RoutingBusy((EmptyKnxIpFrame)frame);
            }
        }
        return null;
    }
}

