/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.ui.file;

import com.tridium.excel.ui.ExcelUiUtils;
import com.tridium.template.api.NiagaraTemplate;
import com.tridium.template.file.NtplUtil;
import com.tridium.template.ui.BulkDeployUtil;
import com.tridium.template.ui.file.BExportConfigsPasswordPrompt;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.security.BPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.Localizable;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.util.UiLexicon;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;

public class ExportApplicationCommand
extends Command {
    private final BStation station;
    private static final Lexicon lex = Lexicon.make((String)"template");
    private static final Logger log = Logger.getLogger("ntpl");
    private static BOrd exportDirectoryOrd;

    public ExportApplicationCommand(BWidget owner, BStation station) {
        super(owner, (Lexicon)UiLexicon.bajaui(), "commands.exportApplication");
        this.station = station;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommandArtifact doInvoke() throws Exception {
        if (ExcelUiUtils.informIfNoExcelSupportIsInstalledLocally(this.getOwner())) {
            return null;
        }
        try (NiagaraTemplate template = NiagaraTemplate.open((BComponent)this.station);){
            String filename2;
            BDirectory applicationDirectory;
            if (template == null) {
                CommandArtifact commandArtifact = null;
                return commandArtifact;
            }
            if (exportDirectoryOrd == null && (applicationDirectory = NtplUtil.getApplicationDirectory()) != null) {
                exportDirectoryOrd = NtplUtil.getApplicationDirectory().getAbsoluteOrd();
            }
            BFileChooser chooser = BFileChooser.makeSave((BWidget)this.getOwner());
            chooser.setDefaultFileName(this.station.getStationName() + ".xlsx");
            chooser.setCurrentDirectory(exportDirectoryOrd);
            BulkDeployUtil deployUtil = new BulkDeployUtil();
            boolean passwordsInTemplates = template.hasSensitiveDataConfig();
            BIFile exportPath = null;
            while (exportPath == null) {
                BOrd ord = chooser.show();
                if (ord == null) {
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                BIFile candidateExportPath = (BIFile)ord.resolve().get();
                if (passwordsInTemplates && candidateExportPath.getExtension().equalsIgnoreCase("xls")) {
                    filename2 = candidateExportPath.getFileName();
                    filename2 = filename2.substring(0, filename2.length() - "xls".length()) + "xlsx";
                    try {
                        candidateExportPath.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    BDialog.warning((BWidget)this.getOwner(), (String)lex.getText("bulkDeploy.excelExport.insecureFile.title"), (Object)lex.getText("bulkDeploy.excelExport.insecureFile.message"));
                    chooser.setDefaultFileName(filename2);
                    chooser.setCurrentDirectory(ord.getParent());
                    continue;
                }
                exportDirectoryOrd = ord;
                exportPath = candidateExportPath;
            }
            BPassword encryptPassword = null;
            boolean strongPassword = false;
            do {
                if ((encryptPassword = BExportConfigsPasswordPrompt.getPassword(this.getOwner(), passwordsInTemplates, encryptPassword != null)) == BExportConfigsPasswordPrompt.DLG_CANCELLED) {
                    try {
                        exportPath.delete();
                    }
                    catch (Exception filename2) {
                        // empty catch block
                    }
                    filename2 = null;
                    return filename2;
                }
                if (encryptPassword == null) continue;
                boolean bl = strongPassword = !encryptPassword.isDefault();
                if (!strongPassword) {
                    BDialog.error((BWidget)this.getOwner(), (String)lex.getText("bulkDeploy.excelExport.invalidPassword.title"), (Object)lex.getText("bulkDeploy.excelExport.invalidPassword.message"));
                    continue;
                }
                AtomicReference messageReference = new AtomicReference();
                strongPassword = BPasswordStrength.DEFAULT.isPasswordValid(encryptPassword.getValue().toCharArray(), messageReference::set);
                if (strongPassword) continue;
                BDialog.error((BWidget)this.getOwner(), (String)lex.getText("bulkDeploy.excelExport.invalidPassword.title"), (Object)((Localizable)messageReference.get()).toString(null));
            } while (encryptPassword != null && !strongPassword);
            StringBuilder replyMessage = new StringBuilder();
            File exportFile = deployUtil.exportApplicationTemplateToExcel(exportPath, encryptPassword, template, replyMessage);
            if (exportFile == null) {
                log.log(Level.WARNING, lex.getText("bulkDeploy.excelExport.exportError"));
                BDialog.error((BWidget)this.getOwner(), (String)lex.getText("templateSideBar.exportConfigsFailure"), (Object)BString.make((String)(lex.getText("templateSideBar.exportConfigsFailure.fileExported", new Object[]{exportPath.getFileName()}) + "\n" + replyMessage.toString())));
                File exportBase = BFileSystem.INSTANCE.pathToLocalFile(exportPath.getFilePath());
                if (exportBase == null) {
                    CommandArtifact commandArtifact = null;
                    return commandArtifact;
                }
                exportFile = new File(exportBase.getParent(), exportBase.getName());
                if (exportFile.length() == 0L) {
                    exportFile.delete();
                }
                CommandArtifact commandArtifact = null;
                return commandArtifact;
            }
            BDialog.info((BWidget)this.getOwner(), (String)lex.getText("templateSideBar.exportConfigs"), (Object)BString.make((String)lex.getText("templateSideBar.exportConfigs.fileExported", new Object[]{exportFile.getName()})));
            return null;
        }
        catch (Exception e) {
            log.log(Level.WARNING, lex.getText("bulkDeploy.excelExport.exportError"), e);
        }
        return null;
    }
}

