/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.sun.security.jgss.GSSUtil;
import com.tridium.authn.AuthenticationClient;
import com.tridium.fox.kerberos.KerberosCallbackHandler;
import com.tridium.fox.kerberos.KerberosConfig;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.session.FoxAuthenticationException;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.ldap.BLdapConfig;
import com.tridium.ldap.v3.BKerberosConfig;
import com.tridium.ldap.v3.GSSDelegCredAction;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Level;
import javax.baja.fox.authn.BFoxClientAuthnHandler;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationRealm;
import javax.baja.security.BICredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.security.BUsernameCredential;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.BIObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;

@NiagaraType(agent={@AgentOn(types={"ldap:KerberosAuthenticationScheme"})})
public class BFoxKerbClientAuthnHandler
extends BFoxClientAuthnHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxKerbClientAuthnHandler.class);
    private static final int USERNAME_PASSWORD_STEP = 0;
    private BKerberosCredentials kerbCredentials = null;
    private BUsernameCredential username = null;
    private BICredentials credentials = null;
    protected static final Lexicon lex = Lexicon.make((String)"ldap");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void handleAuthentication(FoxSession session, AuthenticationClient authenticationClient) throws Exception {
        session.setState("client.tune receiveKInfo");
        FoxMessage kInfo = session.receiveTuning("kInfo");
        String serv = kInfo.getString("server");
        String kRealm = kInfo.getString("realm");
        String kdc = kInfo.getString("kdc");
        String server = serv + "@" + kRealm;
        AccessController.doPrivileged(() -> {
            System.setProperty("java.security.krb5.realm", kRealm);
            System.setProperty("java.security.krb5.kdc", kdc);
            BKerberosConfig.setKrb5ConfLocation();
            return null;
        });
        try {
            new LoginContext("com.tridium.workbench.auth.WbAuthenticationClient", null, null, (Configuration)new KerberosConfig(true, true)).login();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.kerbCredentials != null) {
            Subject sub = GSSUtil.createSubject(this.kerbCredentials.getCredential().getName(), this.kerbCredentials.getCredential());
            AccessController.doPrivileged(() -> {
                Subject.doAs(sub, new GSSDelegCredAction(server, session));
                return null;
            });
        } else {
            BFoxClientConnection foxClientConnection = (BFoxClientConnection)session.conn();
            BFoxSession realm = foxClientConnection.getFoxSession();
            BUsernameAndPassword seedCredential = new BUsernameAndPassword(this.username.getUsername(), BPassword.DEFAULT);
            String scheme = foxClientConnection.getAuthenticationScheme();
            if (this.credentials == null) {
                this.credentials = authenticationClient.requestInformation((AuthenticationRealm)realm, scheme, 0, (BIObject)seedCredential);
            }
            if (this.credentials == null) {
                throw new FoxAuthenticationException("Cancelled", scheme, null, session);
            }
            if (!(this.credentials instanceof BUsernameAndPassword)) {
                throw new FoxAuthenticationException(Lexicon.make((String)"ldap").getText("ldap.kerberos.authnHandler.unsupportedCredentials", new Object[]{this.credentials.getType()}), scheme, null, session);
            }
            BUsernameAndPassword cred = (BUsernameAndPassword)this.credentials;
            try {
                String username = cred.getUsername() + "@" + kRealm;
                LoginContext lc = BFoxKerbClientAuthnHandler.kerberosClientLogin(username, AccessController.doPrivileged(() -> ((BPassword)cred.getPassword()).getValue()));
                AccessController.doPrivileged(() -> {
                    Subject.doAs(lc.getSubject(), new GSSDelegCredAction(server, session));
                    return null;
                });
                lc.logout();
            }
            catch (Exception e) {
                BLdapConfig.logException(lex.getText("kerberos.gss.couldNotDelegate"), e, Level.SEVERE);
                GSSDelegCredAction.sendErrorToken(session);
            }
        }
    }

    public void setData(BIObject data) {
        if (data instanceof BKerberosCredentials) {
            this.kerbCredentials = (BKerberosCredentials)data;
        } else if (data instanceof BUsernameCredential) {
            this.username = (BUsernameCredential)data;
        } else {
            throw new UnsupportedOperationException("Data type not supported.");
        }
    }

    private static LoginContext kerberosClientLogin(String username, String password) throws PrivilegedActionException {
        KerberosConfig kerberosConfig = new KerberosConfig(username);
        return (LoginContext)AccessController.doPrivileged(() -> BFoxKerbClientAuthnHandler.lambda$kerberosClientLogin$3(username, password, (Configuration)kerberosConfig));
    }

    private static /* synthetic */ Object lambda$kerberosClientLogin$3(String username, String password, Configuration kerberosConfig) throws Exception {
        LoginContext temp = new LoginContext("com.tridium.ldap.authn.BFoxKerbClientAuthnHandler", null, (CallbackHandler)new KerberosCallbackHandler(username, password), kerberosConfig);
        temp.login();
        return temp;
    }
}

