/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import java.security.PrivilegedExceptionAction;
import java.util.Base64;
import java.util.logging.Logger;
import javax.baja.security.BUsernameCredential;
import javax.baja.util.Lexicon;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

public class AcquireHttpCredentialsAction
implements PrivilegedExceptionAction<Object> {
    private Logger logger = Logger.getLogger("ldap");
    protected static final Lexicon lex = Lexicon.make((String)"ldap");
    private String b64Token;

    public AcquireHttpCredentialsAction(String b64Token) {
        this.b64Token = b64Token;
    }

    @Override
    public Object run() throws Exception {
        this.logger.fine(lex.getText("ldap.kerberos.acquireHttpCreds"));
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        GSSManager manager = GSSManager.getInstance();
        GSSContext context = manager.createContext((GSSCredential)null);
        byte[] token = Base64.getDecoder().decode(this.b64Token);
        context.acceptSecContext(token, 0, token.length);
        if (!context.isEstablished()) {
            throw new Exception(lex.getText("ldap.error.couldNotAcquireHttpCreds"));
        }
        this.logger.fine(lex.getText("ldap.kerberos.acquiredHttpCreds"));
        String username = context.getSrcName().toString();
        if (username.contains("@")) {
            username = username.substring(0, username.indexOf("@"));
        }
        return new BUsernameCredential(username);
    }
}

