/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.fox;

import com.tridium.fox.message.FoxMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.fox.MessageClient;
import java.util.HashMap;
import java.util.Map;

public class TaskListenerClient
implements MessageClient {
    public Map<Integer, DaemonSessionTask> tasks = new HashMap<Integer, DaemonSessionTask>();
    public DaemonSessionTaskListener listener;

    public TaskListenerClient(DaemonSessionTaskListener pListener) {
        this.listener = pListener == null ? DaemonSessionTaskListener.NULL_TASK_LISTENER : pListener;
    }

    @Override
    public boolean handleMessage(FoxMessage message) throws Exception {
        if ("taskStatus".equals(message.getString("type"))) {
            switch (message.getString("id")) {
                case "started": {
                    DaemonSessionTask task = new DaemonSessionTask(message.getString("title"), message.getString("message"), message.getInt("total"));
                    task.setImmediate(message.getBoolean("immediate"));
                    this.tasks.put(message.getInt("taskindex"), task);
                    this.listener.taskStarted(task);
                    break;
                }
                case "updated": {
                    DaemonSessionTask task = this.tasks.get(message.getInt("taskindex"));
                    if (task == null) break;
                    task.setImmediate(message.getBoolean("immediate"));
                    task.setProgress(message.getInt("progress"));
                    task.setMessage(message.getString("message"));
                    this.listener.taskUpdated(task);
                    break;
                }
                case "finished": {
                    DaemonSessionTask task = this.tasks.get(message.getInt("taskindex"));
                    if (task == null) break;
                    this.listener.taskFinished(task);
                    this.tasks.remove(message.getInt("taskindex"));
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.tasks.values().forEach(this.listener::taskFinished);
    }
}

