/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.nre.security.io.PBEEncryptingOutputStream;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileFileTransferElement;
import com.tridium.platform.daemon.message.FileTransferMessageElement;
import com.tridium.platform.daemon.message.MkDirFileTransferMessageElement;
import com.tridium.platform.daemon.message.RenameFileTransferMessageElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.FilePath;
import javax.baja.nre.util.FileUtil;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BajaRuntimeException;

public class FileTransferMessage {
    private static final Map<String, Integer> ORDINAL_OF_METHOD = new HashMap<String, Integer>();
    private final Map<FilePath, FileTransferMessageElement> deletesByFilePath;
    private final List<FileTransferMessageElement> postsAndMkDirs;
    private final boolean autoCommit;
    private String transactionId = null;
    private long transferTotal = 0L;
    private long transferComplete = 0L;
    private final StoreCache cache;
    private final BDaemonFileSpace fileSpace;
    private PBEEncodingInfo pbeEncodingInfo = null;

    public static FileTransferMessage make(BIFile file, BDaemonFileSpace space) throws IOException {
        FileTransferMessage result = new FileTransferMessage(space);
        result.addFile(file);
        return result;
    }

    public static FileTransferMessage make(BIFile file, FilePath path, BDaemonFileSpace space) throws IOException {
        FileTransferMessage result = new FileTransferMessage(space);
        result.addFile(file, path);
        return result;
    }

    public static FileTransferMessage makeDelete(FilePath path, BDaemonFileSpace space) {
        FileTransferMessage result = new FileTransferMessage(space);
        result.addElement(new DeleteFileTransferMessageElement(path, space));
        return result;
    }

    public static FileTransferMessage makeMkDir(FilePath path, BDaemonFileSpace space) {
        FileTransferMessage result = new FileTransferMessage(space);
        result.addElement(new MkDirFileTransferMessageElement(path, space));
        return result;
    }

    public static FileTransferMessage makeRename(FilePath currentPath, String newName, BDaemonFileSpace space) {
        FileTransferMessage result = new FileTransferMessage(space);
        result.addElement(new RenameFileTransferMessageElement(currentPath, newName, space));
        return result;
    }

    public FileTransferMessage(StoreCache cache, BDaemonFileSpace space) {
        this(false, cache, space);
    }

    public FileTransferMessage(BDaemonFileSpace space) {
        this(false, space);
    }

    public StoreCache getCache() {
        return this.cache;
    }

    public FileTransferMessage(boolean pAutoCommit, BDaemonFileSpace space) {
        this(pAutoCommit, new StoreCache(), space);
    }

    public FileTransferMessage(boolean pAutoCommit, StoreCache pCache, BDaemonFileSpace pFileSpace) {
        this.autoCommit = pAutoCommit;
        this.deletesByFilePath = new TreeMap<FilePath, FileTransferMessageElement>();
        this.postsAndMkDirs = new ArrayList<FileTransferMessageElement>();
        this.cache = pCache;
        this.fileSpace = pFileSpace;
    }

    public void addElement(InputStream pStream, FilePath pPath, long pSize) {
        this.addElement(new FileTransferMessageElement(pPath, pStream, pSize, this.fileSpace));
    }

    public void addFile(BIFile pFile, FilePath pPath) throws IOException {
        this.addElement(new FileFileTransferElement(pPath, pFile, this.fileSpace));
    }

    public void addElement(FileTransferMessageElement elem) {
        if (elem.getRequestMethod().equals("DELETE")) {
            for (FilePath elemPath = elem.getFilePath(); elemPath != null; elemPath = elemPath.getParent()) {
                if (!this.deletesByFilePath.containsKey(elemPath)) continue;
                return;
            }
            ArrayList toRemove = new ArrayList();
            String elemPathString = elem.getFilePath().getBody() + '/';
            toRemove.addAll(this.deletesByFilePath.keySet().stream().filter(path -> path.getBody().startsWith(elemPathString)).collect(Collectors.toList()));
            toRemove.forEach(this.deletesByFilePath::remove);
            this.deletesByFilePath.put(elem.getFilePath(), elem);
        } else {
            this.postsAndMkDirs.add(elem);
        }
    }

    public void addDelete(FilePath path) {
        this.addElement(new DeleteFileTransferMessageElement(path, this.fileSpace));
    }

    public void addMkDir(FilePath path) {
        this.addElement(new MkDirFileTransferMessageElement(path, this.fileSpace));
    }

    public void addFile(BIFile pFile) throws IOException {
        this.addFile(pFile, pFile.getFilePath());
    }

    public String getCommitUri() {
        if (this.autoCommit || this.transactionId == null) {
            return null;
        }
        return "/niagara?transaction=commit&transactionId=" + this.transactionId;
    }

    public String getAbortUri() {
        if (this.autoCommit || this.transactionId == null) {
            return null;
        }
        return "/niagara?transaction=abort&transactionId=" + this.transactionId;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public BDaemonFileSpace getTargetFileSpace() {
        return this.fileSpace;
    }

    public List<FileTransferMessageElement> getElements(BDaemonSession session) throws ConnectException, AuthenticationException {
        try {
            ArrayList<FileTransferMessageElement> result = new ArrayList<FileTransferMessageElement>();
            result.addAll(this.deletesByFilePath.values());
            result.addAll(this.postsAndMkDirs);
            result.sort(new PathDepthComparator());
            for (FileTransferMessageElement element : result) {
                element.getExistingSize(session, this);
            }
            result.sort(new ElementComparator(session));
            return result;
        }
        catch (BajaRuntimeException e) {
            Throwable t = e.getCause();
            if (t instanceof ConnectException) {
                throw (ConnectException)t;
            }
            if (t instanceof AuthenticationException) {
                throw (AuthenticationException)t;
            }
            throw e;
        }
    }

    public void setTransactionId(String value) {
        this.transactionId = value;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setPBEEncodingInfo(PBEEncodingInfo value) {
        this.pbeEncodingInfo = value instanceof ISecretBytesSupplier ? (PBEEncodingInfo)((ISecretBytesSupplier)value).newCopy() : value;
    }

    public PBEEncodingInfo getPBEEncodingInfo() {
        return this.pbeEncodingInfo;
    }

    public void addPBEEncryptedElement(InputStream inputStream, FilePath path) throws IOException {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(path);
        if (this.pbeEncodingInfo == null || !(this.pbeEncodingInfo instanceof PBEEncodingKey)) {
            throw new IllegalStateException("Message has not been set up to use PBE encryption");
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        PBEEncryptingOutputStream out = new PBEEncryptingOutputStream((OutputStream)bytesOut, (PBEEncodingKey)this.pbeEncodingInfo);
        FileUtil.pipe((InputStream)inputStream, (OutputStream)out);
        out.flush();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytesOut.toByteArray());
        this.addElement(bytesIn, path, bytesOut.toByteArray().length);
    }

    public void close() {
        if (this.pbeEncodingInfo != null && this.pbeEncodingInfo instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.pbeEncodingInfo).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void initProgress() {
        this.transferTotal = 0L;
        this.transferComplete = 0L;
        for (FileTransferMessageElement elem : this.postsAndMkDirs) {
            this.transferTotal += elem.getSize();
            elem.initProgress();
        }
    }

    public void updateProgress(FileTransferMessageElement elem, int nWritten) {
        elem.updateProgress(nWritten);
        this.transferComplete += (long)nWritten;
    }

    public int getProgress() {
        return this.transferTotal == 0L ? 100 : (int)(100.0 * (double)this.transferComplete / (double)this.transferTotal);
    }

    public int getDeleteCount() {
        return this.deletesByFilePath.size();
    }

    public int getTransferCount() {
        return this.postsAndMkDirs.size();
    }

    public boolean isNiagara4Space() {
        return !BDaemonFileSpace.isAxDaemonFileSpace((BIFileSpace)this.fileSpace);
    }

    static {
        ORDINAL_OF_METHOD.put("DELETE", 0);
        ORDINAL_OF_METHOD.put("GET", 1);
        ORDINAL_OF_METHOD.put("POST", 2);
    }

    private class ElementComparator
    implements Comparator<FileTransferMessageElement> {
        private final BDaemonSession session;

        public ElementComparator(BDaemonSession pSession) {
            this.session = pSession;
        }

        @Override
        public int compare(FileTransferMessageElement e1, FileTransferMessageElement e2) {
            try {
                if (e1.getRequestMethod().equals(e2.getRequestMethod())) {
                    long delta2;
                    if (e1.getUri().equals(e2.getUri())) {
                        return 0;
                    }
                    long delta1 = e1.getSizeDelta(this.session, FileTransferMessage.this);
                    if (delta1 == (delta2 = e2.getSizeDelta(this.session, FileTransferMessage.this))) {
                        return e1.getUri().compareTo(e2.getUri());
                    }
                    if (delta1 < delta2) {
                        return -1;
                    }
                    return 1;
                }
                return ((Integer)ORDINAL_OF_METHOD.get(e1.getRequestMethod())).compareTo((Integer)ORDINAL_OF_METHOD.get(e2.getRequestMethod()));
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }

    private class PathDepthComparator
    implements Comparator<FileTransferMessageElement> {
        private PathDepthComparator() {
        }

        @Override
        public int compare(FileTransferMessageElement e1, FileTransferMessageElement e2) {
            try {
                if (e1.getFilePath().equals((Object)e2.getFilePath())) {
                    return ((Integer)ORDINAL_OF_METHOD.get(e1.getRequestMethod())).compareTo((Integer)ORDINAL_OF_METHOD.get(e2.getRequestMethod()));
                }
                FilePath uriPath1 = FileTransferMessage.this.getTargetFileSpace().toDaemonUriPath(e1.getFilePath());
                FilePath uriPath2 = FileTransferMessage.this.getTargetFileSpace().toDaemonUriPath(e2.getFilePath());
                if (uriPath1.depth() == uriPath2.depth()) {
                    return uriPath1.getBody().compareTo(uriPath2.getBody());
                }
                if (uriPath1.depth() < uriPath2.depth()) {
                    return -1;
                }
                return 1;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException((Throwable)e);
            }
        }
    }
}

