/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.message;

import com.tridium.nre.auth.UserAccount;
import com.tridium.platform.daemon.message.EncryptableXmlResponseMessage;
import com.tridium.platform.daemon.message.IUserUpdate;

public class ChangePasswordMessage
extends EncryptableXmlResponseMessage
implements IUserUpdate {
    private UserAccount account;
    private String oldPassword;
    private String newPassword;
    private boolean currentUser;

    public ChangePasswordMessage(UserAccount account, String oldPassword, String newPassword, boolean currentUser) {
        this.account = account;
        this.oldPassword = oldPassword;
        this.newPassword = newPassword;
        this.currentUser = currentUser;
    }

    @Override
    public String getMessageString() {
        if (this.sharedSecretKey == null) {
            throw new IllegalStateException("Attempting to generate message string without a shared key for encryption");
        }
        StringBuilder messageBuffer = new StringBuilder("acctmgt?update=changepassword&");
        messageBuffer.append("sharedKeyName").append("=").append(this.sharedSecretKey.getName());
        if (this.account.getPlatformIdentifier() == null) {
            messageBuffer.append("&user=");
            messageBuffer.append(this.prepareMessage(this.account.getFullyQualifiedName()));
        } else {
            messageBuffer.append("&userid=");
            messageBuffer.append(this.prepareMessage(this.account.getPlatformIdentifier()));
        }
        messageBuffer.append("&oldpassword=");
        messageBuffer.append(this.prepareMessage(this.oldPassword));
        messageBuffer.append("&newpassword=");
        messageBuffer.append(this.prepareMessage(this.newPassword));
        return messageBuffer.toString();
    }

    @Override
    public int getConnectionFlags() {
        return this.currentUser ? 16 : 0;
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }

    public UserAccount getAccount() {
        return this.account;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public String getOldPassword() {
        return this.oldPassword;
    }

    @Override
    public String getUsername() {
        return this.account.getAccountName();
    }
}

