/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon.file;

import java.io.IOException;
import java.util.Comparator;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.CursorException;
import javax.baja.sys.IterableCursor;

public class DirectoryCursor
implements IterableCursor<BObject> {
    private Array<BIFile> dirContents;
    private int carat = -1;
    private Object current = null;
    private volatile boolean closed;

    public DirectoryCursor(BIDirectory dir) {
        this.dirContents = new Array((Object[])dir.listFiles()).sort(Comparator.comparing(BIFile::getFilePath));
    }

    public Context getContext() {
        return null;
    }

    public boolean next() {
        if (this.closed) {
            throw new CursorException("closed");
        }
        if (this.carat < 0) {
            this.carat = 0;
        } else if (this.current != null && this.current instanceof DirectoryCursor) {
            DirectoryCursor currentCursor = (DirectoryCursor)this.current;
            if (!currentCursor.next()) {
                this.current = this.dirContents.get(this.carat);
                ++this.carat;
            }
            return true;
        }
        if (this.carat < this.dirContents.size()) {
            if (this.dirContents.get(this.carat) instanceof BDirectory) {
                DirectoryCursor currentCursor = new DirectoryCursor((BIDirectory)((BDirectory)this.dirContents.get(this.carat)));
                if (currentCursor.next()) {
                    this.current = currentCursor;
                } else {
                    this.current = this.dirContents.get(this.carat);
                    ++this.carat;
                }
                return true;
            }
            this.current = this.dirContents.get(this.carat);
            ++this.carat;
            return true;
        }
        this.current = null;
        return false;
    }

    public boolean nextComponent() {
        return this.next(BComponent.class);
    }

    public boolean next(Class<?> cls) {
        boolean result = this.next();
        while (result && !cls.isAssignableFrom(this.get().getClass())) {
            result = this.next();
        }
        return result;
    }

    public boolean nextNonDirectory() {
        boolean result = this.next();
        while (result && this.getFile() instanceof BDirectory) {
            result = this.next();
        }
        return result;
    }

    public BObject get() {
        if (this.closed) {
            throw new CursorException("closed");
        }
        if (this.current != null && this.current instanceof DirectoryCursor) {
            return ((DirectoryCursor)this.current).get();
        }
        return (BObject)this.current;
    }

    public void close() {
        this.closed = true;
    }

    public BIFile getFile() {
        return (BIFile)this.get();
    }

    public static void main(String[] args) {
        try {
            BIFile file;
            BFileSystem.INSTANCE.makeDir(new FilePath("^testCursor"));
            BFileSystem.INSTANCE.makeDir(new FilePath("^testCursor/0"));
            BFileSystem.INSTANCE.makeDir(new FilePath("^testCursor/0/0.0"));
            BFileSystem.INSTANCE.makeDir(new FilePath("^testCursor/1"));
            BFileSystem.INSTANCE.makeFile(new FilePath("^testCursor/a.txt"));
            BFileSystem.INSTANCE.makeFile(new FilePath("^testCursor/0/0a.txt"));
            BFileSystem.INSTANCE.makeFile(new FilePath("^testCursor/0/0b.txt"));
            BFileSystem.INSTANCE.makeFile(new FilePath("^testCursor/0/0.0/0.0a.txt"));
            BFileSystem.INSTANCE.makeFile(new FilePath("^testCursor/0/0.0/0.0b.txt"));
            BIDirectory dir = (BIDirectory)BFileSystem.INSTANCE.findFile(new FilePath("^testcursor"));
            System.out.println("full iteration");
            DirectoryCursor c = new DirectoryCursor(dir);
            while (c.next()) {
                file = (BIFile)c.get();
                System.out.println(" " + file.getFilePath().getBody());
            }
            System.out.println("directories only");
            c = new DirectoryCursor(dir);
            while (c.next(BIDirectory.class)) {
                file = (BIFile)c.get();
                System.out.println(" " + file.getFilePath().getBody());
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        System.exit(0);
    }
}

