/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.InstallScenario;
import com.tridium.install.UnmeetableDependency;
import com.tridium.install.installable.BDistribution;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.install.part.BModulePart;
import com.tridium.install.part.BPart;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEValidator;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.util.SupportLevel;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.PlatformInstallOperation;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.CheckAuthenticationReadonlyMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.message.RefreshDaemonBinariesMessage;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.baja.file.BIFile;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.platform.BStationStatus;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.platform.InstallManager;
import javax.baja.platform.InstallOperation;
import javax.baja.platform.install.InstallationSummary;
import javax.baja.platform.install.PlatformDependency;
import javax.baja.platform.install.PlatformPart;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.SlotCursor;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class PlatformInstallManager
implements InstallManager {
    private BDaemonSession daemonSession;

    private PlatformInstallManager(BDaemonSession daemonSession) {
        this.daemonSession = daemonSession;
    }

    public static PlatformInstallManager make(BDaemonSession daemonSession) {
        return new PlatformInstallManager(daemonSession);
    }

    @Override
    public PlatformPart[] getPlatformParts(IPlatformOperationListener iListener) throws Exception {
        PlatformOperationListener listener = new PlatformOperationListener(iListener);
        ArrayList<PlatformPart> result = new ArrayList<PlatformPart>();
        BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make(this.daemonSession, listener);
        platform.checkSession(listener);
        if (!platform.getArchPart().isNull()) {
            result.add(platform.getArchPart().asPlatformPart());
        }
        if (!platform.getOsPart().isNull()) {
            result.add(platform.getOsPart().asPlatformPart());
        }
        if (!platform.getNrePart().isNull()) {
            result.add(platform.getNrePart().asPlatformPart());
        }
        if (!platform.getBrandPart().isNull()) {
            result.add(platform.getBrandPart().asPlatformPart());
        }
        if (!platform.getVmPart().isNull()) {
            result.add(platform.getVmPart().asPlatformPart());
        }
        if (!platform.getModelPart().isNull()) {
            result.add(platform.getModelPart().asPlatformPart());
        }
        SlotCursor c = platform.getOtherParts().getProperties();
        while (c.next()) {
            result.add(((BPart)c.get()).asPlatformPart());
        }
        platform.getModuleList().init(listener);
        c = platform.getModuleList().getModules().getProperties();
        while (c.next()) {
            result.add(((BModuleInstallable)c.get()).getModulePart().asPlatformPart());
        }
        return result.toArray(new PlatformPart[0]);
    }

    @Override
    public InstallationSummary checkInstall(InstallOperation pOperation, IPlatformOperationListener iListener) throws Exception {
        HashSet<RuntimeProfile> newEnabledRuntimeProfiles;
        PlatformInstallOperation operation = (PlatformInstallOperation)pOperation;
        PlatformOperationListener listener = new PlatformOperationListener(iListener);
        this.checkCanceled(listener);
        BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make(this.daemonSession, listener);
        platform.loadPreferredVerificationMode();
        BDependency[] depends = new BDependency[operation.installModuleVersions.size()];
        int ixDepend = 0;
        for (String moduleName : operation.installModuleVersions.keySet()) {
            Version moduleVersion = operation.installModuleVersions.get(moduleName);
            if (moduleVersion.equals((Object)Version.NULL)) {
                depends[ixDepend] = BDependency.forModule(moduleName);
                BInstallable moduleInst = LocalInstallableRegistry.getInstance().findInstallable(depends[ixDepend], listener);
                if (moduleInst != null) {
                    depends[ixDepend] = BDependency.forPart(moduleInst.getPart());
                }
            } else {
                depends[ixDepend] = new BDependency(moduleName, new BVersion(moduleVersion.toString()), BModulePart.TYPE.getTypeSpec());
            }
            ++ixDepend;
        }
        if (operation.enabledRuntimeProfiles == null) {
            newEnabledRuntimeProfiles = null;
        } else {
            if (!this.daemonSession.getHostProperties().isNiagara4()) {
                throw new UnsupportedOperationException("Runtime profiles not supported for Niagara AX Hosts");
            }
            newEnabledRuntimeProfiles = new HashSet<RuntimeProfile>(operation.enabledRuntimeProfiles);
            for (RuntimeProfile profile : RuntimeProfile.values()) {
                SupportLevel level = this.daemonSession.getHostProperties().getSupportForRuntimeProfile(profile);
                if (level.equals((Object)SupportLevel.required)) {
                    newEnabledRuntimeProfiles.add(profile);
                }
                if (!level.equals((Object)SupportLevel.unsupported) || !newEnabledRuntimeProfiles.contains(profile)) continue;
                throw new IllegalArgumentException(String.format("Runtime profile \"%s\" is unsupported on the remote host", profile));
            }
        }
        this.checkCanceled(listener);
        iListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.checkingDependencies"));
        return new InstallSummaryImpl(InstallScenario.solve((BDaemonPlatform)platform, listener, operation.uninstallModuleNames.toArray(new String[0]), depends, operation.installDists.toArray(new BInstallable[0]), newEnabledRuntimeProfiles, (InstallableRegistry)LocalInstallableRegistry.getInstance(), null));
    }

    @Override
    public boolean checkDistPasswordRequired(InstallOperation operation) throws IOException {
        BInstallable[] dists;
        PlatformInstallOperation platOperations = (PlatformInstallOperation)operation;
        for (BInstallable installable : dists = platOperations.installDists.toArray(new BInstallable[0])) {
            if (!(installable instanceof BDistribution)) continue;
            BDistribution distFile = (BDistribution)installable;
            return distFile.getManifest().getPBEEncodingInfo() != null && !this.daemonSession.validateSystemPassPhrase((PBEValidator)distFile.getManifest().getPBEEncodingInfo());
        }
        return false;
    }

    private Consumer<FileTransferMessage> makeMessageInitializer(BInstallable[] installables, SecretChars password) throws Exception {
        PBEEncodingInfo info = null;
        for (BInstallable installable : installables) {
            BDistribution distribution;
            PBEEncodingInfo tempInfo;
            if (!(installable instanceof BDistribution) || (tempInfo = (distribution = (BDistribution)installable).getManifest().getPBEEncodingInfo()) == null) continue;
            if (info != null) {
                throw new Exception("Multiple Encoded Dists");
            }
            info = tempInfo;
        }
        return DaemonClientEncodingInfo.makeMessageInitializer(this.daemonSession, Optional.ofNullable(info), Optional.ofNullable(password));
    }

    @Override
    public void registerInstallableFile(BIFile file, IPlatformOperationListener iListener) throws Exception {
        BInstallable inst = BInstallable.make(file);
        if (inst == null) {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.fileNotInstallable", new Object[]{file.getFilePath().getBody()});
        }
        LocalInstallableRegistry.getInstance().register(inst, new PlatformOperationListener(iListener));
    }

    @Override
    public Set<RuntimeProfile> getEnabledRuntimeProfiles() {
        if (!this.daemonSession.getHostProperties().isNiagara4()) {
            throw new UnsupportedOperationException("updateEnabledRuntimeProfiles is not supported for Niagara AX Hosts");
        }
        return Collections.unmodifiableSet(this.daemonSession.getHostProperties().getEnabledRuntimeProfiles());
    }

    @Override
    public Set<RuntimeProfile> getUnsupportedRuntimeProfiles() {
        if (!this.daemonSession.getHostProperties().isNiagara4()) {
            throw new UnsupportedOperationException("Runtime profiles not supported for Niagara AX Hosts");
        }
        HashSet<RuntimeProfile> result = new HashSet<RuntimeProfile>();
        for (RuntimeProfile profile : RuntimeProfile.values()) {
            if (!this.daemonSession.getHostProperties().getSupportForRuntimeProfile(profile).equals((Object)SupportLevel.unsupported)) continue;
            result.add(profile);
        }
        return result;
    }

    @Override
    public void install(InstallOperation pOperation, IPlatformOperationListener iListener) throws Exception {
        this.install(pOperation, iListener, null);
    }

    @Override
    public void install(InstallOperation pOperation, IPlatformOperationListener iListener, char[] password) throws Exception {
        BStationStatus status;
        boolean updateTcpIp;
        HashSet<RuntimeProfile> newEnabledRuntimeProfiles;
        PlatformInstallOperation operation = (PlatformInstallOperation)pOperation;
        PlatformOperationListener listener = new PlatformOperationListener(iListener);
        this.checkCanceled(listener);
        BRemoteDaemonPlatform platform = BRemoteDaemonPlatform.make(this.daemonSession, listener);
        platform.loadPreferredVerificationMode();
        if (platform.getIsSoftwareReadonly() && (operation.installModuleVersions.size() != 0 || operation.uninstallModuleNames.size() != 0 || operation.installDists.size() != 0)) {
            throw new UnsupportedOperationException("Software modification not supported for readonly host");
        }
        BDependency[] depends = new BDependency[operation.installModuleVersions.size()];
        int ixDepend = 0;
        for (String string : operation.installModuleVersions.keySet()) {
            Version moduleVersion = operation.installModuleVersions.get(string);
            if (moduleVersion.equals((Object)Version.NULL)) {
                depends[ixDepend] = BDependency.forModule(string);
                BInstallable moduleInst = LocalInstallableRegistry.getInstance().findInstallable(depends[ixDepend], listener);
                if (moduleInst != null) {
                    depends[ixDepend] = BDependency.forPart(moduleInst.getPart());
                }
            } else {
                depends[ixDepend] = new BDependency(string, new BVersion(moduleVersion.toString()), BModulePart.TYPE.getTypeSpec());
            }
            ++ixDepend;
        }
        if (operation.enabledRuntimeProfiles == null) {
            newEnabledRuntimeProfiles = null;
        } else {
            if (!this.daemonSession.getHostProperties().isNiagara4()) {
                throw new UnsupportedOperationException("Runtime profiles not supported for Niagara AX Hosts");
            }
            newEnabledRuntimeProfiles = new HashSet<RuntimeProfile>(operation.enabledRuntimeProfiles);
            for (RuntimeProfile profile : RuntimeProfile.values()) {
                SupportLevel level = this.daemonSession.getHostProperties().getSupportForRuntimeProfile(profile);
                if (level.equals((Object)SupportLevel.required)) {
                    newEnabledRuntimeProfiles.add(profile);
                }
                if (!level.equals((Object)SupportLevel.unsupported) || !newEnabledRuntimeProfiles.contains(profile)) continue;
                throw new IllegalArgumentException(String.format("Runtime profile \"%s\" is unsupported on the remote host", profile));
            }
        }
        this.checkCanceled(listener);
        iListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.checkingDependencies"));
        InstallScenario installScenario = InstallScenario.solve((BDaemonPlatform)platform, listener, operation.uninstallModuleNames.toArray(new String[0]), depends, operation.installDists.toArray(new BInstallable[0]), newEnabledRuntimeProfiles, (InstallableRegistry)LocalInstallableRegistry.getInstance(), null);
        UnmeetableDependency[] unmet = installScenario.getUnmeetableDependencies();
        if (unmet.length > 0) {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.unmetDependencies", new Object[]{unmet[0]});
        }
        BInstallable[] excludedInstallables = installScenario.getExcludedInstallables();
        if (excludedInstallables.length > 0) {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.excludedInstallables", new Object[]{excludedInstallables[0].getInstallableFileName()});
        }
        this.checkCanceled(listener);
        long flags = installScenario.getProcessingFlags();
        boolean bl = updateTcpIp = !operation.ignoreTcpIpChanges && (flags & 0x80000L) > 0L;
        if (updateTcpIp) {
            BTcpIpHostSettings currentHostSettings = new BTcpIpHostSettings();
            TcpUtil.loadFromSession(currentHostSettings, this.daemonSession);
            if (currentHostSettings.getIsReadonly() || installScenario.getTcpIpChanges() != null && installScenario.getTcpIpChanges().getIsReadonly()) {
                updateTcpIp = false;
            }
        }
        if (!this.daemonSession.getHostProperties().hasFullAccess() && (updateTcpIp || (flags & 0x30000L) > 0L)) {
            throw new LocalizableRuntimeException("platform", "PlatformInstallManager.insufficientAccess");
        }
        List<Object> runningApps = new ArrayList<BAppSurrogate>();
        if ((flags & 4L) > 0L && (flags & 1L) == 0L && (flags & 2L) == 0L) {
            for (BAppSurrogate app : BAppSurrogate.makeAll(null, this.daemonSession)) {
                status = app.getAppStatus();
                if (!(app instanceof BStationSurrogate) || status != BStationStatus.starting && status != BStationStatus.stopping) continue;
                flags |= 2L;
                break;
            }
        }
        if ((flags & 1L) > 0L || (flags & 2L) > 0L || (flags & 4L) > 0L) {
            for (BAppSurrogate app : BAppSurrogate.makeAll(null, this.daemonSession)) {
                status = app.getAppStatus();
                if (status != BStationStatus.starting && status != BStationStatus.running && status != BStationStatus.stopping || (flags & 1L) <= 0L && !(app instanceof BStationSurrogate)) continue;
                runningApps.add((Object)app);
            }
        }
        if ((flags & 1L) > 0L || (flags & 2L) > 0L) {
            BAppSurrogate[] runningAppsArray = BAppSurrogate.stopAllApps(this.daemonSession, (flags & 1L) > 0L ? null : BStationSurrogate.TYPE, listener, listener);
            if (runningAppsArray.length > 0) {
                for (BAppSurrogate runningApp : runningAppsArray) {
                    listener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.stoppedApp", new Object[]{runningApp.getAppName()}));
                }
            }
            runningApps = Arrays.asList(runningAppsArray);
        }
        this.checkCanceled(listener);
        iListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.committing"));
        BInstallable[] installables = operation.installDists.toArray(new BInstallable[0]);
        installScenario.setIgnoreDhcpdTransfer(!updateTcpIp);
        installScenario.setIgnoreLinkTransfer(!updateTcpIp);
        boolean authReadonly = false;
        try {
            XElem authInfo = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new CheckAuthenticationReadonlyMessage(), "text/xml")).parse();
            XElem authElem = authInfo.elem("auth");
            if (authElem != null) {
                authReadonly = authElem.getb("readonly", false);
            }
        }
        catch (Exception authInfo) {
            // empty catch block
        }
        installScenario.commit(listener, new StoreCache(), listener, operation.ignoreAuthChanges || authReadonly, Optional.ofNullable(this.makeMessageInitializer(installables, password == null ? null : new SecretChars(password, false))));
        long flags1 = installScenario.getProcessingFlags();
        if (updateTcpIp) {
            listener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.tcpInstall"));
            TcpUtil.saveToSession(installScenario.getTcpIpChanges(), this.daemonSession, false);
        }
        if ((flags1 & 0x20000L) > 0L) {
            listener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.osInstall"));
            if (this.daemonSession.getHostProperties().supportsServlet("osupdate")) {
                this.daemonSession.sendMessage(OSUpdateMessage.getInstance(), 90000);
            }
        }
        if ((flags1 & 0x10000L) > 0L) {
            listener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.reboot"));
            this.daemonSession.sendRebootRequest();
        } else if ((flags1 & 0x40000L) > 0L) {
            listener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.updateDaemon"));
            this.daemonSession.sendMessage(RefreshDaemonBinariesMessage.getInstance());
        } else if ((flags1 & 4L) > 0L && (flags1 & 2L) == 0L && (flags1 & 1L) == 0L) {
            for (BAppSurrogate bAppSurrogate : runningApps) {
                if (!(bAppSurrogate instanceof BStationSurrogate)) continue;
                ((BStationSurrogate)bAppSurrogate).syncStationModulesAsync();
            }
        }
        iListener.notifyStatus(Lexicon.make((String)"platform").getText("PlatformInstallManager.success"));
    }

    private void checkCanceled(PlatformOperationListener listener) {
        if (listener.isCanceled()) {
            throw new ICancelHint.CanceledException();
        }
    }

    private static class InstallSummaryImpl
    implements InstallationSummary {
        private InstallScenario scenario;

        public InstallSummaryImpl(InstallScenario scenario) {
            this.scenario = scenario;
        }

        @Override
        public BIFile[] getFilesToInstall() {
            ArrayList<BIFile> result = new ArrayList<BIFile>();
            for (int i = 0; i < this.scenario.getToInstall().length; ++i) {
                result.add((BIFile)this.scenario.getToInstall()[i].getInstallableFileOrd().get());
            }
            return result.toArray(new BIFile[0]);
        }

        @Override
        public String[] getModulesToUninstall() {
            return this.scenario.getModulesToUninstall();
        }

        @Override
        public PlatformDependency[] getUnmetDependencies() {
            UnmeetableDependency[] ud = this.scenario.getUnmeetableDependencies();
            PlatformDependency[] result = new PlatformDependency[ud.length];
            for (int i = 0; i < ud.length; ++i) {
                result[i] = ud[i].dependency.asPlatformDependency();
            }
            return result;
        }

        @Override
        public BIFile[] getExcludedFiles() {
            BInstallable[] excl = this.scenario.getExcludedInstallables();
            BIFile[] result = new BIFile[excl.length];
            for (int i = 0; i < excl.length; ++i) {
                result[i] = (BIFile)excl[i].getInstallableFileOrd().get();
            }
            return result;
        }

        @Override
        public boolean canInstall() {
            return this.scenario.canCommit();
        }

        @Override
        public Set<RuntimeProfile> getUpdatedEnabledRuntimeProfiles() {
            return this.scenario.getNewEnabledRuntimeProfiles();
        }
    }
}

