/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.daemon;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.PlatformOperationListener;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileStore;
import com.tridium.platform.daemon.file.StoreCache;
import com.tridium.platform.daemon.message.DeleteFileTransferMessageElement;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Objects;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocEncoder;
import javax.baja.platform.BOverwritePolicy;
import javax.baja.platform.FileManager;
import javax.baja.platform.FileTransferOperation;
import javax.baja.platform.ICancelHint;
import javax.baja.platform.IPlatformOperationListener;
import javax.baja.security.AuthenticationException;
import javax.baja.util.Lexicon;

public class PlatformFileManager
implements FileManager {
    private BDaemonSession daemonSession;
    private static Lexicon lex = Lexicon.make((String)"platform");

    private PlatformFileManager(BDaemonSession daemonSession) {
        this.daemonSession = daemonSession;
    }

    public static PlatformFileManager make(BDaemonSession daemonSession) {
        return new PlatformFileManager(daemonSession);
    }

    @Override
    public BFileSpace getFileSpace() throws ConnectException, AuthenticationException {
        return this.daemonSession.getFileSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void transfer(FileTransferOperation transferOperation, IPlatformOperationListener listener) throws AuthenticationException, IOException {
        Objects.requireNonNull(transferOperation);
        try {
            StoreCache cache = new StoreCache();
            switch (transferOperation.operation) {
                case 0: {
                    this.get(transferOperation.source, transferOperation.destinationDir, transferOperation.recurseDirs, transferOperation.overwritePolicy, new PlatformOperationListener(listener), cache);
                    return;
                }
                case 1: {
                    this.put(transferOperation, transferOperation.source, transferOperation.destinationDir, transferOperation.recurseDirs, transferOperation.overwritePolicy, new PlatformOperationListener(listener), cache);
                    return;
                }
                case 2: {
                    this.delete(transferOperation.source, new PlatformOperationListener(listener));
                    return;
                }
                case 3: {
                    this.rename(transferOperation.source[0], transferOperation.destinationDir.getName(), new PlatformOperationListener(listener));
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Invalid transfer operation");
                }
            }
        }
        finally {
            transferOperation.close();
        }
    }

    private void checkCanceled(ICancelHint cancelHint) {
        if (cancelHint != null && cancelHint.isCanceled()) {
            throw new ICancelHint.CanceledException();
        }
    }

    private void rename(FilePath source, String newName, PlatformOperationListener listener) throws ConnectException, AuthenticationException {
        DaemonFileUtil.transfer(this.daemonSession, FileTransferMessage.makeRename(source, newName, this.daemonSession.getFileSpace()), null, listener);
    }

    private void get(FilePath[] sourceFilePaths, FilePath destinationDir, boolean recurseDirs, BOverwritePolicy overwritePolicy, PlatformOperationListener listener, StoreCache cache) throws AuthenticationException, IOException {
        ArrayList<BIFileStore> sources = new ArrayList<BIFileStore>();
        for (FilePath sourceFilePath : sourceFilePaths) {
            BIFileStore store = this.daemonSession.getFileSpace().findStore(cache, sourceFilePath, recurseDirs, overwritePolicy == BOverwritePolicy.different, BCacheAccessPolicy.lazyFetch);
            if (store == null) {
                throw new FileNotFoundException(sourceFilePath.getBody() + " not found");
            }
            sources.add(store);
        }
        for (BIFileStore store : sources) {
            if (store instanceof BDaemonDirectoryStore) {
                this.getDir((BDaemonDirectoryStore)store, destinationDir.merge(store.getFileName()), recurseDirs, overwritePolicy, listener);
                continue;
            }
            if (!(store instanceof BDaemonFileStore)) continue;
            this.getFile((BDaemonFileStore)store, destinationDir.merge(store.getFileName()), overwritePolicy, listener);
        }
    }

    private void getDir(BDaemonDirectoryStore store, FilePath localDest, boolean recurseDirs, BOverwritePolicy overwritePolicy, PlatformOperationListener listener) throws AuthenticationException, IOException {
        for (BIFileStore kid : store.listChildren()) {
            if (kid instanceof BDaemonFileStore) {
                this.getFile((BDaemonFileStore)kid, localDest.merge(kid.getFileName()), overwritePolicy, listener);
                continue;
            }
            if (!(kid instanceof BDaemonDirectoryStore) || !recurseDirs) continue;
            this.getDir((BDaemonDirectoryStore)kid, localDest.merge(kid.getFileName()), true, overwritePolicy, listener);
        }
    }

    private void getFile(BDaemonFileStore store, FilePath localDest, BOverwritePolicy overwritePolicy, PlatformOperationListener listener) throws AuthenticationException, IOException {
        BIFile target = BFileSystem.INSTANCE.findFile(localDest);
        if (target != null && (overwritePolicy == BOverwritePolicy.none || overwritePolicy == BOverwritePolicy.different && store.getCrc() == DaemonFileUtil.getCrc(target))) {
            if (listener != null) {
                DaemonSessionTask task = new DaemonSessionTask(lex, "DaemonFileStore.copyToLocalHost.title", "DaemonFileStore.copyToLocalHost.notOverwritten", new Object[]{localDest.getBody()});
                listener.taskStarted(task);
                listener.taskFinished(task);
            }
            return;
        }
        store.copyToLocalHost(localDest, listener);
    }

    private void put(FileTransferOperation operation, FilePath[] sourceFilePaths, FilePath destinationDir, boolean recurseDirs, BOverwritePolicy overwritePolicy, PlatformOperationListener listener, StoreCache cache) throws AuthenticationException, IOException {
        this.checkCanceled(listener);
        ArrayList<BIFile> sources = new ArrayList<BIFile>();
        for (FilePath sourceFilePath : sourceFilePaths) {
            this.checkCanceled(listener);
            BIFile file = BFileSystem.INSTANCE.findFile(sourceFilePath);
            if (file == null) {
                throw new FileNotFoundException(sourceFilePath.getBody() + " not found");
            }
            sources.add(file);
        }
        FileTransferMessage message = new FileTransferMessage(this.daemonSession.getFileSpace());
        for (BIFile sourceFile : sources) {
            this.checkCanceled(listener);
            if (sourceFile instanceof BDirectory) {
                this.putDir(operation, (BDirectory)sourceFile, destinationDir.merge(sourceFile.getFileName()), recurseDirs, overwritePolicy, cache, message, listener);
                continue;
            }
            this.putFile(operation, sourceFile, destinationDir.merge(sourceFile.getFileName()), recurseDirs, overwritePolicy, cache, message, listener);
        }
        operation.initializeFileTransferMessage(this.daemonSession, message);
        DaemonFileUtil.transfer(this.daemonSession, message, listener, listener);
    }

    private void putDir(FileTransferOperation operation, BDirectory localSource, FilePath remoteDest, boolean recurseDirs, BOverwritePolicy overwritePolicy, StoreCache cache, FileTransferMessage message, PlatformOperationListener listener) throws AuthenticationException, IOException {
        this.checkCanceled(listener);
        for (BIFile kid : localSource.listFiles()) {
            this.checkCanceled(listener);
            if (kid instanceof BDirectory) {
                if (!recurseDirs) continue;
                this.putDir(operation, (BDirectory)kid, remoteDest.merge(kid.getFileName()), true, overwritePolicy, cache, message, listener);
                continue;
            }
            this.putFile(operation, kid, remoteDest.merge(kid.getFileName()), recurseDirs, overwritePolicy, cache, message, listener);
        }
    }

    private void putFile(FileTransferOperation operation, BIFile localSource, FilePath remoteDest, boolean recurseDirs, BOverwritePolicy overwritePolicy, StoreCache cache, FileTransferMessage message, PlatformOperationListener listener) throws AuthenticationException, IOException {
        this.checkCanceled(listener);
        BDaemonFileStore store = (BDaemonFileStore)this.daemonSession.getFileSpace().findStore(cache, remoteDest, recurseDirs, overwritePolicy == BOverwritePolicy.different, BCacheAccessPolicy.lazyFetch);
        if (store == null || overwritePolicy == BOverwritePolicy.different && store.getCrc() != DaemonFileUtil.getCrc(localSource) || overwritePolicy == BOverwritePolicy.all) {
            if (localSource instanceof BBogFile) {
                BBogFile localBog = (BBogFile)localSource;
                try {
                    if (localBog.getBogVersion().compareTo(ValueDocEncoder.BOG_VERSION_4) >= 0 && !this.daemonSession.getHostProperties().isNiagara4()) {
                        throw new IOException("Cannot transfer Niagara 4 BOG file to AX host");
                    }
                    operation.setPBEEncodingInfo(localBog.getPBEEncodingInfo());
                }
                catch (IOException | AuthenticationException rethrow) {
                    throw rethrow;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            message.addFile(localSource, remoteDest);
        }
    }

    private void delete(FilePath[] pathsToDelete, PlatformOperationListener listener) throws AuthenticationException, IOException {
        FileTransferMessage message = new FileTransferMessage(this.daemonSession.getFileSpace());
        for (FilePath pathToDelete : pathsToDelete) {
            message.addElement(new DeleteFileTransferMessageElement(pathToDelete, this.daemonSession.getFileSpace()));
        }
        DaemonFileUtil.transfer(this.daemonSession, message, listener, listener);
    }
}

