/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform.alarm;

import com.tridium.platform.alarm.BPlatformServiceAlarmRecord;
import com.tridium.platform.alarm.BPlatformServiceSourceState;
import java.util.HashMap;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alarmClass", type="String", defaultValue="defaultAlarmClass", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"alarm:AlarmClassFE\"), BFacets.UX_FIELD_EDITOR, BString.make(\"alarm:AlarmClassEditor\"))")}), @NiagaraProperty(name="sourceName", type="BFormat", defaultValue="BFormat.make(\"%parent.displayName%\")"), @NiagaraProperty(name="alertText", type="BFormat", defaultValue="BFormat.make(\"\")"), @NiagaraProperty(name="toFaultText", type="BFormat", defaultValue="BFormat.make(\"\")"), @NiagaraProperty(name="toOffnormalText", type="BFormat", defaultValue="BFormat.make(\"\")"), @NiagaraProperty(name="toNormalText", type="BFormat", defaultValue="BFormat.make(\"\")"), @NiagaraProperty(name="hyperlinkOrd", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(BFacets.ORD_RELATIVIZE, false)")}), @NiagaraProperty(name="soundFile", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(BFacets.TARGET_TYPE, BString.make(\"file:AudioFile\"))")}), @NiagaraProperty(name="alarmIcon", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(BFacets.TARGET_TYPE, BString.make(\"file:ImageFile\"))")}), @NiagaraProperty(name="metaData", type="BFacets", defaultValue="BFacets.DEFAULT")})
public class BPlatformAlarmSupport
extends BComponent {
    @Generated
    public static final Property alarmClass = BPlatformAlarmSupport.newProperty((int)0, (String)"defaultAlarmClass", (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassFE"), (String)"uxFieldEditor", (BIDataValue)BString.make((String)"alarm:AlarmClassEditor")));
    @Generated
    public static final Property sourceName = BPlatformAlarmSupport.newProperty((int)0, (BValue)BFormat.make((String)"%parent.displayName%"), null);
    @Generated
    public static final Property alertText = BPlatformAlarmSupport.newProperty((int)0, (BValue)BFormat.make((String)""), null);
    @Generated
    public static final Property toFaultText = BPlatformAlarmSupport.newProperty((int)0, (BValue)BFormat.make((String)""), null);
    @Generated
    public static final Property toOffnormalText = BPlatformAlarmSupport.newProperty((int)0, (BValue)BFormat.make((String)""), null);
    @Generated
    public static final Property toNormalText = BPlatformAlarmSupport.newProperty((int)0, (BValue)BFormat.make((String)""), null);
    @Generated
    public static final Property hyperlinkOrd = BPlatformAlarmSupport.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"ordRelativize", (boolean)false));
    @Generated
    public static final Property soundFile = BPlatformAlarmSupport.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:AudioFile")));
    @Generated
    public static final Property alarmIcon = BPlatformAlarmSupport.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"file:ImageFile")));
    @Generated
    public static final Property metaData = BPlatformAlarmSupport.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPlatformAlarmSupport.class);
    private static final BIcon icon = BIcon.std((String)"alarm.png");
    BComponent comp;
    BAbsTime lastAlertTime;
    BAbsTime lastOffnormalTime;
    BAbsTime lastFaultTime;

    @Generated
    public String getAlarmClass() {
        return this.getString(alarmClass);
    }

    @Generated
    public void setAlarmClass(String v) {
        this.setString(alarmClass, v, null);
    }

    @Generated
    public BFormat getSourceName() {
        return (BFormat)this.get(sourceName);
    }

    @Generated
    public void setSourceName(BFormat v) {
        this.set(sourceName, (BValue)v, null);
    }

    @Generated
    public BFormat getAlertText() {
        return (BFormat)this.get(alertText);
    }

    @Generated
    public void setAlertText(BFormat v) {
        this.set(alertText, (BValue)v, null);
    }

    @Generated
    public BFormat getToFaultText() {
        return (BFormat)this.get(toFaultText);
    }

    @Generated
    public void setToFaultText(BFormat v) {
        this.set(toFaultText, (BValue)v, null);
    }

    @Generated
    public BFormat getToOffnormalText() {
        return (BFormat)this.get(toOffnormalText);
    }

    @Generated
    public void setToOffnormalText(BFormat v) {
        this.set(toOffnormalText, (BValue)v, null);
    }

    @Generated
    public BFormat getToNormalText() {
        return (BFormat)this.get(toNormalText);
    }

    @Generated
    public void setToNormalText(BFormat v) {
        this.set(toNormalText, (BValue)v, null);
    }

    @Generated
    public BOrd getHyperlinkOrd() {
        return (BOrd)this.get(hyperlinkOrd);
    }

    @Generated
    public void setHyperlinkOrd(BOrd v) {
        this.set(hyperlinkOrd, (BValue)v, null);
    }

    @Generated
    public BOrd getSoundFile() {
        return (BOrd)this.get(soundFile);
    }

    @Generated
    public void setSoundFile(BOrd v) {
        this.set(soundFile, (BValue)v, null);
    }

    @Generated
    public BOrd getAlarmIcon() {
        return (BOrd)this.get(alarmIcon);
    }

    @Generated
    public void setAlarmIcon(BOrd v) {
        this.set(alarmIcon, (BValue)v, null);
    }

    @Generated
    public BFacets getMetaData() {
        return (BFacets)this.get(metaData);
    }

    @Generated
    public void setMetaData(BFacets v) {
        this.set(metaData, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPlatformAlarmSupport() {
    }

    public BPlatformAlarmSupport(BComponent sourceComp) {
        this.comp = sourceComp;
    }

    public void setSourceComponent(BComponent sourceComp) {
        this.comp = sourceComp;
    }

    public BPlatformServiceAlarmRecord makeNewAlert() {
        return this.makeNewAlert(BFacets.NULL);
    }

    public BPlatformServiceAlarmRecord makeNewAlert(BFacets data) {
        return this.makeNewAlarm(BPlatformServiceSourceState.alert, data);
    }

    public BPlatformServiceAlarmRecord makeNewOffnormalAlarm() {
        return this.makeNewOffnormalAlarm(BFacets.NULL);
    }

    public BPlatformServiceAlarmRecord makeNewOffnormalAlarm(BFacets data) {
        return this.makeNewAlarm(BPlatformServiceSourceState.offnormal, data);
    }

    public BPlatformServiceAlarmRecord makeNewFaultAlarm() {
        return this.makeNewFaultAlarm(BFacets.NULL);
    }

    public BPlatformServiceAlarmRecord makeNewFaultAlarm(BFacets data) {
        return this.makeNewAlarm(BPlatformServiceSourceState.fault, data);
    }

    private BPlatformServiceAlarmRecord makeNewAlarm(BPlatformServiceSourceState state, BFacets data) {
        BFacets alarmData = BFacets.make((BFacets)this.makeAlarmData(state), (BFacets)data);
        BPlatformServiceAlarmRecord alarm = new BPlatformServiceAlarmRecord(BOrd.make((OrdQuery)this.comp.getSlotPath()), this.getAlarmClass(), state, alarmData);
        if (state == BPlatformServiceSourceState.offnormal) {
            this.lastOffnormalTime = alarm.getTimestamp();
        } else if (state == BPlatformServiceSourceState.fault) {
            this.lastFaultTime = alarm.getTimestamp();
        } else if (state == BPlatformServiceSourceState.alert) {
            this.lastAlertTime = alarm.getTimestamp();
        }
        return alarm;
    }

    public BPlatformServiceAlarmRecord makeToNormal() {
        return this.makeToNormal(BFacets.NULL);
    }

    public BPlatformServiceAlarmRecord makeToNormal(BFacets data) {
        return this.makeNewAlarm(BPlatformServiceSourceState.normal, data);
    }

    public boolean ackAlarm(BPlatformServiceAlarmRecord alarm) {
        boolean validAck = false;
        alarm.setAlarmClass(this.getAlarmClass());
        if (alarm.getSourceState() == BPlatformServiceSourceState.offnormal) {
            validAck = this.lastOffnormalTime == null || alarm.getTimestamp().equals((Object)this.lastOffnormalTime);
        } else if (alarm.getSourceState() == BPlatformServiceSourceState.fault) {
            validAck = this.lastFaultTime == null || alarm.getTimestamp().equals((Object)this.lastFaultTime);
        } else if (alarm.getSourceState() == BPlatformServiceSourceState.alert) {
            validAck = this.lastAlertTime == null || alarm.getTimestamp().equals((Object)this.lastAlertTime);
        }
        return validAck;
    }

    public BFacets makeAlarmData(BPlatformServiceSourceState state) {
        HashMap<String, BString> map = new HashMap<String, BString>();
        if (!this.getSourceName().toString().equals("")) {
            map.put("sourceName", BString.make((String)this.getSourceName().format((Object)this)));
        }
        String msgTxt = "";
        if (state == BPlatformServiceSourceState.offnormal) {
            msgTxt = this.getToOffnormalText().toString();
        } else if (state == BPlatformServiceSourceState.fault) {
            msgTxt = this.getToFaultText().toString();
        } else if (state == BPlatformServiceSourceState.alert) {
            msgTxt = this.getAlertText().toString();
        } else if (state == BPlatformServiceSourceState.normal) {
            msgTxt = this.getToNormalText().toString();
        }
        if (!msgTxt.equals("")) {
            map.put("msgText", BString.make((String)msgTxt));
        }
        if (this.getHyperlinkOrd() != BOrd.NULL) {
            map.put("hyperlinkOrd", BString.make((String)this.getHyperlinkOrd().toString()));
        }
        if (this.getSoundFile() != BOrd.NULL) {
            map.put("soundFile", BString.make((String)this.getSoundFile().toString()));
        }
        if (this.getAlarmIcon() != BOrd.NULL) {
            map.put("icon", BString.make((String)this.getAlarmIcon().toString()));
        }
        String[] keys = this.getMetaData().list();
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], (BString)this.getMetaData().get(keys[i]));
        }
        return BFacets.make(map);
    }

    public BIcon getIcon() {
        return icon;
    }
}

