/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platform;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.CertificateStatusEnum;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ServerCertificateHealth;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.message.CertHealthMessage;
import com.tridium.platform.daemon.message.CheckDefaultCredentialsMessage;
import com.tridium.platform.daemon.message.DaemonDebugMessage;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.DaemonUsbBackupMessage;
import com.tridium.platform.daemon.message.SshdMessage;
import com.tridium.platform.daemon.message.SystemPasswordMessage;
import java.io.InputStream;
import java.security.AccessController;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.security.auth.x500.X500Principal;

@NiagaraType(agent={@AgentOn(types={"platform:SystemPlatformService"})})
public final class BSystemPlatformServiceSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BSystemPlatformServiceSecurityDashboardProviderAgent.class);
    private BSystemPlatformService platformService;
    private SecurityDashboardItemBuilder builder;
    private BDaemonSession daemonSession;
    public static Logger log = Logger.getLogger("platform");
    private static final double MILLIS_IN_NINETY_DAYS = BRelTime.makeDays((int)90).getMillis();
    private static final int SECURITY_DASHBOARD_ITEMS_VERSION = 3;
    private static final String SECTION_HEADER = "securityDashboard.systemPlatformService.sectionHeader";
    private static final String TLS_STATUS_TLSONLY_SUMMARY = "securityDashboard.systemPlatformService.tlsService.tlsStatus.tlsOnly.summary";
    private static final String TLS_STATUS_ENABLED_SUMMARY = "securityDashboard.systemPlatformService.tlsService.tlsStatus.enabled.summary";
    private static final String TLS_STATUS_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.tlsService.tlsStatus.disabled.summary";
    private static final String TLS_STATUS_TLS_ONLY_DESCRIPTION = "securityDashboard.systemPlatformService.tlsService.tlsOnly.description";
    private static final String CIPHER_SUITE_SUMMARY = "securityDashboard.systemPlatformService.cipherSuites.cipherSuiteGroup.summary";
    private static final String CIPHER_SUITE_TLS_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.cipherSuites.platformTLSDisabled.summary";
    private static final String CIPHER_SUITE_DESCRIPTION = "securityDashboard.systemPlatformService.cipherSuites.description";
    private static final String TLS_MIN_PROTOCOL_DESCRIPTION = "securityDashboard.systemPlatformService.tlsMinProtocol.description";
    private static final String TLS_MIN_PROTOCOL_TLS_ENABLED_SUMMARY = "securityDashboard.systemPlatformService.tlsMinProtocol.tlsEnabled.summary";
    private static final String TLS_MIN_PROTOCOL_TLS_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.tlsMinProtocol.tlsDisabled.summary";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_ENABLED_VALID = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsEnabled.certValid";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_ENABLED_EXPIRED = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsEnabled.certExpired";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_ENABLED_NEAR_EXPIRY = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsEnabled.certNearExpiry";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_ENABLED_NOT_YET_VALID = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsEnabled.certNotYetValid";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_DISABLED_VALID = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsDisabled.certValid";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_DISABLED_EXPIRED = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsDisabled.certExpired";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_DISABLED_NEAR_EXPIRY = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsDisabled.certNearExpiry";
    private static final String CERTIFICATE_EXPIRY_SUMMARY_DISABLED_NOT_YET_VALID = "securityDashboard.systemPlatformService.certificateExpiry.summary.tlsDisabled.certNotYetValid";
    private static final String CERTIFICATE_EXPIRY_DESCRIPTION_VALID = "securityDashboard.systemPlatformService.certificateExpiry.description.certValid";
    private static final String CERTIFICATE_EXPIRY_DESCRIPTION_EXPIRED = "securityDashboard.systemPlatformService.certificateExpiry.description.certExpired";
    private static final String CERTIFICATE_EXPIRY_DESCRIPTION_NEAR_EXPIRY = "securityDashboard.systemPlatformService.certificateExpiry.description.certNearExpiry";
    private static final String CERTIFICATE_EXPIRY_DESCRIPTION_NOT_YET_VALID = "securityDashboard.systemPlatformService.certificateExpiry.description.certNotYetValid";
    private static final String CERTIFICATE_EXPIRY_DESCRIPTION_DISABLED_EXPIRED = "securityDashboard.systemPlatformService.certificateExpiry.description.tlsDisabled.certExpired";
    private static final String CERTIFICATE_SIGNATURE_TLSENABLED_SIGNED_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsEnabled.signed.summary";
    private static final String CERTIFICATE_SIGNATURE_TLSENABLED_SELFSIGNED_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsEnabled.selfSigned.summary";
    private static final String CERTIFICATE_SIGNATURE_TLSENABLED_DEFAULT_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsEnabled.default.summary";
    private static final String CERTIFICATE_SIGNATURE_TLSDISABLED_SIGNED_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsDisabled.signed.summary";
    private static final String CERTIFICATE_SIGNATURE_TLSDISABLED_SELFSIGNED_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsDisabled.selfSigned.summary";
    private static final String CERTIFICATE_SIGNATURE_TLSDISABLED_DEFAULT_SUMMARY = "securityDashboard.systemPlatformService.certificate.signature.tlsDisabled.default.summary";
    private static final String CERTIFICATE_GLOBALLY_ENCRYPTED_SUMMARY = "securityDashboard.systemPlatformService.certificate.globallyEncrypted.summary";
    private static final String CERTIFICATE_UNIQUELY_ENCRYPTED_SUMMARY = "securityDashboard.systemPlatformService.certificate.uniquelyEncrypted.summary";
    private static final String CERTIFICATE_ENCRYPTED_DESCRIPTION = "securityDashboard.systemPlatformService.certificate.encrypted.description";
    private static final String CERTIFICATE_SIGNATURE_SIGNED_DESCRIPTION = "securityDashboard.systemPlatformService.certificate.signature.signed.description";
    private static final String CERTIFICATE_SIGNATURE_SELFSIGNED_DESCRIPTION = "securityDashboard.systemPlatformService.certificate.signature.selfSigned.description";
    private static final String CERTIFICATE_SIGNATURE_DEFAULT_DESCRIPTION = "securityDashboard.systemPlatformService.certificate.signature.default.description";
    private static final String CERTIFICATE_NOT_FOUND_SUMMARY = "securityDashboard.systemPlatformService.certificate.notFound.summary";
    private static final String CERTIFICATE_NOT_FOUND_DESCRIPTION = "securityDashboard.systemPlatformService.certificate.notFound.description";
    private static final String EXTENDED_MASTER_SECRET_SUMMARY = "securityDashboard.systemPlatformService.extendedMasterSecret.summary";
    private static final String EXTENDED_MASTER_SECRET_DESCRIPTION = "securityDashboard.systemPlatformService.extendedMasterSecret.description";
    private static final String DAEMON_DEBUG_ENABLED_SUMMARY = "securityDashboard.systemPlatformService.daemonDebug.enabled.summary";
    private static final String DAEMON_DEBUG_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.daemonDebug.disabled.summary";
    private static final String DAEMON_DEBUG_DESCRIPTION = "securityDashboard.systemPlatformService.daemonDebug.description";
    private static final String USB_BACKUP_ENABLED_SUMMARY = "securityDashboard.systemPlatformService.usbBackup.enabled.summary";
    private static final String USB_BACKUP_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.usbBackup.disabled.summary";
    private static final String USB_BACKUP_DESCRIPTION = "securityDashboard.systemPlatformService.usbBackup.description";
    private static final String SSH_SFTP_ENABLED_SUMMARY = "securityDashboard.systemPlatformService.sshSFTP.enabled.summary";
    private static final String SSH_SFTP_DISABLED_SUMMARY = "securityDashboard.systemPlatformService.sshSFTP.disabled.summary";
    private static final String SSH_SFTP_DESCRIPTION = "securityDashboard.systemPlatformService.sshSFTP.description";
    private static final String DEFAULT_SYSTEM_PASSPHRASE_SUMMARY = "securityDashboard.systemPlatformService.defaultSystemPassphrase.summary";
    private static final String DEFAULT_SYSTEM_PASSPHRASE_DESCRIPTION = "securityDashboard.systemPlatformService.defaultSystemPassphrase.description";
    private static final String DEFAULT_SYSTEM_PLATFORM_ACCOUNT_SUMMARY = "securityDashboard.systemPlatformService.defaultPlatformAccount.summary";
    private static final String DEFAULT_SYSTEM_PLATFORM_ACCOUNT_DESCRIPTION = "securityDashboard.systemPlatformService.defaultPlatformAccount.description";
    private static final String CERT_HEALTH_OK = "securityDashboard.systemPlatformService.certHealth.ok";
    private static final String CERT_HEALTH_BAD_PASSWORD = "securityDashboard.systemPlatformService.certHealth.badPassword";
    private static final String CERT_HEALTH_MISSING_KEY = "securityDashboard.systemPlatformService.certHealth.missingKey";
    private static final String CERT_HEALTH_BAD_KEY = "securityDashboard.systemPlatformService.certHealth.badKey";
    private static final String CERT_HEALTH_BAD_DEFAULT = "securityDashboard.systemPlatformService.certHealth.badDefault";
    private static final String CERT_HEALTH_DESCRIPTION = "securityDashboard.systemPlatformService.certHealth.description";
    private static final String NO_PLATFORM_DAEMON_SUMMARY = "securityDashboard.systemPlatformService.noPlatformDaemon.summary";
    private static final String NO_PLATFORM_DAEMON_DESCRIPTION = "securityDashboard.systemPlatformService.noPlatformDaemon.description";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.platformService = (BSystemPlatformService)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
        this.daemonSession = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return null;
    }

    public int getSecurityDashboardItemsVersion() {
        return 3;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        if (this.daemonSession != null) {
            try {
                this.daemonSession.reloadHostProperties();
            }
            catch (Exception exception) {
                // empty catch block
            }
            items.addAll(this.getTLSStatus());
            items.addAll(this.getCipherStatus());
            items.addAll(this.getTlsMinProtocol());
            items.addAll(this.getCertificateExpiry());
            items.addAll(this.getSshSftpAlert());
            items.addAll(this.getCertificateSignatureAlert());
            items.addAll(this.getDaemonDebugAlert());
            items.addAll(this.getExtendedMasterSecretAlert());
            items.addAll(this.getDefaultSystemPassphraseAlert());
            items.addAll(this.getDefaultPlatformAccountAlert());
            items.addAll(this.getUSBBackupAlert());
            items.addAll(this.getServerCertificateHealthAlert());
        } else {
            items.add(this.builder.makeInfo(NO_PLATFORM_DAEMON_SUMMARY, NO_PLATFORM_DAEMON_DESCRIPTION));
        }
        return Collections.unmodifiableList(items);
    }

    private List<SecurityDashboardItem> getTLSStatus() {
        ArrayList items = new ArrayList();
        if (this.daemonSession.getHostProperties().getSslSupported()) {
            BPlatformSSLSettings sslSettings = this.daemonSession.getHostProperties().getSslSettings();
            if (sslSettings.getSslEnabled()) {
                if (sslSettings.getSslOnly()) {
                    items.add(this.builder.makeOk().withSummary(TLS_STATUS_TLSONLY_SUMMARY, new Object[0]).withDescription(TLS_STATUS_TLS_ONLY_DESCRIPTION, new Object[0]));
                } else {
                    items.add(this.builder.makeAlert().withSummary(TLS_STATUS_ENABLED_SUMMARY, new Object[0]).withDescription(TLS_STATUS_TLS_ONLY_DESCRIPTION, new Object[0]));
                }
            } else {
                items.add(this.builder.makeAlert().withSummary(TLS_STATUS_DISABLED_SUMMARY, new Object[0]).withDescription(TLS_STATUS_TLS_ONLY_DESCRIPTION, new Object[0]));
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getCipherStatus() {
        ArrayList items = new ArrayList();
        if (this.daemonSession.getHostProperties().getSslSupported()) {
            BPlatformSSLSettings sslSettings = this.daemonSession.getHostProperties().getSslSettings();
            if (sslSettings.getSslEnabled()) {
                if (sslSettings.getTlsCipherSuiteGroup().equals((Object)BTlsCipherSuiteGroup.recommended)) {
                    items.add(this.builder.makeOk().withSummary(CIPHER_SUITE_SUMMARY, new Object[]{sslSettings.getTlsCipherSuiteGroup()}).withDescription(CIPHER_SUITE_DESCRIPTION, new Object[0]));
                } else {
                    items.add(this.builder.makeWarning().withSummary(CIPHER_SUITE_SUMMARY, new Object[]{sslSettings.getTlsCipherSuiteGroup()}).withDescription(CIPHER_SUITE_DESCRIPTION, new Object[0]));
                }
            } else {
                items.add(this.builder.makeInfo().withSummary(CIPHER_SUITE_TLS_DISABLED_SUMMARY, new Object[]{sslSettings.getTlsCipherSuiteGroup()}).withDescription(CIPHER_SUITE_DESCRIPTION, new Object[0]));
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getTlsMinProtocol() {
        ArrayList items = new ArrayList();
        if (this.daemonSession.getHostProperties().getSslSupported()) {
            BPlatformSSLSettings sslSettings = this.daemonSession.getHostProperties().getSslSettings();
            BSslTlsEnum tlsMinProtocol = sslSettings.getSslAlgType();
            if (sslSettings.getSslEnabled()) {
                if (BSystemPlatformServiceSecurityDashboardProviderAgent.isTlsVersionStrong(tlsMinProtocol)) {
                    items.add(this.builder.makeOk().withSummary(TLS_MIN_PROTOCOL_TLS_ENABLED_SUMMARY, new Object[]{tlsMinProtocol}).withDescription(TLS_MIN_PROTOCOL_DESCRIPTION, new Object[]{BSslTlsEnum.tlsv1_2}));
                } else {
                    items.add(this.builder.makeWarning().withSummary(TLS_MIN_PROTOCOL_TLS_ENABLED_SUMMARY, new Object[]{tlsMinProtocol}).withDescription(TLS_MIN_PROTOCOL_DESCRIPTION, new Object[]{BSslTlsEnum.tlsv1_2}));
                }
            } else {
                items.add(this.builder.makeInfo().withSummary(TLS_MIN_PROTOCOL_TLS_DISABLED_SUMMARY, new Object[]{tlsMinProtocol}).withDescription(TLS_MIN_PROTOCOL_DESCRIPTION, new Object[]{BSslTlsEnum.tlsv1_2}));
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private static boolean isTlsVersionStrong(BSslTlsEnum tlsVersion) {
        return tlsVersion.equals((Object)BSslTlsEnum.tlsv1_2) || tlsVersion.equals((Object)BSslTlsEnum.tlsv1_3);
    }

    private List<SecurityDashboardItem> getCertificateExpiry() {
        ArrayList items;
        block12: {
            items = new ArrayList();
            if (this.daemonSession.getHostProperties().getSslSupported()) {
                BPlatformSSLSettings sslSettings = this.daemonSession.getHostProperties().getSslSettings();
                String alias = sslSettings.getKeyAlias();
                try {
                    X509Certificate certificate = CertManagerFactory.getInstance().getKeyStore().getCertificate(alias);
                    try {
                        certificate.checkValidity();
                        Date date = new Date();
                        if ((double)(certificate.getNotAfter().getTime() - date.getTime()) < MILLIS_IN_NINETY_DAYS) {
                            if (sslSettings.getSslEnabled()) {
                                items.add(this.builder.makeWarning().withSummary(CERTIFICATE_EXPIRY_SUMMARY_ENABLED_NEAR_EXPIRY, new Object[]{BString.make((String)alias), BAbsTime.make((long)certificate.getNotAfter().getTime())}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_NEAR_EXPIRY, new Object[0]));
                            } else {
                                items.add(this.builder.makeInfo().withSummary(CERTIFICATE_EXPIRY_SUMMARY_DISABLED_NEAR_EXPIRY, new Object[]{BString.make((String)alias), BAbsTime.make((long)certificate.getNotAfter().getTime())}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_NEAR_EXPIRY, new Object[0]));
                            }
                            break block12;
                        }
                        if (sslSettings.getSslEnabled()) {
                            items.add(this.builder.makeOk().withSummary(CERTIFICATE_EXPIRY_SUMMARY_ENABLED_VALID, new Object[]{alias}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_VALID, new Object[0]));
                            break block12;
                        }
                        items.add(this.builder.makeInfo().withSummary(CERTIFICATE_EXPIRY_SUMMARY_DISABLED_VALID, new Object[]{alias}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_VALID, new Object[0]));
                    }
                    catch (CertificateExpiredException e) {
                        if (sslSettings.getSslEnabled()) {
                            items.add(this.builder.makeAlert().withSummary(CERTIFICATE_EXPIRY_SUMMARY_ENABLED_EXPIRED, new Object[]{alias}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_EXPIRED, new Object[0]));
                            break block12;
                        }
                        items.add(this.builder.makeInfo().withSummary(CERTIFICATE_EXPIRY_SUMMARY_DISABLED_EXPIRED, new Object[]{alias}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_DISABLED_EXPIRED, new Object[0]));
                    }
                    catch (CertificateNotYetValidException e) {
                        if (sslSettings.getSslEnabled()) {
                            items.add(this.builder.makeAlert().withSummary(CERTIFICATE_EXPIRY_SUMMARY_ENABLED_NOT_YET_VALID, new Object[]{BString.make((String)alias), BAbsTime.make((long)certificate.getNotBefore().getTime())}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_NOT_YET_VALID, new Object[0]));
                            break block12;
                        }
                        items.add(this.builder.makeInfo().withSummary(CERTIFICATE_EXPIRY_SUMMARY_DISABLED_NOT_YET_VALID, new Object[]{BString.make((String)alias), BAbsTime.make((long)certificate.getNotBefore().getTime())}).withDescription(CERTIFICATE_EXPIRY_DESCRIPTION_NOT_YET_VALID, new Object[0]));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getCertificateSignatureAlert() {
        ArrayList items = new ArrayList();
        if (this.daemonSession.getHostProperties().getSslSupported()) {
            BPlatformSSLSettings sslSettings = this.daemonSession.getHostProperties().getSslSettings();
            String alias = sslSettings.getKeyAlias();
            try {
                X509Certificate certificate = CertManagerFactory.getInstance().getKeyStore().getCertificate(alias);
                if (CertUtils.checkDnEquality((X500Principal)certificate.getSubjectX500Principal(), (X500Principal)certificate.getIssuerX500Principal())) {
                    if ("default".equalsIgnoreCase(alias)) {
                        if (sslSettings.getSslEnabled()) {
                            items.add(this.builder.makeWarning().withSummary(CERTIFICATE_SIGNATURE_TLSENABLED_DEFAULT_SUMMARY, new Object[0]).withDescription(CERTIFICATE_SIGNATURE_DEFAULT_DESCRIPTION, new Object[0]));
                        } else {
                            items.add(this.builder.makeInfo().withSummary(CERTIFICATE_SIGNATURE_TLSDISABLED_DEFAULT_SUMMARY, new Object[0]).withDescription(CERTIFICATE_SIGNATURE_DEFAULT_DESCRIPTION, new Object[0]));
                        }
                    } else if (sslSettings.getSslEnabled()) {
                        items.add(this.builder.makeWarning().withSummary(CERTIFICATE_SIGNATURE_TLSENABLED_SELFSIGNED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_SIGNATURE_SELFSIGNED_DESCRIPTION, new Object[0]));
                    } else {
                        items.add(this.builder.makeInfo().withSummary(CERTIFICATE_SIGNATURE_TLSDISABLED_SELFSIGNED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_SIGNATURE_SELFSIGNED_DESCRIPTION, new Object[0]));
                    }
                } else if (sslSettings.getSslEnabled()) {
                    items.add(this.builder.makeOk().withSummary(CERTIFICATE_SIGNATURE_TLSENABLED_SIGNED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_SIGNATURE_SIGNED_DESCRIPTION, new Object[0]));
                } else {
                    items.add(this.builder.makeInfo().withSummary(CERTIFICATE_SIGNATURE_TLSDISABLED_SIGNED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_SIGNATURE_SIGNED_DESCRIPTION, new Object[0]));
                }
                ICoreKeyStore keyStore = (ICoreKeyStore)CertManagerFactory.getInstance().getKeyStore();
                if (CertUtils.isPrivateKeyGloballyEncrypted((String)alias, (ICoreKeyStore)keyStore)) {
                    items.add(this.builder.makeWarning().withSummary(CERTIFICATE_GLOBALLY_ENCRYPTED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_ENCRYPTED_DESCRIPTION, new Object[0]));
                } else {
                    items.add(this.builder.makeOk().withSummary(CERTIFICATE_UNIQUELY_ENCRYPTED_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_ENCRYPTED_DESCRIPTION, new Object[0]));
                }
            }
            catch (Exception e) {
                if (sslSettings.getSslEnabled()) {
                    items.add(this.builder.makeWarning().withSummary(CERTIFICATE_NOT_FOUND_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_NOT_FOUND_DESCRIPTION, new Object[0]));
                }
                items.add(this.builder.makeInfo().withSummary(CERTIFICATE_NOT_FOUND_SUMMARY, new Object[]{alias}).withDescription(CERTIFICATE_NOT_FOUND_DESCRIPTION, new Object[0]));
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getServerCertificateHealthAlert() {
        ArrayList items = new ArrayList();
        if (new Version(this.daemonSession.getHostProperties().getDaemonVersion()).compareTo(new Version("4.13")) >= 0) {
            try {
                XElem elem = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new CertHealthMessage(), "text/xml")).parse();
                ServerCertificateHealth health = new ServerCertificateHealth(elem.get("requestedCert"), elem.get("returnedCert"), CertificateStatusEnum.valueOf((String)elem.get("certStatus")));
                switch (health.getCause()) {
                    case OK: {
                        items.add(this.builder.makeOk().withSummary(CERT_HEALTH_OK, new Object[]{health.getReturnedCert()}).withDescription(CERT_HEALTH_DESCRIPTION, new Object[0]));
                        break;
                    }
                    case BAD_PASSWORD: {
                        items.add(this.builder.makeAlert().withSummary(CERT_HEALTH_BAD_PASSWORD, new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription(CERT_HEALTH_DESCRIPTION, new Object[0]));
                        break;
                    }
                    case BAD_KEY: {
                        items.add(this.builder.makeAlert().withSummary(CERT_HEALTH_BAD_KEY, new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription(CERT_HEALTH_DESCRIPTION, new Object[0]));
                        break;
                    }
                    case MISSING_KEY: {
                        items.add(this.builder.makeAlert().withSummary(CERT_HEALTH_MISSING_KEY, new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription(CERT_HEALTH_DESCRIPTION, new Object[0]));
                        break;
                    }
                    case BAD_DEFAULT: {
                        items.add(this.builder.makeAlert().withSummary(CERT_HEALTH_BAD_DEFAULT, new Object[]{health.getRequestedCert(), health.getReturnedCert()}).withDescription(CERT_HEALTH_DESCRIPTION, new Object[0]));
                    }
                }
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.WARNING, "unable to check server certificate health", e);
                }
                log.log(Level.WARNING, "unable to check server certificate health: " + e.getLocalizedMessage());
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getDefaultSystemPassphraseAlert() {
        ArrayList items = new ArrayList();
        try {
            XElem systemPasswordElem = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new SystemPasswordMessage(), "text/xml")).parse();
            boolean factoryDefaultSystemPasswordPresent = systemPasswordElem.getb("default", false);
            if (factoryDefaultSystemPasswordPresent) {
                items.add(this.builder.makeAlert(DEFAULT_SYSTEM_PASSPHRASE_SUMMARY, DEFAULT_SYSTEM_PASSPHRASE_DESCRIPTION));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getDefaultPlatformAccountAlert() {
        ArrayList items = new ArrayList();
        try {
            XElem userElem;
            boolean defaultCredentialsPresent = false;
            XElem authInfo = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new CheckDefaultCredentialsMessage(), "text/xml")).parse();
            XElem authElem = authInfo.elem("auth");
            if (authElem != null && (userElem = authElem.elem("user")) != null && (defaultCredentialsPresent = userElem.getb("default", false))) {
                items.add(this.builder.makeAlert(DEFAULT_SYSTEM_PLATFORM_ACCOUNT_SUMMARY, DEFAULT_SYSTEM_PLATFORM_ACCOUNT_DESCRIPTION));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getExtendedMasterSecretAlert() {
        ArrayList items = new ArrayList();
        if (this.daemonSession.getHostProperties().getSslSupported()) {
            BPlatformSSLSettings sslSettings = this.daemonSession.getHostProperties().getSslSettings();
            if (sslSettings.getSslEnabled()) {
                if ("true".equals(sslSettings.getUseExtendedMasterSecret())) {
                    items.add(this.builder.makeOk().withSummary(EXTENDED_MASTER_SECRET_SUMMARY, new Object[]{sslSettings.getUseExtendedMasterSecret()}).withDescription(EXTENDED_MASTER_SECRET_DESCRIPTION, new Object[0]));
                } else {
                    items.add(this.builder.makeWarning().withSummary(EXTENDED_MASTER_SECRET_SUMMARY, new Object[]{sslSettings.getUseExtendedMasterSecret()}).withDescription(EXTENDED_MASTER_SECRET_DESCRIPTION, new Object[0]));
                }
            } else {
                items.add(this.builder.makeInfo().withSummary(EXTENDED_MASTER_SECRET_SUMMARY, new Object[]{sslSettings.getUseExtendedMasterSecret()}).withDescription(EXTENDED_MASTER_SECRET_DESCRIPTION, new Object[0]));
            }
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getSshSftpAlert() {
        ArrayList items = new ArrayList();
        try {
            if (this.daemonSession.getHostProperties().supportsServlet("sshd")) {
                XElem elem = XParser.make((InputStream)this.daemonSession.getInputStream((DaemonMessage)new SshdMessage(false), 0)).parse();
                int sshdPort = elem.geti("port", -1);
                if (sshdPort > 0) {
                    items.add(this.builder.makeAlert().withSummary(SSH_SFTP_ENABLED_SUMMARY, new Object[0]).withDescription(SSH_SFTP_DESCRIPTION, new Object[0]));
                } else {
                    items.add(this.builder.makeOk().withSummary(SSH_SFTP_DISABLED_SUMMARY, new Object[0]).withDescription(SSH_SFTP_DESCRIPTION, new Object[0]));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getDaemonDebugAlert() {
        ArrayList items = new ArrayList();
        try {
            if (this.daemonSession.getHostProperties().supportsServlet("debug")) {
                XElem debugElem = XParser.make((InputStream)this.daemonSession.getInputStream(new DaemonDebugMessage())).parse();
                boolean daemonDebugFlag = debugElem.getb("daemonDebug", false);
                if (daemonDebugFlag) {
                    items.add(this.builder.makeAlert().withSummary(DAEMON_DEBUG_ENABLED_SUMMARY, new Object[0]).withDescription(DAEMON_DEBUG_DESCRIPTION, new Object[0]));
                } else {
                    items.add(this.builder.makeOk().withSummary(DAEMON_DEBUG_DISABLED_SUMMARY, new Object[0]).withDescription(DAEMON_DEBUG_DESCRIPTION, new Object[0]));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return items == null ? Collections.emptyList() : items;
    }

    private List<SecurityDashboardItem> getUSBBackupAlert() {
        ArrayList items = new ArrayList();
        try {
            if (this.daemonSession.getHostProperties().supportsServlet("usbbackup")) {
                XElem usbElem = XParser.make((InputStream)this.daemonSession.getInputStream(new DaemonUsbBackupMessage())).parse();
                boolean usbBackupEnabled = usbElem.getb("enabled", false);
                if (usbBackupEnabled) {
                    items.add(this.builder.makeWarning().withSummary(USB_BACKUP_ENABLED_SUMMARY, new Object[0]).withDescription(USB_BACKUP_DESCRIPTION, new Object[0]));
                } else {
                    items.add(this.builder.makeInfo().withSummary(USB_BACKUP_DISABLED_SUMMARY, new Object[0]).withDescription(USB_BACKUP_DESCRIPTION, new Object[0]));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return items == null ? Collections.emptyList() : items;
    }
}

