/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.install;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.baja.file.BIFile;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.platform.install.BFileReconciler;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XWriter;

@NiagaraType
@NiagaraSingleton
public class BUnitDatabaseMerge
extends BFileReconciler {
    @Generated
    public static final BUnitDatabaseMerge INSTANCE = new BUnitDatabaseMerge();
    @Generated
    public static final Type TYPE = Sys.loadType(BUnitDatabaseMerge.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BUnitDatabaseMerge() {
    }

    @Override
    public BFileReconciler.ReconciliationResults reconcile(BIFile newContents, BIFile existingContents) throws Exception {
        boolean anyChanges = false;
        HashMap<String, XElem> unitElemByName = new HashMap<String, XElem>();
        HashMap<String, XElem> quantityElemByName = new HashMap<String, XElem>();
        HashMap<String, String> quantityNameByUnitName = new HashMap<String, String>();
        XElem oldDom = this.parseFile(existingContents);
        XElem[] qElems = oldDom.elems("quantity");
        for (int ixQuantity = 0; ixQuantity < qElems.length; ++ixQuantity) {
            XElem qOld = qElems[ixQuantity];
            String qName = qOld.get("n");
            quantityElemByName.put(qName, qOld);
            XElem[] uElems = qOld.elems("unit");
            for (int ixUnit = 0; ixUnit < uElems.length; ++ixUnit) {
                String uName = uElems[ixUnit].get("n");
                unitElemByName.put(uName, uElems[ixUnit]);
                quantityNameByUnitName.put(uName, qName);
            }
        }
        XElem newDom = this.parseFile(newContents);
        qElems = newDom.elems("quantity");
        for (int ixQuantity = 0; ixQuantity < qElems.length; ++ixQuantity) {
            XElem qNew = qElems[ixQuantity];
            String qName = qNew.get("n");
            XElem[] uElems = qNew.elems("unit");
            for (int ixUnit = 0; ixUnit < uElems.length; ++ixUnit) {
                XElem qOld;
                XElem uNew = uElems[ixUnit];
                String uName = uNew.get("n");
                XElem uOld = (XElem)unitElemByName.get(uName);
                if (uOld == null) {
                    XElem qOld2 = this.getOldQuantityElem(qNew, oldDom, quantityElemByName);
                    uOld = uNew.copy();
                    qOld2.addContent((XContent)uOld);
                    unitElemByName.put(uName, uOld);
                    anyChanges = true;
                    continue;
                }
                String qNameOld = (String)quantityNameByUnitName.get(uName);
                if (!qName.equals(qNameOld)) {
                    qOld = quantityElemByName.get(qNameOld);
                    qOld.removeContent((XContent)uOld);
                    qOld = this.getOldQuantityElem(qNew, oldDom, quantityElemByName);
                    uOld = uNew.copy();
                    qOld.addContent((XContent)uOld);
                    quantityNameByUnitName.put(uName, qName);
                    unitElemByName.put(uName, uOld);
                    anyChanges = true;
                    continue;
                }
                if (this.equivalent(uNew, uOld)) continue;
                qOld = this.getOldQuantityElem(qNew, oldDom, quantityElemByName);
                qOld.removeContent((XContent)uOld);
                uOld = uNew.copy();
                qOld.addContent((XContent)uOld);
                unitElemByName.put(uName, uOld);
                anyChanges = true;
            }
        }
        if (anyChanges) {
            return new XmlReconciliationResults(oldDom);
        }
        return NO_RECONCILIATION;
    }

    protected XElem getOldQuantityElem(XElem qNew, XElem oldDom, Map<String, XElem> quantityElemByName) {
        String qName = qNew.get("n");
        XElem qOld = quantityElemByName.get(qName);
        if (qOld == null) {
            qOld = this.shallowCopy(qNew);
            oldDom.addContent((XContent)qOld);
            quantityElemByName.put(qName, qOld);
        }
        return qOld;
    }

    protected boolean equivalent(XElem e1, XElem e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null) {
            return e2 == null;
        }
        if (e2 == null) {
            return false;
        }
        if (this.equals(e1.ns(), e2.ns()) && this.equals(e1.name(), e2.name()) && e1.attrSize() == e2.attrSize()) {
            for (int ixAttr1 = 0; ixAttr1 < e1.attrSize(); ++ixAttr1) {
                int ixAttr2 = e2.attrIndex(e1.attrNs(ixAttr1), e1.attrName(ixAttr1));
                if (ixAttr2 < 0) {
                    return false;
                }
                if (this.equals(e1.attrValue(ixAttr1), e2.attrValue(ixAttr2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean equals(Object s1, Object s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    protected XElem parseFile(BIFile contents) throws Exception {
        try (InputStream in = contents.getInputStream();){
            XElem xElem = XParser.make((InputStream)in).parse();
            return xElem;
        }
    }

    protected XElem shallowCopy(XElem src) {
        XElem result = new XElem(src.ns(), src.name());
        for (int ixAttr = 0; ixAttr < src.attrSize(); ++ixAttr) {
            result.addAttr(src.attrNs(ixAttr), src.attrName(ixAttr), src.attrValue(ixAttr));
        }
        return result;
    }

    public static class XmlReconciliationResults
    implements BFileReconciler.ReconciliationResults {
        public byte[] contents;

        public XmlReconciliationResults(XElem elem) throws Exception {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XWriter w = new XWriter((OutputStream)out);
            elem.write(w);
            w.flush();
            this.contents = out.toByteArray();
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.contents);
        }

        @Override
        public long getSize() {
            return this.contents.length;
        }

        @Override
        public boolean shouldReplaceContents() {
            return true;
        }
    }
}

