/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDaemon;

import com.tridium.file.types.text.BCertificateFile;
import com.tridium.file.types.text.BLicenseFile;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BModelPart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.platform.BFilesystemAttributes;
import com.tridium.platform.BHostIdStatus;
import com.tridium.platform.BPlatformSSLSettings;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCacheAccessPolicy;
import com.tridium.platform.daemon.file.BDaemonDirectoryStore;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.license.CertificateInfo;
import com.tridium.platform.license.LicenseInfo;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileSpace;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BVector;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.util.Lexicon;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public final class ConfigDetails {
    private static final Lexicon lex = Lexicon.make((String)"platDaemon");
    private static final int SUMMARY_PADDING = 26;
    private static final int KB_PADDING = 16;
    private static final int INT_MAX_PADDING = 11;

    private ConfigDetails() {
    }

    public static void printDetails(BDaemonPlatform platform, BAppSurrogate[] apps, PrintWriter out) throws Exception {
        ConfigDetails.printDetails(platform, apps, out, null);
    }

    public static void printDetails(BDaemonPlatform platform, BAppSurrogate[] apps, PrintWriter out, DaemonSessionTaskListener taskListener) throws Exception {
        LicenseInfo info;
        BIFileStore kid;
        BDaemonDirectoryStore dirStore;
        boolean showFileCount;
        String serialNumber;
        BDaemonSession session = platform.getDaemonSession();
        session.updateHostProperties();
        ConfigDetails.printlnLex(out, "summaryHeader", new Object[]{session.getRemoteHost().getHostname()}, true);
        out.println();
        String daemonVersion = platform.getDaemonVersion();
        if (daemonVersion == null || "unknown".equals(daemonVersion)) {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.daemonVersion") + ": "), (int)26) + lex.getText("PlatformAdministration.unknownValue"));
        } else {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.daemonVersion") + ": "), (int)26) + platform.getDaemonVersion());
        }
        boolean daemonTlsOnly = platform.getPlatformSSLSupported() && platform.getPlatformSSLSettings() != null && platform.getPlatformSSLSettings().getSslLicensed() && platform.getPlatformSSLSettings().getSslEnabled() && platform.getPlatformSSLSettings().getSslOnly();
        out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.daemonPort") + ": "), (int)26) + (daemonTlsOnly ? lex.getText("PlatformAdministration.port.disabled", new Object[]{String.valueOf(platform.getPort())}) : Integer.valueOf(platform.getPort())));
        BHostProperties sessionHostProperties = session.getHostProperties();
        out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.hostId") + ": "), (int)26) + platform.getHostId());
        out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.hostIdStatusLabel") + ": "), (int)26) + lex.getText("PlatformAdministration.hostIdStatus." + sessionHostProperties.getHostIdSettings().getHostIdStatus().getTag()));
        BNrePart nrePart = platform.getNrePart();
        if (nrePart == null || nrePart.isNull()) {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.nre") + ": "), (int)26) + lex.getText("PlatformAdministration.unknownValue"));
        } else {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.nre") + ": "), (int)26) + BVersion.formatNameVersion((String)nrePart.getPartName(), (BVersion)nrePart.getVersion(), null));
        }
        out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.arch") + ": "), (int)26) + platform.getArchPart().getPartName());
        out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.numCpus") + ": "), (int)26) + sessionHostProperties.getNumCpus());
        BModelPart modelPart = platform.getModelPart();
        if (modelPart != null && !modelPart.isNull()) {
            String modelName = platform.getModelPart().getPartName();
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.model") + ": "), (int)26) + BVersion.formatNameVersion((String)modelName, (BVersion)modelPart.getVersion(), null));
            String productName = platform.getModelPart().getDescription();
            if ("".equalsIgnoreCase(productName) || "unknown".equalsIgnoreCase(productName)) {
                switch (modelName) {
                    case "TITAN": {
                        productName = "JACE-8000";
                        break;
                    }
                    default: {
                        productName = modelName;
                    }
                }
            }
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.product") + ": "), (int)26) + productName);
        }
        if ((serialNumber = sessionHostProperties.getSerialNumber()) == null || serialNumber.isEmpty() || "unknown".equalsIgnoreCase(serialNumber)) {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.serialNumber") + ": "), (int)26) + lex.getText("PlatformAdministration.noneValue"));
        } else {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.serialNumber") + ": "), (int)26) + serialNumber);
        }
        if (!platform.getIsNiagara4()) {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.moduleContent") + ": "), (int)26) + lex.getText("ModuleContent." + platform.getModuleContent().getTag()));
        } else {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.runtimeProfiles") + ": "), (int)26) + String.join((CharSequence)",", platform.getEnabledRuntimeProfileNames()));
        }
        BOsPart osPart = platform.getOsPart();
        if (osPart == null || osPart.isNull()) {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.os") + ": "), (int)26) + lex.getText("PlatformAdministration.unknownValue"));
        } else {
            String osText = osPart.getDescription();
            if (osText == null || osText.trim().isEmpty()) {
                osText = osPart.getPartName();
            }
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.os") + ": "), (int)26) + BVersion.formatNameVersion((String)osText, (BVersion)osPart.getVersion(), null));
        }
        BVmPart vmPart = platform.getVmPart();
        if (vmPart == null || vmPart.isNull()) {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.vm") + ": "), (int)26) + lex.getText("PlatformAdministration.unknownValue"));
        } else if (vmPart.getUnspecified()) {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.vm") + ": "), (int)26) + Lexicon.make((String)"platform").getText("unspecifiedVm.label"));
        } else {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.vm") + ": "), (int)26) + BVersion.formatNameVersion((BPart)vmPart, null));
        }
        out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.niagaraStationsEnabled") + ": "), (int)26) + (platform.getNiagaraStationsEnabled() ? lex.getText("PlatformAdministration.niagaraStationsEnabled.enabled") : lex.getText("PlatformAdministration.niagaraStationsEnabled.disabled")));
        if (platform.getSedonaSupported()) {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.sedonaSupport") + ": "), (int)26) + (platform.getSedonaEnabled() ? lex.getText("PlatformAdministration.sedonaSupport.enabled") : lex.getText("PlatformAdministration.sedonaSupport.disabled")));
        }
        if (platform.getNiagaraR2Supported()) {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.niagaraR2Support") + ": "), (int)26) + (platform.getNiagaraR2Enabled() ? lex.getText("PlatformAdministration.niagaraR2Support.enabled") : lex.getText("PlatformAdministration.niagaraR2Support.disabled")));
        }
        if (platform.getPlatformSSLSupported()) {
            BPlatformSSLSettings settings = platform.getPlatformSSLSettings();
            if (settings.getSslEnabled()) {
                if (settings.getSslOnly()) {
                    out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.sslSupport") + ": "), (int)26) + TextUtil.toLowerCase((String)lex.getText("PlatformAdministration.command.sslSettings.status.sslOnly")));
                } else {
                    out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.sslSupport") + ": "), (int)26) + TextUtil.toLowerCase((String)lex.getText("PlatformAdministration.command.sslSettings.status.sslEnabled")));
                }
            } else {
                out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.sslSupport") + ": "), (int)26) + TextUtil.toLowerCase((String)lex.getText("PlatformAdministration.command.sslSettings.status.sslDisabled")));
            }
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.command.sslSettings.sslPort") + ": "), (int)26) + settings.getSslPort());
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.command.sslSettings.sslKeyAlias") + ": "), (int)26) + settings.getKeyAlias());
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.command.sslSettings.sslAlgType") + ": "), (int)26) + settings.getSslAlgType());
        } else {
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.sslSupport") + ": "), (int)26) + TextUtil.toLowerCase((String)lex.getText("PlatformAdministration.sslNotSupported")));
        }
        String sysHomePath = lex.getText("PlatformAdministration.unavailable");
        try {
            XElem sysHomeElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new GetDirectoryMessage(new FilePath("!"), false, false, true, (BDaemonFileSpace)session.getFileSpace()))).parse();
            sysHomePath = sysHomeElem.get("path", lex.getText("PlatformAdministration.unavailable"));
        }
        catch (Exception sysHomeElem) {
            // empty catch block
        }
        out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.homeDir") + ": "), (int)26) + sysHomePath);
        if (platform.getIsNiagara4()) {
            String userHomePath = lex.getText("PlatformAdministration.unavailable");
            try {
                XElem userHomeElem = XParser.make((InputStream)session.getInputStream((DaemonMessage)new GetDirectoryMessage(new FilePath("~"), false, false, true, (BDaemonFileSpace)session.getFileSpace()))).parse();
                userHomePath = userHomeElem.get("path", lex.getText("PlatformAdministration.unavailable"));
            }
            catch (Exception userHomeElem) {
                // empty catch block
            }
            out.println(TextUtil.pad((String)(lex.getText("PlatformAdministration.userHomeDir") + ": "), (int)26) + userHomePath);
        }
        out.println();
        DecimalFormat kbFormat = (DecimalFormat)DaemonFileUtil.kbFormat.get();
        StringBuilder outputBuilderString = new StringBuilder();
        outputBuilderString.append(TextUtil.pad((String)lex.getText("PlatformAdministration.filesystem"), (int)26)).append(TextUtil.pad((String)lex.getText("PlatformAdministration.totalKb"), (int)16)).append("  ").append(TextUtil.pad((String)lex.getText("PlatformAdministration.freeKb"), (int)16));
        boolean bl = showFileCount = sessionHostProperties.getOsName().startsWith("qnx-jace") || sessionHostProperties.getOsName().startsWith("tridium-qnx7") || sessionHostProperties.getIsNpsdk();
        if (showFileCount) {
            outputBuilderString.append("  ").append(TextUtil.pad((String)lex.getText("PlatformAdministration.currentFileCount"), (int)11)).append("  ").append(TextUtil.pad((String)lex.getText("PlatformAdministration.maxFileCount"), (int)11));
        }
        out.println(outputBuilderString);
        BVector filesystemAttributes = sessionHostProperties.getFilesystemAttributes();
        SlotCursor attributesCursor = filesystemAttributes.getProperties();
        while (attributesCursor.next(BFilesystemAttributes.class)) {
            Property attributesProperty = attributesCursor.property();
            if ((filesystemAttributes.getFlags((Slot)attributesProperty) & 4) != 0) continue;
            BFilesystemAttributes attrs = (BFilesystemAttributes)attributesCursor.get();
            outputBuilderString = new StringBuilder();
            outputBuilderString.append("  ").append(TextUtil.pad((String)filesystemAttributes.getDisplayName((Slot)attributesProperty, null), (int)24)).append(TextUtil.padLeft((String)kbFormat.format(attrs.getTotalSpace()), (int)16)).append("  ").append(TextUtil.padLeft((String)kbFormat.format(attrs.getFreeSpace()), (int)16));
            if (showFileCount) {
                String currentFileText = attrs.getCurrentFileCount() < 0L ? lex.getText("PlatformAdministration.unavailable") : String.valueOf(attrs.getCurrentFileCount());
                String maxFileText = attrs.getMaxFileCount() < 0L ? lex.getText("PlatformAdministration.unavailable") : String.valueOf(attrs.getMaxFileCount());
                outputBuilderString.append("  ").append(TextUtil.padLeft((String)currentFileText, (int)11)).append("  ").append(TextUtil.padLeft((String)maxFileText, (int)11));
            }
            out.println(outputBuilderString);
        }
        out.println();
        int totalMem = sessionHostProperties.getTotalPhysicalMemory();
        int freeMem = sessionHostProperties.getFreePhysicalMemory();
        outputBuilderString = new StringBuilder();
        outputBuilderString.append(TextUtil.pad((String)lex.getText("PlatformAdministration.physicalMemory"), (int)26)).append(TextUtil.pad((String)lex.getText("PlatformAdministration.totalKb"), (int)16)).append("  ").append(TextUtil.pad((String)lex.getText("PlatformAdministration.freeKb"), (int)16));
        out.println(outputBuilderString);
        outputBuilderString = new StringBuilder(TextUtil.getSpaces((int)26));
        outputBuilderString.append(TextUtil.padLeft((String)kbFormat.format(totalMem), (int)16)).append("  ").append(TextUtil.padLeft((String)kbFormat.format(freeMem), (int)16));
        out.println(outputBuilderString);
        out.println();
        ConfigDetails.printlnLex(out, "modules");
        platform.getModuleList().doInit(taskListener);
        SlotCursor c = platform.getModuleList().getModules().getProperties();
        while (c.next()) {
            Property[] mod = ((BModuleInstallable)c.get()).getModulePart();
            out.println("  " + BVersion.formatNameVersion((BPart)mod, null));
        }
        out.println();
        ConfigDetails.printlnLex(out, "other");
        Property[] otherProps = platform.getOtherParts().getPropertiesArray();
        if (otherProps.length == 0) {
            out.println("  " + lex.getText("PlatformAdministration.noneValue"));
        } else {
            for (Property property : otherProps) {
                BGenericPart part = (BGenericPart)platform.getOtherParts().get(property);
                out.println("  " + BVersion.formatNameVersion((BPart)part, null));
            }
        }
        out.println();
        ConfigDetails.printlnLex(out, "apps");
        for (Property property : apps) {
            out.print("  " + property.toString(null) + ' ');
            ConfigDetails.printLex(out, "isAutoStart");
            out.print('=' + String.valueOf(property.getIsAutoStart()) + ", ");
            ConfigDetails.printLex(out, "isAutoRestart");
            out.print('=' + String.valueOf(property.getIsAutoRestart()) + ", ");
            if (property instanceof BStationSurrogate) {
                BStationSurrogate station = (BStationSurrogate)property;
                if (station.getFoxPort() != -1) {
                    out.print("fox=" + station.getFoxPort() + ", ");
                }
                if (station.getFoxsPort() != -1) {
                    out.print("foxs=" + station.getFoxsPort() + ", ");
                }
                if (station.getHttpPort() != -1) {
                    out.print("http=" + station.getHttpPort() + ", ");
                }
                if (station.getHttpsPort() != -1) {
                    out.print("https=" + station.getHttpsPort() + ", ");
                }
            }
            ConfigDetails.printLex(out, "appStatus");
            out.println('=' + property.getAppStatus().toString());
        }
        if (!sessionHostProperties.getIsNiagaraHomeReadonly()) {
            out.println();
            ConfigDetails.printlnLex(out, "lexicons");
            dirStore = BDaemonDirectoryStore.make((BDaemonFileSpace)session.getFileSpace(), (FilePath)SystemFilePaths.getLexiconHomePath((BIFileSpace)session.getFileSpace()), (boolean)true, (boolean)false, (boolean)false, null);
            if (dirStore != null) {
                Array lexKids = dirStore.getChildren(BCacheAccessPolicy.lazyFetch);
                for (int i = 0; i < lexKids.size(); ++i) {
                    if (!((BIFileStore)lexKids.get(i)).isDirectory()) continue;
                    out.println("  " + ((BIFileStore)lexKids.get(i)).getFileName());
                }
            }
        }
        out.println();
        ConfigDetails.printlnLex(out, "licenses");
        BHostIdStatus hostIdStatus = sessionHostProperties.getHostIdSettings().getHostIdStatus();
        boolean isNiagaraHomeReadonly = platform.getIsNiagaraHomeReadonly();
        dirStore = BDaemonDirectoryStore.make((BDaemonFileSpace)session.getFileSpace(), (FilePath)SystemFilePaths.getLicensesDirPath((BIFileSpace)session.getFileSpace(), (boolean)hostIdStatus.isPerpetual(), (boolean)isNiagaraHomeReadonly), (boolean)true, (boolean)false, (boolean)false, null);
        if (dirStore != null) {
            Array array = dirStore.getChildren(BCacheAccessPolicy.lazyFetch);
            for (int i = 0; i < array.size(); ++i) {
                kid = (BIFileStore)array.get(i);
                if (!"license".equals(kid.getExtension())) continue;
                info = new LicenseInfo((BIFile)new BLicenseFile(kid));
                out.println("  " + info.toString(null));
            }
        }
        out.println();
        ConfigDetails.printlnLex(out, "certificates");
        dirStore = BDaemonDirectoryStore.make((BDaemonFileSpace)session.getFileSpace(), (FilePath)SystemFilePaths.getCertificatesDirPath((BIFileSpace)session.getFileSpace(), (boolean)hostIdStatus.isPerpetual(), (boolean)isNiagaraHomeReadonly), (boolean)true, (boolean)false, (boolean)false, null);
        if (dirStore != null) {
            Array array = dirStore.getChildren(BCacheAccessPolicy.lazyFetch);
            for (int i = 0; i < array.size(); ++i) {
                kid = (BIFileStore)array.get(i);
                if (!"certificate".equals(kid.getExtension())) continue;
                info = new CertificateInfo((BIFile)new BCertificateFile(kid));
                out.println("  " + info.toString(null));
            }
        }
    }

    public static String getDashes(String textToUnderline) {
        if (textToUnderline == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < textToUnderline.length(); ++i) {
            result.append('-');
        }
        return result.toString();
    }

    private static void printlnLex(PrintWriter out, String lexKeySuffix) {
        ConfigDetails.printlnLex(out, lexKeySuffix, false);
    }

    private static void printlnLex(PrintWriter out, String lexKeySuffix, boolean underline) {
        ConfigDetails.printLex(out, lexKeySuffix);
        out.println();
        if (underline) {
            out.println(ConfigDetails.getDashes(lex.getText("PlatformAdministration." + lexKeySuffix)));
        }
    }

    private static void printLex(PrintWriter out, String lexKeySuffix) {
        ConfigDetails.printLex(out, lexKeySuffix, new Object[0]);
    }

    private static void printlnLex(PrintWriter out, String lexKeySuffix, Object[] lexArgs, boolean underline) {
        ConfigDetails.printLex(out, lexKeySuffix, lexArgs);
        out.println();
        if (underline) {
            out.println(ConfigDetails.getDashes(lex.getText("PlatformAdministration." + lexKeySuffix, lexArgs)));
        }
    }

    private static void printLex(PrintWriter out, String lexKeySuffix, Object[] lexArgs) {
        out.print(lex.getText("PlatformAdministration." + lexKeySuffix, lexArgs));
    }
}

