/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv.comps;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.schedule.BIWebScheduler;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import javax.baja.agent.AgentList;
import javax.baja.naming.BISession;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

@NiagaraType
public abstract class BNiagaraVirtualSchedule
extends BNiagaraVirtualComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualSchedule.class);
    private static final Map<BComponentSpace, Boolean> SCHEDULE_VIEW_SUPPORT_CACHE = Collections.synchronizedMap(new WeakHashMap());
    private static final Version SUPPORTED_SCHEDULE_VIEW_VERSION = new Version("4.6");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        boolean supported = false;
        BComponentSpace space = this.getComponentSpace();
        if (space != null) {
            supported = SCHEDULE_VIEW_SUPPORT_CACHE.computeIfAbsent(space, key -> this.isScheduleViewSupported());
        }
        if (!supported) {
            list = list.filter(info -> !info.getAgentType().is(BIWebScheduler.TYPE));
        }
        return list;
    }

    private boolean isScheduleViewSupported() {
        boolean supported = false;
        if (Sys.getStation() == null) {
            BISession session = this.getSession();
            if (session != null && session instanceof BFoxSession) {
                BFoxSession foxSession = (BFoxSession)session;
                try {
                    supported = foxSession.rpc(this.getNavOrd(), "isScheduleViewSupported", new Object[0]).orElse(false);
                }
                catch (Exception err) {
                    this.getLog().log(Level.SEVERE, "Could not query schedule view support", err);
                }
            }
        } else {
            supported = this.isScheduleViewSupported(null);
        }
        return supported;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public boolean isScheduleViewSupported(Context cx) {
        return this.getNiagaraVirtualGateway().getStationAdapter().getStationVersion(SUPPORTED_SCHEDULE_VIEW_VERSION).compareTo(SUPPORTED_SCHEDULE_VIEW_VERSION) >= 0;
    }
}

