/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv.cache;

import com.tridium.data.BDataTable;
import com.tridium.nv.BNiagaraVirtualPolicies;
import com.tridium.nv.BSlotInfo;
import com.tridium.nv.BSlotType;
import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.nv.VirtualSlotNameParser;
import com.tridium.nv.cache.BNiagaraVirtualCachePolicy;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.virtual.VirtualPath;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="clear", flags=144), @NiagaraAction(name="removeFromCache", parameterType="BComponent", defaultValue="new BComponent()", flags=4), @NiagaraAction(name="getStationNames", returnType="BString", flags=4)})
public abstract class BNiagaraVirtualCache
extends BComponent {
    @Generated
    public static final Action clear = BNiagaraVirtualCache.newAction((int)144, null);
    @Generated
    public static final Action removeFromCache = BNiagaraVirtualCache.newAction((int)4, (BValue)new BComponent(), null);
    @Generated
    public static final Action getStationNames = BNiagaraVirtualCache.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualCache.class);
    private static final BIcon icon = BIcon.std((String)"database.png");

    @Generated
    public void clear() {
        this.invoke(clear, null, null);
    }

    @Generated
    public void removeFromCache(BComponent parameter) {
        this.invoke(removeFromCache, (BValue)parameter, null);
    }

    @Generated
    public BString getStationNames() {
        return (BString)this.invoke(getStationNames, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BIcon getIcon() {
        return icon;
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraVirtualCachePolicy;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == clear) {
            this.getVirtualPolicies().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    protected final BNiagaraVirtualPolicies getVirtualPolicies() {
        return ((BNiagaraVirtualCachePolicy)this.getParent()).getVirtualPolicies();
    }

    public final void doRemoveFromCache(BComponent data) throws Exception {
        BString stationName = (BString)data.get("stationName");
        BOrdList vOrdList = (BOrdList)data.get("vOrds");
        if (stationName == null || vOrdList == null) {
            throw new Exception("Invalid Remove From Cache Action Call!");
        }
        this.remove(stationName.getString(), vOrdList.toArray());
    }

    public final BString doGetStationNames() {
        return BString.make((String)TextUtil.join((String[])this.getVirtualPolicies().getStationNames(), (char)','));
    }

    public static final BITable<?> queryCacheInfo(OrdTarget target, BString stationName) {
        BNiagaraVirtualCache cache = (BNiagaraVirtualCache)target.get();
        CachedSlotInfo[] cachedInfos = cache.lookup(stationName.getString());
        BDataTable table = new BDataTable();
        table.addColumn("path", BString.TYPE, 0, BFacets.NULL);
        BSlotInfo sample = new BSlotInfo();
        SlotCursor cursor = sample.getProperties();
        while (cursor.next()) {
            Property prop = cursor.property();
            table.addColumn(prop.getName(), BString.TYPE, prop.getDefaultFlags(), prop.getFacets());
        }
        table.startRows();
        for (int i = 0; i < cachedInfos.length; ++i) {
            table.startRow();
            table.set(cachedInfos[i].vOrd.toString(), BFacets.NULL);
            SlotCursor iCursor = cachedInfos[i].info.getProperties();
            while (iCursor.next()) {
                BString val = iCursor.property() == BSlotInfo.slotFlags ? BString.make((String)Flags.toDisplayString((int)iCursor.getInt(), null)) : BString.make((String)iCursor.get().toString());
                table.set((BIDataValue)val, BFacets.NULL);
            }
            table.endRow();
        }
        return table;
    }

    public final BSlotInfo lookup(String stationName, BOrd vOrd) throws Exception {
        BSlotInfo info = this.doLookup(stationName, vOrd);
        if (info == null) {
            VirtualPath vPath = NiagaraVirtualUtil.toVirtualPath(vOrd);
            if (vPath == null) {
                throw new Exception("Invalid ORD. Could not decode for Virtual Cache Lookup!");
            }
            String virtualPathName = NiagaraVirtualUtil.getPathNameFromVirtualPath(vPath);
            try {
                VirtualSlotNameParser p = VirtualSlotNameParser.make(virtualPathName).parse();
                info = new BSlotInfo();
                info.setSlotName(p.getSlotName());
                info.setIsFrozen(p.isFrozen());
                info.setIsComponent(p.isComponent());
                if (!info.getIsComponent()) {
                    info.setIsWritable(p.getFacets().getb("nVirtualW", false));
                }
                info.setSlotType(p.isAction() ? BSlotType.action : BSlotType.property);
                info.setTypeSpec(p.getTypeSpec());
                info.setFacets(p.getFacets());
                info.setSlotFlags(info.getSlotFlags() | p.getFlags());
                info.setReturnTypeSpec(p.getReturnTypeSpec());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return info;
    }

    public abstract BSlotInfo doLookup(String var1, BOrd var2) throws Exception;

    protected abstract CachedSlotInfo[] lookup(String var1);

    public abstract void update(String var1, BOrd var2, BSlotInfo var3);

    public abstract void remove(String var1, BOrd[] var2);

    public abstract void doClear() throws Exception;

    protected static final class CachedSlotInfo {
        BOrd vOrd;
        BSlotInfo info;

        protected CachedSlotInfo(BOrd vOrd, BSlotInfo info) {
            this.vOrd = vOrd;
            this.info = info;
        }
    }
}

