/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nv;

import com.tridium.nv.BINiagaraVirtualPropertySubstitute;
import com.tridium.nv.BNiagaraVirtualComponent;
import com.tridium.nv.BNiagaraVirtualComponentInfo;
import com.tridium.nv.INiagaraVirtualStationAdapter;
import com.tridium.nv.point.BSubscriptionState;
import com.tridium.nv.point.BVirtualAction;
import com.tridium.nv.point.INiagaraProxyExt;
import com.tridium.nv.point.NiagaraProxyExtSupport;
import java.util.logging.Logger;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusString;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

final class NiagaraVirtualPropertyHandler
implements INiagaraProxyExt {
    private BNiagaraVirtualComponent virtualComp;
    private Property prop;
    private String name;
    private INiagaraVirtualStationAdapter stationAdapter;
    private BStatus readStatus = BStatus.stale;
    private BStatus writeStatus = BStatus.ok;
    private final int messageId = NiagaraProxyExtSupport.newMessageId();
    private volatile BSubscriptionState subscriptionState = BSubscriptionState.unsubscribed;
    private volatile String subscriptionError;
    private volatile boolean fetchActions;
    private String subscriptionStatus = "";
    private long readTicks = 0L;
    private long writeTicks = 0L;
    static final Context readUpdateContext = new BasicContext();

    private NiagaraVirtualPropertyHandler() {
    }

    public static NiagaraVirtualPropertyHandler make(INiagaraVirtualStationAdapter stationAdapter, BNiagaraVirtualComponent virtualComp, Property prop) throws Exception {
        NiagaraVirtualPropertyHandler h = new NiagaraVirtualPropertyHandler();
        h.stationAdapter = stationAdapter;
        h.virtualComp = virtualComp;
        h.prop = prop;
        h.name = virtualComp.getSlotFacets((Slot)prop).gets("nVirtualSN", prop.getName());
        h.stationAdapter.registerProxyExt(h);
        return h;
    }

    public void subscribed() {
        NiagaraProxyExtSupport.subscribed(this);
    }

    public void unsubscribed() {
        NiagaraProxyExtSupport.unsubscribed(this);
    }

    public void stop() {
        this.stationAdapter.unregisterProxyExt(this);
    }

    public void close() {
        NiagaraProxyExtSupport.close(this);
    }

    @Override
    public String getPointId() {
        return this.virtualComp.getNiagaraVirtualCompInfo().formSlotOrd(this.name).toString();
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public String getPointType() {
        if (this.prop.getType().equals(BStatusString.TYPE)) {
            return "s";
        }
        return "v";
    }

    @Override
    public boolean isActionFetchRequired() {
        return this.fetchActions;
    }

    @Override
    public void updateActions(BVirtualAction[] actions) {
        this.fetchActions = false;
        this.virtualComp.updateActions(actions);
    }

    @Override
    public Object getStateLock() {
        return this.stationAdapter.getStateLock();
    }

    @Override
    public String getStationName() {
        return this.stationAdapter.getStationName();
    }

    @Override
    public BSubscriptionState getSubscriptionState() {
        return this.subscriptionState;
    }

    @Override
    public void setSubscriptionState(BSubscriptionState subscriptionState) {
        this.subscriptionState = subscriptionState;
    }

    @Override
    public boolean isPointSubscribed() {
        return this.virtualComp.isSubscribed();
    }

    @Override
    public void setProxySubscriptionStatus(String subscriptionStatus) {
        this.subscriptionStatus = subscriptionStatus;
    }

    @Override
    public final String getSubscriptionError() {
        return this.subscriptionError;
    }

    @Override
    public void setSubscriptionError(String error) {
        NiagaraProxyExtSupport.setSubscriptionError(this, error);
    }

    @Override
    public void commitSubscriptionError(String error) {
        this.subscriptionError = error;
    }

    @Override
    public void sendingSubscribe() {
        NiagaraProxyExtSupport.sendingSubscribe(this);
    }

    @Override
    public void sentSubscribe() {
        NiagaraProxyExtSupport.sentSubscribe(this);
    }

    @Override
    public void sendingUnsubscribe() {
        NiagaraProxyExtSupport.sendingUnsubscribe(this);
    }

    @Override
    public void sentUnsubscribe() {
        NiagaraProxyExtSupport.sentUnsubscribe(this);
    }

    @Override
    public void pendingSubscribe() {
        NiagaraProxyExtSupport.pendingSubscribe(this);
        this.readStatus = BStatus.makeStale((BStatus)this.readStatus, (boolean)true);
        this.virtualComp.niagaraVirtualCompUpdateStatus();
    }

    @Override
    public void readFail(String cause) {
        this.readStatus = BStatus.fault;
        this.virtualComp.getNiagaraVirtualCompInfo().setLastFailureCause(cause);
        this.virtualComp.niagaraVirtualCompUpdateStatus();
    }

    @Override
    public void readValueOk(BValue newValue) {
        if (this.prop == BNiagaraVirtualComponent.niagaraVirtualCompInfo) {
            this.virtualComp.readOkMappedVirtualInfo((BNiagaraVirtualComponentInfo)newValue);
        } else if (this.prop.getType().is(BINiagaraVirtualPropertySubstitute.TYPE)) {
            BINiagaraVirtualPropertySubstitute sub = (BINiagaraVirtualPropertySubstitute)this.virtualComp.get(this.prop);
            sub.nvRead(this.virtualComp, newValue, readUpdateContext);
        } else {
            this.virtualComp.set(this.prop, newValue, readUpdateContext);
        }
        this.readStatus = BStatus.ok;
        this.virtualComp.niagaraVirtualCompUpdateStatus();
        this.readTicks = Clock.ticks();
    }

    public void writeFail(String cause) {
        this.writeStatus = BStatus.fault;
        this.virtualComp.getNiagaraVirtualCompInfo().setLastFailureCause(cause);
        this.virtualComp.niagaraVirtualCompUpdateStatus();
    }

    public void writeOk() {
        this.writeStatus = BStatus.ok;
        this.virtualComp.niagaraVirtualCompUpdateStatus();
        this.writeTicks = Clock.ticks();
    }

    @Override
    public Logger getLog() {
        return this.virtualComp.getLog();
    }

    Property getProperty() {
        return this.prop;
    }

    String getName() {
        return this.name;
    }

    String getSubscriptionStatus() {
        return this.subscriptionStatus;
    }

    BStatus getReadStatus() {
        return this.readStatus;
    }

    BStatus getWriteStatus() {
        return this.writeStatus;
    }

    BStatus getOverallStatus() {
        return BStatus.make((int)(this.readStatus.getBits() | this.writeStatus.getBits()));
    }

    long getLastReadTicks() {
        return this.readTicks;
    }

    long getLastWriteTicks() {
        return this.writeTicks;
    }

    void fetchActionsForComponent() {
        this.fetchActions = true;
    }

    @Override
    public final String tagsToFetch() {
        return this.virtualComp.getNiagaraVirtualGateway().tagsToFetch();
    }

    @Override
    public final boolean persistFetchedTags() {
        return this.virtualComp.getNiagaraVirtualGateway().persistFetchedTags();
    }

    @Override
    public final BComponent getProxyComponentToTag() {
        return this.virtualComp;
    }

    @Override
    public String getComponentId() {
        return this.virtualComp.getNiagaraVirtualCompInfo().getSlotOrd().toString();
    }
}

