/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.util;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.xprotect.BMilestoneXProtectNetwork;
import com.tridium.xprotect.soap.IMIPService;
import com.tridium.xprotect.soap.MIPService;
import com.tridium.xprotect.util.ClientSideNativeLibraryLoader;
import com.tridium.xprotect.util.MIPServiceClient;
import com.tridium.xprotect.util.XProtectVideoStreamUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class WebProcessUtil
extends ClientSideNativeLibraryLoader {
    private static Logger logger = Logger.getLogger(WebProcessUtil.class.getName());
    private static Process webProcess = null;
    private static volatile boolean webProcessStarted = false;
    private static KeepAliveMonitor webProcessKeepAlive = null;
    private static String webProcessFault = null;
    private static int webProcessPort = -1;
    private static String appGuid = "";
    private static String sessionId = "";
    private static volatile IMIPService mipService = null;
    private static final Object syncLock = new Object();
    private static final String NAME_WS_EXE = ClientSideNativeLibraryLoader.niagaraHomeBinStr + File.separator + "XProtectBridgeService.exe";
    private static final String URL_PREFIX = "running: ";
    private static final String APP_GUID_PREFIX = "APP_GUID:";
    private static final String VERSION_PREFIX = ".dll:";
    private static final double MIN_DLL_VERSION = 13.0;
    private static final SecureRandom secureRandom = new SecureRandom();

    public static int getWebProcessPort() {
        return webProcessPort;
    }

    public static String getAppGuid() {
        return appGuid;
    }

    public static String getSessionId() {
        return sessionId;
    }

    private static String generateSessionId() {
        byte[] newKeyMaterial = new byte[32];
        secureRandom.nextBytes(newKeyMaterial);
        String encodedKey = Base64.getEncoder().encodeToString(newKeyMaterial);
        return encodedKey;
    }

    public static String getWebProcessFault() {
        if (webProcessFault == null) {
            return "Unknown native process error.";
        }
        return webProcessFault;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMIPService getService(boolean useTls) {
        if (!webProcessStarted) {
            throw new IllegalStateException("Native process not running.");
        }
        if (webProcessPort == -1) {
            throw new IllegalStateException("Native process exception.");
        }
        IMIPService localCopyMipService = mipService;
        if (localCopyMipService == null) {
            Object object = syncLock;
            synchronized (object) {
                localCopyMipService = mipService;
                if (localCopyMipService == null) {
                    try {
                        URL url = null;
                        url = useTls ? new URL("https://127.0.0.1:" + webProcessPort + "/?wsdl") : new URL("http://127.0.0.1:" + webProcessPort + "/?wsdl");
                        URL finalUrl = url;
                        MIPService mipImpl = AccessController.doPrivileged(() -> new MIPServiceClient(finalUrl));
                        mipService = localCopyMipService = AccessController.doPrivileged(() -> mipImpl.getBasicHttpBindingIMIPService());
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return localCopyMipService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void startWebProcess(int nativeProcessPort, boolean useTls) {
        Object object = syncLock;
        synchronized (object) {
            block41: {
                if (!OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.windows)) {
                    throw new UnsupportedOperationException("XProtect web process only available in Windows Operating System");
                }
                if (webProcessStarted) {
                    return;
                }
                webProcessStarted = true;
                try {
                    AccessController.doPrivileged(() -> {
                        try {
                            sessionId = WebProcessUtil.generateSessionId();
                            webProcessPort = -1;
                            ProcessBuilder processBuilder = new ProcessBuilder(NAME_WS_EXE);
                            Map<String, String> processEnvironment = processBuilder.environment();
                            processEnvironment.put("XPBS_WEB_PORT", String.valueOf(nativeProcessPort));
                            processEnvironment.put("XPBS_USE_TLS", String.valueOf(useTls));
                            processEnvironment.put("XPBS_AUTH_KEY", String.valueOf(sessionId));
                            webProcess = processBuilder.start();
                        }
                        catch (Exception e) {
                            log.log(Level.SEVERE, "Exception occurred while running native executable: " + NAME_WS_EXE, e);
                        }
                        return Boolean.TRUE;
                    });
                }
                catch (Exception e) {
                    if (e.getMessage().contains("CreateProcess error=2")) {
                        webProcessFault = "Unable to find native executable: " + NAME_WS_EXE;
                        log.log(Level.SEVERE, "Unable to find native executable: " + NAME_WS_EXE, e);
                    }
                    webProcessFault = "Exception on process exec: " + e.getMessage();
                    log.log(Level.SEVERE, "Exception on process exec: " + e.getMessage(), e);
                }
                try (BufferedReader input = new BufferedReader(new InputStreamReader(webProcess.getInputStream()));){
                    Throwable throwable;
                    BufferedReader errInput;
                    block40: {
                        errInput = new BufferedReader(new InputStreamReader(webProcess.getErrorStream()));
                        throwable = null;
                        try {
                            WebProcessUtil.readPort(input);
                            if (webProcessPort != -1) {
                                log.info("Started " + NAME_WS_EXE + " (useTls=" + useTls + ") on port " + webProcessPort);
                                webProcessKeepAlive = new KeepAliveMonitor();
                                Thread thread = new Thread((Runnable)webProcessKeepAlive, "XProtect:KeepAliveMonitor");
                                thread.setDaemon(true);
                                thread.start();
                                break block40;
                            }
                            WebProcessUtil.onWebProcessError(errInput);
                            break block41;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    return;
                    finally {
                        if (errInput != null) {
                            if (throwable != null) {
                                try {
                                    errInput.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                errInput.close();
                            }
                        }
                    }
                }
                catch (IOException exception) {
                    log.log(Level.SEVERE, "Exception on process stream handling: " + exception.getMessage());
                }
            }
            webProcess = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endWebProcess() {
        Object object = syncLock;
        synchronized (object) {
            mipService = null;
            webProcessStarted = false;
            if (webProcessKeepAlive != null) {
                webProcessKeepAlive.stop();
            }
            webProcessKeepAlive = null;
            if (webProcess == null) {
                return;
            }
            try (OutputStream out2 = webProcess.getOutputStream();){
                out2.write(new byte[]{10});
                out2.flush();
            }
            catch (IOException out2) {
                // empty catch block
            }
            TimeoutMonitor monitor = new TimeoutMonitor(2000L, Thread.currentThread());
            Thread thread = new Thread((Runnable)monitor, "XProtect:TimeoutMonitor");
            thread.setDaemon(true);
            thread.start();
            try {
                webProcess.waitFor();
                monitor.stop();
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Interrupted while waiting for WebProcess to close", e);
                XProtectVideoStreamUtil.interruptCurrentThread();
                webProcess.destroy();
            }
            webProcess = null;
        }
    }

    private static void readPort(BufferedReader input) {
        try {
            String line;
            while ((line = input.readLine()) != null) {
                String versionStr;
                double version;
                if (Level.FINE.equals(log.getLevel())) {
                    log.fine("Read bridge service input line: " + line);
                }
                if (line.indexOf(URL_PREFIX) == 0) {
                    URL url = new URL(line.substring(URL_PREFIX.length()));
                    webProcessPort = url.getPort();
                    return;
                }
                if (line.indexOf(APP_GUID_PREFIX) == 0) {
                    appGuid = line.substring(APP_GUID_PREFIX.length());
                    continue;
                }
                if (line.indexOf(VERSION_PREFIX) == -1 || !((version = Double.parseDouble((versionStr = line.substring(line.indexOf(VERSION_PREFIX) + VERSION_PREFIX.length() + 1)).substring(0, versionStr.indexOf(46, 2)))) < 13.0)) continue;
                throw new Exception("Invalid dll version (< 13.0): " + line);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception occurred reading port information", e);
            webProcessFault = "IOException starting native executable: " + e.getMessage();
        }
    }

    private static String readLineIgnoreException(BufferedReader reader) {
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static void onWebProcessError(BufferedReader errInput) {
        WebProcessUtil.endWebProcess();
        String errorType = WebProcessUtil.readLineIgnoreException(errInput);
        String errorMessage = WebProcessUtil.getErrorMessage(errorType);
        String appErrorMsg = WebProcessUtil.readLineIgnoreException(errInput);
        webProcessFault = errorMessage + " [" + errorType + ": " + appErrorMsg + "]";
        log.severe("Received fatal response from web process '" + appErrorMsg + "'");
    }

    private static String getErrorMessage(String errorType) {
        if (errorType == null || errorType.length() == 0) {
            return "Unknown process exception";
        }
        if (errorType.contains("FileNotFoundException")) {
            return "Unable to load VideoOS DLL's";
        }
        if (errorType.contains("AddressAlreadyInUseException")) {
            return "TCP port already in use";
        }
        if (errorType.contains("SocketException")) {
            return "Failed connect TCP port";
        }
        if (errorType.contains("UriFormatException")) {
            return "Invalid TCP port";
        }
        if (errorType.contains("AddressAccessDeniedException")) {
            return "Insufficient privileges to open TCP port.";
        }
        return "Unhandled process exception: " + errorType;
    }

    static {
        sessionId = WebProcessUtil.generateSessionId();
    }

    static class KeepAliveMonitor
    implements Runnable {
        private volatile boolean processStopped = false;
        private Thread runThread;

        KeepAliveMonitor() {
        }

        @Override
        public void run() {
            this.runThread = Thread.currentThread();
            try {
                webProcess.waitFor();
            }
            catch (InterruptedException e) {
                if (!this.processStopped) {
                    logger.log(Level.WARNING, "Interrupted while waiting for KeepAliveMonitor but not for process stop", e);
                }
                XProtectVideoStreamUtil.interruptCurrentThread();
                return;
            }
            if (!webProcessStarted || this.processStopped) {
                return;
            }
            logger.log(Level.WARNING, "Restarting native process: " + NAME_WS_EXE);
            BComponent[] components = Sys.getServices((Type)BMilestoneXProtectNetwork.TYPE);
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof BMilestoneXProtectNetwork)) continue;
                BMilestoneXProtectNetwork network = (BMilestoneXProtectNetwork)components[i];
                network.restartNativeProcess();
            }
        }

        public void stop() {
            this.processStopped = true;
            if (this.runThread != null) {
                this.runThread.interrupt();
            }
        }
    }

    static class TimeoutMonitor
    implements Runnable {
        private volatile boolean processStopped = false;
        private final long timeout;
        private final Thread callingThread;
        private Thread runThread;

        public TimeoutMonitor(long timeout, Thread callingThread) {
            this.timeout = timeout;
            this.callingThread = callingThread;
        }

        @Override
        public void run() {
            this.runThread = Thread.currentThread();
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                if (!this.processStopped) {
                    logger.log(Level.WARNING, "Interrupted while sleeping on TimeOutMonitor but not for process stop", e);
                }
                XProtectVideoStreamUtil.interruptCurrentThread();
                return;
            }
            this.callingThread.interrupt();
        }

        public void stop() {
            this.processStopped = true;
            if (this.runThread != null) {
                this.runThread.interrupt();
            }
        }
    }
}

