/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.xprotect.camera;

import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryGroup;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.nvideo.camera.BCameraDeviceExt;
import com.tridium.xprotect.camera.BXProtectCameraDeviceId;
import com.tridium.xprotect.camera.BXProtectCameraDiscoveryLeaf;
import com.tridium.xprotect.camera.BXProtectCameraDiscoveryPreferences;
import com.tridium.xprotect.datatypes.BXProtectItemHierarchy;
import com.tridium.xprotect.server.management.BXProtectManagementConnection;
import com.tridium.xprotect.server.management.BXProtectManagementServer;
import com.tridium.xprotect.server.recording.BXProtectRecordingServerId;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NiagaraType
@NiagaraProperty(name="discoveryPreferences", type="BNDiscoveryPreferences", defaultValue="new BXProtectCameraDiscoveryPreferences()", override=true)
public class BXProtectCameraDeviceExt
extends BCameraDeviceExt {
    @Generated
    public static final Property discoveryPreferences = BXProtectCameraDeviceExt.newProperty((int)0, (BValue)new BXProtectCameraDiscoveryPreferences(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BXProtectCameraDeviceExt.class);
    XPathFactory xPathfactory = XPathFactory.newInstance();
    XPath xpath = this.xPathfactory.newXPath();
    static final String KIND_CAMERA = "5135ba21-f1dc-4321-806a-6ce2017343c0";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences prefs) throws Exception {
        BXProtectCameraDiscoveryPreferences xPrefs = (BXProtectCameraDiscoveryPreferences)prefs;
        Array discoveredCameras = new Array(BXProtectCameraDiscoveryLeaf.class);
        BXProtectManagementServer dvr = (BXProtectManagementServer)this.getParent();
        BXProtectManagementConnection conn = dvr.getConnection();
        try {
            conn.tryConnectSync();
            Element root = conn.getCameras(xPrefs.getHierarchy().equals((Object)BXProtectItemHierarchy.userDefined));
            if (xPrefs.getHierarchy().equals((Object)BXProtectItemHierarchy.flatList)) {
                return this.getCameraList(root);
            }
            if (xPrefs.getHierarchy().equals((Object)BXProtectItemHierarchy.userDefined)) {
                return this.getCameraGroups(this.getChildItems(root)[0]);
            }
            return this.getCameraGroups(root);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BajaRuntimeException("Unable to discover cameras in " + dvr.getDisplayName(null), (Throwable)e);
        }
    }

    private BINDiscoveryObject[] getCameraList(Element root) throws Exception {
        XPathExpression expr = this.xpath.compile("Item/parent::node()//FQID[Kind/text()='5135ba21-f1dc-4321-806a-6ce2017343c0'][FolderType/text()='0']/parent::node()");
        NodeList set = (NodeList)expr.evaluate(root, XPathConstants.NODESET);
        Array discovered = new Array(BINDiscoveryObject.class);
        for (int i = 0; i < set.getLength(); ++i) {
            Node node = set.item(i);
            if (!(node instanceof Element)) continue;
            discovered.add((Object)this.makeCamera((Element)node));
        }
        return (BINDiscoveryObject[])discovered.trim();
    }

    private BINDiscoveryObject[] getCameraGroups(Element root) throws XPathExpressionException {
        BXProtectCameraDeviceExt.dumpXml(root);
        Array array = new Array(BINDiscoveryObject.class);
        Element[] children = this.getChildItems(root);
        for (int i = 0; i < children.length; ++i) {
            array.add((Object)this.processElement(children[i]));
        }
        return (BINDiscoveryObject[])array.trim();
    }

    private BINDiscoveryObject processElement(Element element) throws XPathExpressionException {
        Node folderType = (Node)this.xpath.compile("FQID/FolderType").evaluate(element, XPathConstants.NODE);
        if (folderType == null || folderType.getTextContent().equals("0")) {
            return this.makeCamera(element);
        }
        BNDiscoveryGroup group = new BNDiscoveryGroup();
        String name = this.xpath.compile("Name/text()").evaluate(element);
        group.setDescription(name);
        Element[] children = this.getChildItems(element);
        for (int i = 0; i < children.length; ++i) {
            group.add(null, (BValue)((BComplex)this.processElement(children[i])));
        }
        return group;
    }

    private BINDiscoveryObject makeCamera(Element camera) throws XPathExpressionException {
        String name = this.xpath.compile("Name/text()").evaluate(camera);
        String serverType = this.xpath.compile("FQID/ServerId/Type/text()").evaluate(camera);
        String serverHost = this.xpath.compile("FQID/ServerId/Hostname/text()").evaluate(camera);
        Double serverPort = (Double)this.xpath.compile("number(FQID/ServerId/Port/text())").evaluate(camera, XPathConstants.NUMBER);
        String serverIdId = this.xpath.compile("FQID/ServerId/Id/text()").evaluate(camera);
        BXProtectRecordingServerId serverId = BXProtectRecordingServerId.make(serverType, serverHost, serverPort.intValue(), serverIdId);
        String cameraId = this.xpath.compile("FQID/ObjectId/text()").evaluate(camera);
        BXProtectCameraDeviceId deviceId = new BXProtectCameraDeviceId();
        deviceId.setServerId(serverId);
        deviceId.setCameraId(cameraId);
        deviceId.setDescription(name);
        BXProtectCameraDiscoveryLeaf leaf = new BXProtectCameraDiscoveryLeaf();
        leaf.setId(deviceId);
        leaf.setDiscoveryName(name);
        return leaf;
    }

    private Element[] getChildItems(Element parent) {
        NodeList list = parent.getChildNodes();
        if (list.getLength() == 0) {
            return new Element[0];
        }
        Array array = new Array(Element.class);
        for (int i = 0; i < list.getLength(); ++i) {
            Element element;
            Node node = list.item(i);
            if (!(node instanceof Element) || !(element = (Element)node).getTagName().equals("Item")) continue;
            array.add((Object)element);
        }
        return (Element[])array.trim();
    }

    private static void dumpXml(Element cameras) {
        try {
            Transformer xfr = TransformerFactory.newInstance().newTransformer();
            xfr.setOutputProperty("omit-xml-declaration", "yes");
            xfr.setOutputProperty("indent", "yes");
            xfr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            xfr.transform(new DOMSource(cameras), new StreamResult(System.out));
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

