/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.webChart;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.nre.util.Version;
import com.tridium.web.RestUtil;
import com.tridium.web.WebUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.regex.Pattern;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.sys.Context;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class WebChartFileServlet
extends HttpServlet {
    private static final boolean indentChartContent = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.webChart.indentChartFile"));
    private static final Pattern chartNameFilter = Pattern.compile("[|]|([.][.])");
    private static final Version version = new Version("1");

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String content;
        String chartPath;
        Context cx;
        block20: {
            cx = (Context)req.getAttribute("niagara.context");
            if (!BFileSystem.INSTANCE.getPermissions(cx).hasOperatorWrite()) {
                resp.sendError(403);
                return;
            }
            RestUtil util = new RestUtil(req, resp);
            chartPath = this.getChartPath("save", util, resp);
            if (chartPath.length() == 0) {
                return;
            }
            chartPath = "^" + chartPath;
            content = null;
            if (chartPath.endsWith(".chart")) {
                try (BufferedReader reader = req.getReader();){
                    JSONObject chartJson = new JSONObject(new JSONTokener((Reader)reader));
                    content = indentChartContent ? chartJson.toString(2) : chartJson.toString();
                    break block20;
                }
                catch (Throwable e) {
                    resp.sendError(403);
                    return;
                }
            }
            if (!chartPath.endsWith(".csv")) {
                resp.sendError(406);
                return;
            }
        }
        String finalChartPath = chartPath;
        String finalContent = content;
        try {
            AccessController.doPrivileged(() -> {
                FilePath path = new FilePath(finalChartPath);
                boolean replace = false;
                BIFile file = BFileSystem.INSTANCE.findFile(path);
                if (file != null) {
                    if (!BFileSystem.INSTANCE.getPermissionsFor(path, cx).hasOperatorWrite()) {
                        resp.sendError(403);
                        return null;
                    }
                    replace = true;
                }
                OutputStream outputStream = null;
                if (replace) {
                    outputStream = BFileSystem.INSTANCE.findFile(path).getOutputStream();
                } else {
                    BIFile newFile = BFileSystem.INSTANCE.makeFile(path, cx);
                    outputStream = newFile.getOutputStream();
                }
                if (finalContent != null) {
                    try {
                        outputStream.write(finalContent.getBytes("UTF-8"));
                        outputStream.flush();
                    }
                    catch (IOException e) {
                        resp.sendError(400);
                    }
                    finally {
                        WebUtil.closeOutputStream((OutputStream)outputStream);
                    }
                } else {
                    ServletInputStream inputStream = req.getInputStream();
                    try {
                        BajaFileUtil.pipe((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    catch (Throwable e) {
                        resp.sendError(403);
                        Void void_ = null;
                        return void_;
                    }
                    finally {
                        WebUtil.closeOutputStream((OutputStream)outputStream);
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            WebUtil.handleServletPrivilegedException((PrivilegedActionException)e);
        }
    }

    private String getChartPath(String cmd, RestUtil util, HttpServletResponse resp) throws ServletException, IOException {
        if (!util.acceptJson()) {
            resp.sendError(406);
            return "";
        }
        RestUtil.Accept accept = util.getJsonAccept();
        if (!(!accept.isCustomMediaType() || accept.getCustomProtocol().equals("webChart") && accept.getCustomVersion().equals((Object)version))) {
            resp.sendError(406);
            return "";
        }
        if (!util.has(0, cmd) || !util.has(1)) {
            resp.sendError(404);
            return "";
        }
        String chartPath = util.getPathInfo().substring(cmd.length() + 2);
        if (chartNameFilter.matcher(chartPath).find()) {
            resp.sendError(403);
            chartPath = "";
        }
        return chartPath;
    }
}

