/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.basicdriver.point;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.util.BBasicPollGroup;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.basicdriver.util.BasicWriteAsyncRequest;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public abstract class BBasicProxyExt
extends BProxyExt {
    @Generated
    public static final Type TYPE = Sys.loadType(BBasicProxyExt.class);
    private static Lexicon lex = Lexicon.make(BBasicProxyExt.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Object getPollGroupCode() {
        return null;
    }

    public Type getPollGroupType() {
        return null;
    }

    public void readSubscribed(Context cx) throws Exception {
        if (this instanceof BIBasicPollable) {
            BBasicNetwork network = (BBasicNetwork)this.getNetwork();
            if (network != null) {
                network.getPollScheduler().subscribe((BIPollable)((BIBasicPollable)((Object)this)));
                if (network.getLog().isTraceOn()) {
                    network.getLog().trace("Sub <" + (Object)((Object)this) + ">");
                }
            }
        } else if (this.getPollGroupCode() != null) {
            BBasicPollGroup pg = BBasicPollGroup.getPollGroup(this);
            pg.readSubscribed(this);
        }
    }

    public void readUnsubscribed(Context cx) throws Exception {
        if (this instanceof BIBasicPollable) {
            BBasicNetwork network = (BBasicNetwork)this.getNetwork();
            if (network != null) {
                network.getPollScheduler().unsubscribe((BIPollable)((BIBasicPollable)((Object)this)));
                if (network.getLog().isTraceOn()) {
                    network.getLog().trace("Unsub <" + (Object)((Object)this) + ">");
                }
            }
        } else if (this.getPollGroupCode() != null) {
            BBasicPollGroup pg = BBasicPollGroup.getPollGroup(this);
            pg.readUnsubscribed(this);
        }
    }

    public void started() throws Exception {
        if (this.getPollGroupCode() != null) {
            BBasicPollGroup.getPollGroup(this).registerProxy(this);
        }
        super.started();
    }

    public void stopped() throws Exception {
        this.readUnsubscribed(null);
        if (this.getPollGroupCode() != null) {
            BBasicPollGroup.getPollGroup(this).unregisterProxy(this);
        }
        super.stopped();
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    protected boolean logWriteFail() {
        return true;
    }

    public void writeFail(String cause) {
        if (this.logWriteFail()) {
            this.getNetwork().getLog().error(this.getSlotPath().toDisplayString() + ' ' + this.getParentPoint().getOutStatusValue() + " to " + this.getWriteValue() + ' ' + cause);
        }
        super.writeFail(cause);
    }

    public boolean write(Context cx) throws Exception {
        if (this.getMode() != BReadWriteMode.readonly) {
            BStatusValue out = this.getWriteValue();
            if (out.getStatus().isNull()) {
                return false;
            }
            BBasicNetwork network = (BBasicNetwork)this.getNetwork();
            if (network.getLog().isTraceOn()) {
                network.getLog().trace("Write <" + (Object)((Object)this) + "> " + out);
            }
            try {
                network.postWrite(new BasicWriteAsyncRequest(this, out));
            }
            catch (Exception e) {
                this.writeFail(lex.getText("postWriteFail") + ": " + e);
                network.getLog().error("Could not post write for " + this.getParent().getName(), (Throwable)e);
            }
        }
        return false;
    }

    public void doWrite(BStatusValue out) {
    }
}

