/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.util.metrics.messages;

import com.tridium.bacnet.stack.network.NetworkPdu;
import com.tridium.bacnet.stack.network.wiretap.OutgoingWiretap;
import com.tridium.bacnet.stack.network.wiretap.WiretapAware;
import com.tridium.bacnet.util.point.BPeriodicNumericPoint;
import com.tridium.bacnet.util.point.EventsPerSecond;
import java.util.concurrent.atomic.LongAdder;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.makeNumeric(BUnit.getUnit(\"per second\"), 1)", override=true)
public class BSentMessages
extends BPeriodicNumericPoint
implements OutgoingWiretap,
EventsPerSecond {
    @Generated
    public static final Property facets = BSentMessages.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)BUnit.getUnit((String)"per second"), (int)1), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSentMessages.class);
    private LongAdder sent = new LongAdder();
    private long lastUpdate = System.currentTimeMillis();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof WiretapAware;
    }

    public void onExecute(BStatusValue o, Context cx) {
        long t1 = this.lastUpdate;
        this.lastUpdate = System.currentTimeMillis();
        long messagesReceived = this.sent.longValue();
        this.sent.reset();
        BStatusNumeric out = (BStatusNumeric)o;
        out.setValue(this.calculateEventsPerSecond(messagesReceived, t1, this.lastUpdate));
    }

    public void sendRequest(byte[] destAddress, NetworkPdu npdu) {
        this.sent.increment();
    }

    public long getSentMessages() {
        return this.sent.longValue();
    }
}

