/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.vacm;

import com.tridium.nSnmp.messages.SnmpV3AlarmTrap;
import com.tridium.nSnmp.version3.dto.SnmpV3Message;
import com.tridium.nSnmp.version3.vacm.ViewType;

public class VacmException
extends Exception {
    private static String[] errorMessages = new String[]{"VacmException: Could not find a group name corresponding to the Security Name: %s and Security Model: %d in the vacm security table", "VacmException: Could not find the context name %d in the VACM Context table", "VacmException: Could not find an Access entry in the VACM Access Table for Security Name: %s, Security Model: %d, Security Level: %d, ContextName: %s", "VacmException: Could not find the view in the VACM Access Entry for the view type %s", "VacmException: Could not find a Mib View for the View Name: %s", "VacmException: Could not find the variable name: %s in the Mib View and hence access cannot be granted."};
    private int errorCode = -1;
    private String securityName;
    private int securityModel;
    private int securityLevel;
    private String contextName;
    private String groupName;
    private ViewType viewType;
    private String viewName;
    private String variableName;

    public VacmException(SnmpV3AlarmTrap message, String variableName) {
        this.securityName = message.getUserSecurityName();
        this.securityModel = message.getMsgSecurityModel();
        this.contextName = message.getContextName();
        this.securityLevel = message.getSecurityLevel();
        this.variableName = variableName;
    }

    public VacmException(SnmpV3Message message, String variableName) {
        this.securityName = message.getUserSecurityName();
        this.securityModel = message.getMsgSecurityModel();
        this.contextName = message.getContextName();
        this.securityLevel = message.getSecurityLevel();
        this.variableName = variableName;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public void setSecurityName(String securityName) {
        this.securityName = securityName;
    }

    public int getSecurityModel() {
        return this.securityModel;
    }

    public void setSecurityModel(int securityModel) {
        this.securityModel = securityModel;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public void setViewType(ViewType viewType) {
        this.viewType = viewType;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    @Override
    public String getMessage() {
        String errorMessage = null;
        if (this.errorCode - 102 >= 0) {
            errorMessage = errorMessages[this.errorCode - 102];
            switch (this.errorCode) {
                case 102: {
                    errorMessage = String.format(errorMessage, this.securityName, this.securityModel);
                    break;
                }
                case 103: {
                    errorMessage = String.format(errorMessage, this.contextName);
                    break;
                }
                case 104: {
                    errorMessage = String.format(errorMessage, this.securityName, this.securityModel, this.securityLevel, this.contextName);
                    break;
                }
                case 105: {
                    errorMessage = String.format(errorMessage, new Object[]{this.viewType});
                    break;
                }
                case 106: {
                    errorMessage = String.format(errorMessage, this.viewName);
                    break;
                }
                case 107: {
                    errorMessage = String.format(errorMessage, this.variableName);
                }
            }
        }
        return super.getMessage() + "\n" + errorMessage;
    }
}

