/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.messageProcessingModel;

import com.tridium.nSnmp.version3.dto.SnmpMessageProcessingModelOutput;
import com.tridium.nSnmp.version3.dto.SnmpV3Message;
import com.tridium.nSnmp.version3.messageProcessingModel.SnmpMessageProcessingModel;
import com.tridium.nSnmp.version3.securityModel.SnmpUserSecurityModel;
import com.tridium.nSnmp.version3.securityModel.usm.USMException;
import com.tridium.nSnmp.version3.securityModel.usm.UsmSecurity;
import com.tridium.nSnmp.version3.securityModel.usmUser.BUsmUser;
import com.tridium.nSnmp.version3.securityModel.usmUser.BUsmUserTable;
import com.tridium.ndriver.datatypes.BIpAddress;
import java.security.SecureRandom;
import java.util.logging.Logger;

public class SnmpMessageProcessingModel_V3
implements SnmpMessageProcessingModel {
    public static final int SNMP_VERSION = 3;
    private static final int MPv3_REPORTABLE_FLAG = 4;
    public static final int MAX_MESSAGE_ID = Integer.MAX_VALUE;
    private static final int USM_SECURITY_MODEL = 3;
    private int currentMsgID = new SecureRandom().nextInt(Integer.MAX_VALUE);
    UsmSecurity usmSecurity = UsmSecurity.getUsmSecurityInstance();
    private static final Logger logger = Logger.getLogger("snmp.agent");

    @Override
    public SnmpV3Message prepareOutgoingMessage(SnmpV3Message outgoingMessage) throws USMException {
        int msgFlag = -1;
        String userSecurityName = outgoingMessage.getUserSecurityName();
        if (userSecurityName == null || userSecurityName.equals("")) {
            throw new RuntimeException("Security User should not be null");
        }
        byte[] securityEngineId = outgoingMessage.getMsgAuthoritativeEngineID();
        if (securityEngineId.length != 0) {
            if (outgoingMessage.getContextId() == null || outgoingMessage.getContextId().length == 0) {
                outgoingMessage.setContextId(securityEngineId);
            }
        } else {
            throw new USMException("Engine Id should not be null");
        }
        msgFlag = outgoingMessage.getSecurityLevel();
        if (outgoingMessage.isConfirmedPdu()) {
            msgFlag |= 4;
        }
        int msgID = this.getNextMessageID();
        outgoingMessage.setMsgID(msgID);
        outgoingMessage.setMsgFlag((byte)msgFlag);
        outgoingMessage.setMsgSecurityModel(3);
        this.usmSecurity.generateRequestMsg(outgoingMessage);
        return outgoingMessage;
    }

    public synchronized int getNextMessageID() {
        if (this.currentMsgID >= Integer.MAX_VALUE) {
            this.currentMsgID = 1;
        }
        return this.currentMsgID++;
    }

    private byte[] getsecurityEngineId(String userSecurityName) throws USMException {
        BUsmUserTable usmUserTable = BUsmUserTable.getUsmUserTable();
        BUsmUser user = usmUserTable.getUser(userSecurityName);
        if (user == null) {
            throw new USMException("Unknown user in USM user Table" + userSecurityName);
        }
        return this.hexStringToByteArray(user.getEngineID());
    }

    private byte[] hexStringToByteArray(String s) {
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            int index = i * 2;
            int v = Integer.parseInt(s.substring(index, index + 2), 16);
            b[i] = (byte)v;
        }
        return b;
    }

    @Override
    public SnmpMessageProcessingModelOutput prepareResponseMessage(SnmpUserSecurityModel securityModel, String contextEngineID, String contextName, SnmpV3Message pdu, int maxSizeResponseScopedPDU, String stateReference, String statusInformation) {
        SnmpMessageProcessingModelOutput outputMessage = new SnmpMessageProcessingModelOutput(null, pdu, "");
        return outputMessage;
    }

    @Override
    public SnmpV3Message prepareResponseMessage(SnmpV3Message receivedMessage, SnmpV3Message responseMessage) {
        SnmpV3Message outputMessage = responseMessage;
        outputMessage.setVersion(receivedMessage.getVersion());
        outputMessage.setReqid(receivedMessage.getReqid());
        outputMessage.setCommand(162);
        outputMessage.setRemotePort(receivedMessage.getRemotePort());
        outputMessage.setDestinationIp(receivedMessage.getSourceIp());
        if (!receivedMessage.getUserSecurityName().isEmpty()) {
            this.usmSecurity.generateResponseMsg(responseMessage);
        }
        return outputMessage;
    }

    @Override
    public SnmpV3Message prepareDataElement(String contextEngineID, String contextName, SnmpV3Message pdu, BIpAddress address) {
        return pdu;
    }

    @Override
    public SnmpV3Message prepareDataElement(SnmpV3Message message) throws USMException {
        byte msgFlag = message.getMsgFlag();
        int usmSecurityLevel = msgFlag & 3;
        int usmSecurityModel = message.getMsgSecurityModel();
        if (usmSecurityModel > 3) {
            throw new RuntimeException("Unsupported Security Model");
        }
        String userSecurityName = message.getUserSecurityName();
        if (userSecurityName.isEmpty()) {
            message.setMsgFlag((byte)0);
            message.setSecurityLevel(0);
            return message;
        }
        message.setSecurityLevel(usmSecurityLevel);
        byte[] securityEngineId = this.getsecurityEngineId(userSecurityName);
        message.setMsgAuthoritativeEngineID(securityEngineId);
        int status = this.usmSecurity.processingIncomingMsg(message);
        if (status == 0) {
            message.setScopedPduData(message.encodeScopedPduData());
            if (message.getContextId() == null || message.getContextId().length == 0) {
                throw new USMException("Unknown Pdu handler");
            }
        } else {
            throw new USMException("SNMPv3_USM_ERROR");
        }
        return message;
    }
}

