/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.dto;

import com.tridium.nSnmp.BSnmpDevice;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.snmptypes.ASNException;
import com.tridium.nSnmp.snmptypes.ASNInput;
import com.tridium.nSnmp.snmptypes.ASNOutput;
import com.tridium.nSnmp.version3.securityModel.usm.BUsmSecurityLevel;
import com.tridium.nSnmp.version3.securityModel.usm.UsmSecurity;
import com.tridium.nSnmp.version3.securityModel.usm.authentication.UsmAuthUtil;
import com.tridium.nSnmp.version3.securityModel.usm.privacy.UsmPrivacy;
import com.tridium.nSnmp.version3.securityModel.usmUser.BUsmUser;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.AccessController;
import java.util.Enumeration;
import javax.baja.security.BPassword;

public class SnmpV3Message
extends SnmpPDU {
    private int msgID;
    private int msgMaxSize = 32768;
    private byte msgFlag;
    private int msgSecurityModel;
    private byte[] msgAuthoritativeEngineID;
    private int msgAuthoritativeEngineBoots;
    private int msgAuthoritativeEngineTime;
    private String userName;
    private byte[] msgAuthenticationParameters;
    private byte[] msgPrivacyParameter;
    private byte[] contextId;
    private String contextName;
    private int securityLevel;
    private boolean allowReplay;
    private boolean discoveryMode = false;
    private byte[] scopedPduData;
    byte[] encryptedPdu;
    private String authProtocol;
    private String authKey;
    private String privacyProtocol;
    private String privacykey;

    public SnmpV3Message(BSnmpDevice dev, int cmd) {
        super(dev, cmd);
        this.setUserSecurityName(dev.getUserName());
        this.setContextName(dev.getContextName());
        this.setSecurityLevel(this.fetchSecurityLevel(dev.getSecurityLevel()));
        this.setMsgFlag(this.calculateMsgFlags());
        this.setMsgSecurityModel(3);
        this.setAuthProtocol(dev.getAuthenticationProtocol().getTag().toUpperCase());
        this.setPrivacyProtocol(dev.getPrivacyProtocol().getTag().toUpperCase());
        this.setAuthKey(AccessController.doPrivileged(() -> ((BPassword)dev.getAuthenticationPassphrase()).getValue()));
        this.setPrivacykey(AccessController.doPrivileged(() -> ((BPassword)dev.getPrivacyPassphrase()).getValue()));
    }

    private int fetchSecurityLevel(BUsmSecurityLevel usmSecurityLevel) {
        int secLevel = 0;
        if (usmSecurityLevel == BUsmSecurityLevel.noAuthNoPriv) {
            secLevel = 0;
        } else if (usmSecurityLevel == BUsmSecurityLevel.authNoPriv) {
            secLevel = 1;
        } else if (usmSecurityLevel == BUsmSecurityLevel.authPriv) {
            secLevel = 3;
        }
        return secLevel;
    }

    public SnmpV3Message() {
    }

    public SnmpV3Message(int version) {
        super(version);
    }

    @Override
    public byte[] encodeData() {
        ASNOutput out = new ASNOutput();
        out.addInt(this.version);
        int v3specificDataPos = out.getPosition();
        this.populateV3Data();
        out.addInt(this.msgID);
        out.addInt(this.msgMaxSize);
        out.addOctetString(new byte[]{this.msgFlag});
        out.addInt(this.msgSecurityModel);
        out.insertTag(48, v3specificDataPos);
        int octetStringTagPosForSecurity = out.getPosition();
        int sequenceTagPosForSecurity = out.getPosition();
        out.addOctetString(this.msgAuthoritativeEngineID != null ? this.msgAuthoritativeEngineID : new byte[]{});
        out.addInt(this.msgAuthoritativeEngineBoots);
        out.addInt(this.msgAuthoritativeEngineTime);
        out.addOctetString(this.userName.getBytes());
        out.addOctetString(this.msgAuthenticationParameters != null ? this.msgAuthenticationParameters : new byte[]{});
        out.addOctetString(this.msgPrivacyParameter != null ? this.msgPrivacyParameter : new byte[]{});
        out.insertTag(48, sequenceTagPosForSecurity);
        out.insertTag(4, octetStringTagPosForSecurity);
        if ((this.msgFlag & 3) == 3) {
            out.addOctetString(this.encryptedPdu);
            out.insertTag(48, 0);
            return out.getBytes();
        }
        int scopedPduSquencePos = out.getPosition();
        out.addOctetString(this.contextId != null ? this.contextId : new byte[]{});
        out.addOctetString(this.contextName.getBytes());
        int pduSquencePos = out.getPosition();
        this.insertCommandBasedData(out);
        out.insertTag(this.pduType, pduSquencePos);
        out.insertTag(48, scopedPduSquencePos);
        out.insertTag(48, 0);
        return out.getBytes();
    }

    private void populateV3Data() {
        this.msgSecurityModel = 3;
        this.msgAuthoritativeEngineID = this.msgAuthoritativeEngineID == null && !this.isDiscoveryMode() ? this.createLocalEngineID() : this.msgAuthoritativeEngineID;
        this.contextId = this.contextId != null ? this.contextId : this.msgAuthoritativeEngineID;
    }

    @Override
    protected void decodeData(ASNInput in) {
        try {
            in.getSequenceLength();
            this.msgID = in.getInt();
            this.msgMaxSize = in.getInt();
            this.msgFlag = in.getOctetString()[0];
            this.msgSecurityModel = in.getInt();
            in.verifyTag(4);
            in.read();
            in.getSequenceLength();
            this.msgAuthoritativeEngineID = in.getOctetString();
            this.msgAuthoritativeEngineBoots = in.getInt();
            this.msgAuthoritativeEngineTime = in.getInt();
            this.userName = in.getString();
            this.msgAuthenticationParameters = in.getOctetString();
            this.msgPrivacyParameter = in.getOctetString();
            if ((this.msgFlag & 3) == 3) {
                this.encryptedPdu = in.getOctetString();
                this.setEncryptedPdu(this.encryptedPdu);
                byte[] decryptedPdu = this.decryptEncryptedMsg(this.encryptedPdu, this.msgAuthoritativeEngineBoots, this.msgAuthoritativeEngineTime);
                this.decodeScopedPduData(decryptedPdu);
                return;
            }
            in.getSequenceLength();
            this.contextId = in.getOctetString();
            this.contextName = new String(in.getOctetString());
            super.decodeData(in);
        }
        catch (ASNException e) {
            e.printStackTrace();
        }
    }

    private byte[] decryptEncryptedMsg(byte[] encryptedPdu, int engineBootTime, int engineTime) {
        BUsmUser user = UsmSecurity.getUser(this.userName);
        if (user != null) {
            String authProtocol = user.getAuthenticationProtocol().getTag().toUpperCase();
            String privacyProtcol = user.getPrivacyProtocol().getTag().toUpperCase();
            UsmPrivacy privProtocol = UsmSecurity.getPrivacyProtocolInstance(privacyProtcol);
            String privPass = AccessController.doPrivileged(() -> ((BPassword)user.getPrivacyPassphrase()).getValue());
            byte[] privKey = UsmAuthUtil.passwordTokey(authProtocol, privPass.getBytes(), this.getMsgAuthoritativeEngineID(), privacyProtcol);
            byte[] privParam = this.getMsgPrivacyParameter();
            byte[] decryptedMsg = privProtocol.decryptMsg(encryptedPdu, privKey, engineBootTime, engineTime, privParam);
            return decryptedMsg;
        }
        BSnmpDevice.User deviceUser = BSnmpDevice.userTable.get(SnmpV3Message.engineIdDisplay(this.msgAuthoritativeEngineID));
        String authProtocol = deviceUser.getAuthProtocol();
        String privacyProtcol = deviceUser.getPrivProtocol();
        UsmPrivacy privProtocol = UsmSecurity.getPrivacyProtocolInstance(privacyProtcol.toUpperCase());
        String privPass = deviceUser.getPrivPass();
        byte[] privKey = UsmAuthUtil.passwordTokey(authProtocol, privPass.getBytes(), this.getMsgAuthoritativeEngineID(), privacyProtcol);
        byte[] privParam = this.getMsgPrivacyParameter();
        byte[] decryptedMsg = privProtocol.decryptMsg(encryptedPdu, privKey, engineBootTime, engineTime, privParam);
        return decryptedMsg;
    }

    private byte calculateMsgFlags() {
        byte msgFlag = 0;
        if (this.allowReplay) {
            msgFlag = (byte)(msgFlag | 0);
        }
        msgFlag = (byte)(msgFlag | this.securityLevel);
        return msgFlag;
    }

    public byte[] createLocalEngineID() {
        byte[] engineID = new byte[12];
        int enterpriseID = 4131;
        engineID[0] = (byte)(0x80 | enterpriseID >> 24 & 0xFF);
        engineID[1] = (byte)(enterpriseID >> 16 & 0xFF);
        engineID[2] = (byte)(enterpriseID >> 8 & 0xFF);
        engineID[3] = (byte)(enterpriseID & 0xFF);
        engineID[4] = -128;
        byte[] address = null;
        address = this.getCurrentIp().getAddress();
        int j = 0;
        for (int i = 5; i < 12 && j < 4; ++i, ++j) {
            engineID[i] = address[j];
        }
        return engineID;
    }

    private InetAddress getCurrentIp() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                Enumeration<InetAddress> nias = ni.getInetAddresses();
                while (nias.hasMoreElements()) {
                    InetAddress ia = nias.nextElement();
                    if (ia.isLinkLocalAddress() || ia.isLoopbackAddress() || !(ia instanceof Inet4Address)) continue;
                    return ia;
                }
            }
        }
        catch (SocketException e) {
            throw new RuntimeException("unable to get current IP " + e.getMessage());
        }
        return null;
    }

    public String getUserSecurityName() {
        return this.userName;
    }

    public void setUserSecurityName(String userName) {
        this.userName = userName;
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public int getMsgID() {
        return this.msgID;
    }

    public void setMsgID(int msgID) {
        this.msgID = msgID;
    }

    public int getMsgMaxSize() {
        return this.msgMaxSize;
    }

    public void setMsgMaxSize(int msgMaxSize) {
        this.msgMaxSize = msgMaxSize;
    }

    public byte getMsgFlag() {
        return this.msgFlag;
    }

    public void setMsgFlag(byte msgFlag) {
        this.msgFlag = msgFlag;
    }

    public int getMsgSecurityModel() {
        return this.msgSecurityModel;
    }

    public void setMsgSecurityModel(int msgSecurityModel) {
        this.msgSecurityModel = msgSecurityModel;
    }

    public byte[] getMsgAuthoritativeEngineID() {
        return this.msgAuthoritativeEngineID;
    }

    public void setMsgAuthoritativeEngineID(byte[] msgAuthoritativeEngineID) {
        this.msgAuthoritativeEngineID = msgAuthoritativeEngineID;
    }

    public int getMsgAuthoritativeEngineBoots() {
        return this.msgAuthoritativeEngineBoots;
    }

    public void setMsgAuthoritativeEngineBoots(int msgAuthoritativeEngineBoots) {
        this.msgAuthoritativeEngineBoots = msgAuthoritativeEngineBoots;
    }

    public int getMsgAuthoritativeEngineTime() {
        return this.msgAuthoritativeEngineTime;
    }

    public void setMsgAuthoritativeEngineTime(int msgAuthoritativeEngineTime) {
        this.msgAuthoritativeEngineTime = msgAuthoritativeEngineTime;
    }

    public byte[] getMsgAuthenticationParameters() {
        return this.msgAuthenticationParameters;
    }

    public void setMsgAuthenticationParameters(byte[] msgAuthenticationParameters) {
        this.msgAuthenticationParameters = msgAuthenticationParameters;
    }

    public byte[] getMsgPrivacyParameter() {
        return this.msgPrivacyParameter;
    }

    public void setMsgPrivacyParameter(byte[] msgPrivacyParameter) {
        this.msgPrivacyParameter = msgPrivacyParameter;
    }

    public byte[] getContextId() {
        return this.contextId;
    }

    public void setContextId(byte[] contextId) {
        this.contextId = contextId;
    }

    public boolean getAllowReplay() {
        return this.allowReplay;
    }

    public void setAllowReplay(boolean allowReplay) {
        this.allowReplay = allowReplay;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(int securityLevel) {
        this.securityLevel = securityLevel;
    }

    @Override
    public boolean isDiscoveryMode() {
        return this.discoveryMode;
    }

    public void setDiscoveryMode(boolean discoveryMode) {
        this.discoveryMode = discoveryMode;
    }

    public void setScopedPduData(byte[] scopedPdu) {
        this.scopedPduData = scopedPdu;
    }

    public byte[] getScopedPduData() {
        return this.scopedPduData;
    }

    public void setEncryptedPdu(byte[] encryptedPdu) {
        this.encryptedPdu = encryptedPdu;
    }

    public byte[] getEncryptedPdu() {
        return this.encryptedPdu;
    }

    public String getAuthProtocol() {
        return this.authProtocol;
    }

    public void setAuthProtocol(String authProtocol) {
        this.authProtocol = authProtocol;
    }

    public String getAuthKey() {
        return this.authKey;
    }

    public void setAuthKey(String authKey) {
        this.authKey = authKey;
    }

    public String getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public void setPrivacyProtocol(String privacyProtocol) {
        this.privacyProtocol = privacyProtocol;
    }

    public String getPrivacykey() {
        return this.privacykey;
    }

    public void setPrivacykey(String privacykey) {
        this.privacykey = privacykey;
    }

    @Override
    public String toString() {
        return "msgID:" + this.msgID + " msgMaxSize:" + this.msgMaxSize + "  msgFlags:" + this.msgFlag + " securityLevel:" + this.securityLevel + " securityName" + this.userName;
    }

    public boolean isConfirmedPdu() {
        return this.pduType != 168 && this.pduType != 164 && this.pduType != 167 && this.pduType != 162;
    }

    public byte[] encodeScopedPduData() {
        ASNOutput out = new ASNOutput();
        int scopedPduSquencePos = out.getPosition();
        out.addOctetString(this.contextId);
        out.addOctetString(this.contextName.getBytes());
        int pduSquencePos = out.getPosition();
        this.insertCommandBasedData(out);
        out.insertTag(this.pduType, pduSquencePos);
        out.insertTag(48, scopedPduSquencePos);
        return out.getBytes();
    }

    public void decodeScopedPduData(byte[] scopedPdu) {
        ASNInput in = new ASNInput(scopedPdu);
        try {
            in.getSequenceLength();
            this.contextId = in.getOctetString();
            this.contextName = new String(in.getOctetString());
            super.decodeData(in);
        }
        catch (ASNException e) {
            e.printStackTrace();
        }
    }

    private static String engineIdDisplay(byte[] paramArrayOfByte) {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < paramArrayOfByte.length; ++i) {
            sb.append(String.format("%02X", 0xFF & paramArrayOfByte[i]));
        }
        return sb.toString().trim();
    }
}

