/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.mib.table;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.mib.table.AlarmEntry;
import com.tridium.nSnmp.mib.table.SmiTable;
import com.tridium.nSnmp.mib.table.TableEntry;
import java.util.Comparator;
import java.util.logging.Level;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class AlarmTable
extends SmiTable {
    TableEntry[] aEntries = null;
    private IntHashMap hash;
    private boolean hashModified = true;
    private BSnmpNetwork snmp;
    private int capacity;

    public AlarmTable(BSnmpNetwork snmp) {
        this.snmp = snmp;
        this.capacity = snmp.getSnmpAlarmTableCapacity();
        this.hash = new IntHashMap(this.capacity);
    }

    public synchronized AlarmEntry addAlarmEntry(BAlarmRecord setRow) {
        if (this.capacity < 1) {
            return new AlarmEntry(setRow, 0);
        }
        BUuid uuid = setRow.getUuid();
        IntHashMap.Iterator iterator = this.hash.iterator();
        int index = 0;
        int oldestIndex = 0;
        BAbsTime oldestTimestamp = BAbsTime.now();
        while (iterator.hasNext()) {
            SnmpAlarmInfo info = (SnmpAlarmInfo)iterator.next();
            BUuid id = info.uuid;
            BAbsTime lastUpdate = info.lastUpdate;
            if (uuid.equals((Object)id)) {
                index = info.index;
                break;
            }
            if (!lastUpdate.isBefore(oldestTimestamp)) continue;
            oldestTimestamp = lastUpdate;
            oldestIndex = iterator.key();
        }
        if (index < 1) {
            index = this.hash.size();
            if (index >= this.capacity) {
                index = oldestIndex;
                this.hash.remove(index);
                if (index >= this.capacity) {
                    index = 1;
                }
            } else if (this.hash.get(index) != null) {
                index = 1;
            } else if (index < 1) {
                index = 1;
            }
            while (this.hash.get(index) != null) {
                ++index;
            }
        }
        this.hash.put(index, (Object)new SnmpAlarmInfo(setRow.getUuid(), setRow.getLastUpdate(), index));
        this.hashModified = true;
        this.aEntries = null;
        AlarmEntry entry = new AlarmEntry(setRow, index);
        if (this.snmp.log().isLoggable(Level.FINE)) {
            this.snmp.log().fine("Alarm Table added new entry: " + entry);
        }
        return entry;
    }

    public synchronized void setCapacity(int capacity) {
        this.capacity = capacity;
        if (capacity < 1) {
            this.clearAlarmTable();
            return;
        }
        int size = this.hash.size();
        if (size > capacity) {
            Object[] array = new SnmpAlarmInfo[size];
            this.hash.toArray(array);
            SortUtil.sort((Object[])array);
            int trimCount = size - capacity;
            for (int i = 0; i < trimCount; ++i) {
                this.hash.remove(((SnmpAlarmInfo)array[i]).index);
            }
        }
        this.hashModified = true;
    }

    public synchronized void clearAlarmTable() {
        this.hash.clear();
        this.hashModified = true;
    }

    public void acknowledgeAll() {
        TableEntry[] a = this.getArray();
        try {
            for (int i = 0; i < a.length; ++i) {
                AlarmEntry entry = (AlarmEntry)a[i];
                if (entry.isAcked()) continue;
                this.acknowledge(entry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AlarmEntry getAlarm(int index) {
        Object o = this.hash.get(index);
        if (o == null) {
            return null;
        }
        SnmpAlarmInfo info = (SnmpAlarmInfo)o;
        try (AlarmDbConnection conn = this.getAlarmService().getAlarmDb().getDbConnection(null);){
            BAlarmRecord rec = conn.getRecord(info.uuid);
            if (rec == null) {
                AlarmEntry alarmEntry2 = null;
                return alarmEntry2;
            }
            AlarmEntry alarmEntry = new AlarmEntry(rec, info.index);
            return alarmEntry;
        }
        catch (Exception e) {
            this.snmp.log().severe("Could not find alarm for index " + index + " " + e.toString());
            return null;
        }
    }

    @Override
    public synchronized TableEntry[] getArray() {
        if (!this.hashModified) {
            return this.aEntries;
        }
        Array a = new Array(TableEntry.class, this.hash.size());
        IntHashMap.Iterator iterator = this.hash.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            AlarmEntry ntry = this.getAlarm(iterator.key());
            if (ntry == null) continue;
            a.add((Object)ntry);
        }
        this.aEntries = (TableEntry[])a.trim();
        Comparator<TableEntry> comp = new Comparator<TableEntry>(){

            @Override
            public int compare(TableEntry v1, TableEntry v2) {
                return v1.getIndex() - v2.getIndex();
            }
        };
        SortUtil.sort((Object[])this.aEntries, (Object[])this.aEntries, (Comparator)comp);
        this.hashModified = false;
        return this.aEntries;
    }

    public void acknowledge(AlarmEntry entry) {
        block2: {
            try {
                BAlarmRecord alarm = entry.getAlarmRecord();
                alarm.setAckState(BAckState.acked);
                this.getAlarmService().ackAlarm(alarm);
            }
            catch (Exception e) {
                if (this.snmp == null) break block2;
                this.snmp.log().severe("Exception generated in Alarm Table during received acknowledgement for entry: " + entry + " " + e.toString());
            }
        }
    }

    public BSnmpNetwork snmp() {
        return this.snmp;
    }

    BAlarmService getAlarmService() {
        return (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
    }

    class SnmpAlarmInfo
    implements Comparable<Object> {
        BUuid uuid;
        BAbsTime lastUpdate;
        int index;

        SnmpAlarmInfo(BUuid uuid, BAbsTime lastUpdate, int index) {
            this.uuid = uuid;
            this.lastUpdate = lastUpdate;
            this.index = index;
        }

        @Override
        public int compareTo(Object obj) {
            SnmpAlarmInfo other = (SnmpAlarmInfo)obj;
            return this.lastUpdate.compareTo((Object)other.lastUpdate);
        }
    }
}

