/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.messages;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.messages.SnmpTrap;
import com.tridium.nSnmp.mib.table.AlarmEntry;
import com.tridium.nSnmp.services.BSnmpRecipient;

public class AlarmTrap
extends SnmpTrap {
    public AlarmTrap(BSnmpNetwork snmp, AlarmEntry entry) {
        super(snmp, entry != null ? 6 : 0, entry != null ? 1 : 0);
        this.init(entry, snmp.getDefaultNetworkManagerSnmpVersion());
    }

    public AlarmTrap(BSnmpRecipient recipient, AlarmEntry entry) {
        super(recipient, entry != null ? 6 : 0, entry != null ? 1 : 0);
        this.init(entry, recipient.getNetworkManagerConfig().getNetworkManagerSnmpVersion());
    }

    private void init(AlarmEntry entry, int snmpVersion) {
        if (this.genericType == 6) {
            this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.1", entry.getTimestampString());
            this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.2", entry.getUuid());
            this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.3", entry.getSourceState());
            this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.4", entry.getAckState());
            this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.5", entry.getAckRequired());
            this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.6", entry.getSource());
            this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.7", entry.getAlarmClass());
            this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.8", entry.getPriority());
            this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.9", entry.getNormalTime());
            this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.10", entry.getAckTime());
            this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.11", entry.getUser());
            this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.12", entry.getAlarmData());
            this.addIntegerVariable("1.3.6.1.4.1.4131.1.3.1.13", entry.getAlarmTransition());
            this.addStringVariable("1.3.6.1.4.1.4131.1.3.1.14", entry.getLastUpdate());
        }
    }

    public static void sendAlarmTrap(BSnmpNetwork snmp, AlarmEntry entry) {
        AlarmTrap trap = new AlarmTrap(snmp, entry);
        trap.send();
    }

    public static void sendAlarmTrap(BSnmpRecipient recipient, AlarmEntry entry) {
        AlarmTrap trap = new AlarmTrap(recipient, entry);
        trap.send();
    }
}

