/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitIo.ui;

import com.tridium.kitIo.KitIoException;
import com.tridium.kitIo.conv.BTabularConversion;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.ord.BFileOrdChooser;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.IFileFilter;
import javax.baja.file.types.text.BXmlFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.file.ExtFileFilter;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.Position;
import javax.baja.util.Lexicon;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;
import javax.baja.xml.XWriter;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="setModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BTabularConvDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BTabularConvDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action cancelButtonPressed = BTabularConvDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action setModified = BTabularConvDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTabularConvDialog.class);
    static Lexicon kitIoLex = Lexicon.make((String)"kitIo");
    static BImage editIcon = BImage.make((String)"module://icons/x32/edit.png");
    private BGridPane tablePane;
    private BButton okButton;
    private BTextField desc;
    private int nextIndex;
    private Array<Integer> map = new Array(Integer.class);
    private BTabularConversion conversion = null;

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void setModified(BWidgetEvent parameter) {
        this.invoke(setModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static final BTabularConversion show(BWidget owner, BTabularConversion src) {
        BTabularConvDialog dialog = new BTabularConvDialog(owner, src);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getConversion();
    }

    private BTabularConvDialog(BWidget parent, BTabularConversion src) {
        super(parent, kitIoLex.get("tabularConvDialog.title"), true);
        BLabel descLabel = new BLabel(kitIoLex.get("tabularConvDialog.descriptionLabel"));
        this.desc = new BTextField("");
        this.desc.setText(src.getDescription());
        this.desc.getSelection().deselect();
        this.desc.moveCaretPosition(new Position(0, 0));
        this.linkTo(null, (BComponent)this.desc, (Slot)BTextField.textModified, (Slot)setModified);
        BGridPane descPane = new BGridPane(2);
        descPane.add(null, (BValue)descLabel);
        descPane.add(null, (BValue)this.desc);
        descPane.setHalign(BHalign.left);
        descPane.setStretchColumn(1);
        descPane.setColumnAlign(BHalign.fill);
        this.tablePane = new BGridPane(3);
        this.tablePane.setColumnAlign(BHalign.center);
        this.tablePane.setRowAlign(BValign.fill);
        this.tablePane.setValign(BValign.top);
        Array points = src.getPoints();
        this.buildTablePane(points);
        BButton addButton = new BButton((Command)new AddCmd());
        BButton resortButton = new BButton((Command)new ResortCmd());
        BButton deleteAllButton = new BButton((Command)new DeleteAllCmd());
        BButton importButton = new BButton((Command)new ImportCmd());
        BButton exportButton = new BButton((Command)new ExportCmd());
        this.linkTo(null, (BComponent)addButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)resortButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)deleteAllButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)importButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)exportButton, (Slot)BButton.actionPerformed, (Slot)setModified);
        BGridPane addbuttonPane = new BGridPane(1);
        addbuttonPane.setUniformColumnWidth(true);
        addbuttonPane.setColumnAlign(BHalign.fill);
        addbuttonPane.setValign(BValign.top);
        addbuttonPane.add(null, (BValue)addButton);
        addbuttonPane.add(null, (BValue)resortButton);
        addbuttonPane.add(null, (BValue)deleteAllButton);
        addbuttonPane.add(null, (BValue)importButton);
        addbuttonPane.add(null, (BValue)exportButton);
        BGridPane okbuttonPane = new BGridPane(2);
        okbuttonPane.setColumnAlign(BHalign.fill);
        okbuttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(kitIoLex.get("tabularConvDialog.okButtonLabel"));
        okbuttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        BButton cancelButton = new BButton(kitIoLex.get("tabularConvDialog.cancelButtonLabel"));
        okbuttonPane.add(null, (BValue)cancelButton);
        this.linkTo("linkB", (BComponent)cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        BEdgePane outerPane = new BEdgePane();
        outerPane.setTop((BWidget)new BBorderPane((BWidget)descPane, 7.0, 7.0, 0.0, 7.0));
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.tablePane, 7.0, 7.0, 7.0, 7.0));
        scrollPane.setVpolicy(BScrollBarPolicy.always);
        scrollPane.setHpolicy(BScrollBarPolicy.never);
        scrollPane.setViewportBackground(Theme.widget().getControlBackground());
        BConstrainedPane constrainedPane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)scrollPane, BBorder.inset, BInsets.DEFAULT));
        constrainedPane.setFixedSize(205.0, 250.0);
        outerPane.setCenter((BWidget)new BBorderPane((BWidget)constrainedPane, 7.0, 7.0, 7.0, 7.0));
        outerPane.setRight((BWidget)new BBorderPane((BWidget)addbuttonPane, 7.0, 7.0, 0.0, 0.0));
        outerPane.setBottom((BWidget)new BBorderPane((BWidget)okbuttonPane, 0.0, 0.0, 7.0, 0.0));
        this.setContent((BWidget)outerPane);
        this.setDefaultButton(this.okButton);
    }

    private void buildTablePane(Array points) {
        this.tablePane.removeAll();
        this.map.clear();
        this.nextIndex = 0;
        int size = points.size();
        if (size > 0) {
            this.tablePane.add("xh", (BValue)new BLabel(kitIoLex.get("tabularConvDialog.srcColumnLabel")));
            this.tablePane.add("yh", (BValue)new BLabel(kitIoLex.get("tabularConvDialog.resultColumnLabel")));
            this.tablePane.add("dh", (BValue)new BNullWidget());
            for (int i = 0; i < size; ++i) {
                BTextField yfield;
                BTextField xfield;
                Object pnt;
                if (points.get(i) instanceof BTabularConversion.XYPoint) {
                    pnt = (BTabularConversion.XYPoint)points.get(i);
                    xfield = new BTextField(pnt.x() + "", 10);
                    yfield = new BTextField(pnt.y() + "", 10);
                } else {
                    pnt = (TextXYPoint)points.get(i);
                    xfield = new BTextField(((TextXYPoint)pnt).x(), 10);
                    yfield = new BTextField(((TextXYPoint)pnt).y(), 10);
                }
                DeleteCmd deleteCmd = new DeleteCmd(i);
                BButton dfield = new BButton((Command)deleteCmd);
                this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
                dfield.setButtonStyle(BButtonStyle.toolBar);
                xfield.setExpandHeight(true);
                yfield.setExpandHeight(true);
                this.tablePane.add("x" + i, (BValue)xfield);
                this.tablePane.add("y" + i, (BValue)yfield);
                this.tablePane.add("d" + i, (BValue)dfield);
                this.linkTo(null, (BComponent)xfield, (Slot)BTextField.textModified, (Slot)setModified);
                this.linkTo(null, (BComponent)yfield, (Slot)BTextField.textModified, (Slot)setModified);
                this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
                this.map.add((Object)i);
            }
            this.nextIndex = size;
        }
    }

    public BTabularConversion getConversion() {
        return this.conversion;
    }

    public void doOkButtonPressed(BWidgetEvent event) {
        BTabularConversion conv;
        Array arr = new Array(BTabularConversion.XYPoint.class);
        if (this.map.size() < 2) {
            BDialog.error((BWidget)this, (Object)kitIoLex.get("tabularConvDialog.twoPointsError"));
            return;
        }
        for (int i = 0; i < this.map.size(); ++i) {
            double y;
            double x;
            String xname = "x" + this.map.get(i);
            String yname = "y" + this.map.get(i);
            BTextField xfield = (BTextField)this.tablePane.get(xname);
            BTextField yfield = (BTextField)this.tablePane.get(yname);
            try {
                x = Double.parseDouble(xfield.getText());
                y = Double.parseDouble(yfield.getText());
            }
            catch (NumberFormatException n) {
                BDialog.error((BWidget)this, (Object)kitIoLex.get("tabularConvDialog.invalidFormatError"));
                return;
            }
            arr.add((Object)new BTabularConversion.XYPoint(x, y));
        }
        arr.sort();
        this.conversion = conv = BTabularConversion.make((String)this.desc.getText(), (Array)arr);
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void doSetModified(BWidgetEvent event) {
        this.okButton.setEnabled(true);
    }

    class TextXYPoint
    implements Comparable<Object> {
        String x;
        String y;

        public TextXYPoint(String x, String y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof TextXYPoint) {
                TextXYPoint src = (TextXYPoint)o;
                try {
                    double srcxv = Double.parseDouble(src.x);
                    double xv = Double.parseDouble(this.x);
                    if (srcxv > xv) {
                        return -1;
                    }
                    if (srcxv < xv) {
                        return 1;
                    }
                    return 0;
                }
                catch (NumberFormatException e) {
                    return 1;
                }
            }
            throw new ClassCastException("can't compare TextXYPoint");
        }

        public String toString() {
            return "{x=" + this.x + ",y=" + this.y + "}";
        }

        public String x() {
            return this.x;
        }

        public String y() {
            return this.y;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    class ExportCmd
    extends Command {
        public ExportCmd() {
            super((BWidget)BTabularConvDialog.this, Lexicon.make((String)"kitIo"), "tabularConversion.exportButton");
        }

        public CommandArtifact doInvoke() {
            BFacets facets = BFacets.make((String)"save", (BIDataValue)BBoolean.TRUE);
            Pattern pattern = null;
            String defaultName = "conversion_table.xml";
            try {
                defaultName = BTabularConvDialog.this.desc.getText();
                pattern = Pattern.compile("\\s+");
                Matcher matcher = pattern.matcher(defaultName);
                defaultName = matcher.replaceAll("_");
                pattern = Pattern.compile("[^a-zA-Z0-9_]+");
                matcher = pattern.matcher(defaultName);
                defaultName = matcher.replaceAll("");
                defaultName = defaultName.toLowerCase();
                if (defaultName.trim().length() == 0) {
                    defaultName = "conversion_table";
                }
                defaultName = defaultName + ".xml";
            }
            catch (Exception exception) {
                // empty catch block
            }
            facets = BFacets.make((BFacets)facets, (String)"defaultFileName", (BIDataValue)BString.make((String)defaultName));
            BFileOrdChooser chooser = new BFileOrdChooser();
            chooser.addFilter((IFileFilter)new ExtFileFilter("Xml Files (*.xml)", "xml"));
            BOrd ord = chooser.openChooser((BWidget)BTabularConvDialog.this, (BObject)BTabularConvDialog.this, BOrd.make((String)"file:^"), (Context)facets);
            if (ord == null) {
                return null;
            }
            try {
                this.saveFile(ord);
            }
            catch (KitIoException e) {
                BDialog.error((BWidget)BTabularConvDialog.this, (String)BDialog.TITLE_ERROR, (Object)kitIoLex.get("tabularConvDialog.exportError"), (Throwable)e);
            }
            return null;
        }

        private void saveFile(BOrd fileOrd) throws KitIoException {
            if (BTabularConvDialog.this.map.size() < 2) {
                BDialog.error((BWidget)BTabularConvDialog.this, (Object)kitIoLex.get("tabularConvDialog.twoPointsError"));
                return;
            }
            XElem xroot = new XElem("conversion");
            XElem xdesc = new XElem("description");
            xdesc.addContent((XContent)new XText(BTabularConvDialog.this.desc.getText()));
            xroot.addContent((XContent)xdesc);
            XElem xtable = new XElem("table");
            xroot.addContent((XContent)xtable);
            for (int i = 0; i < BTabularConvDialog.this.map.size(); ++i) {
                String xname = "x" + BTabularConvDialog.this.map.get(i);
                String yname = "y" + BTabularConvDialog.this.map.get(i);
                BTextField xfield = (BTextField)BTabularConvDialog.this.tablePane.get(xname);
                BTextField yfield = (BTextField)BTabularConvDialog.this.tablePane.get(yname);
                try {
                    double x = Double.parseDouble(xfield.getText());
                    double y = Double.parseDouble(yfield.getText());
                    XElem point = new XElem("point");
                    point.setAttr("src", xfield.getText());
                    point.setAttr("result", yfield.getText());
                    xtable.addContent((XContent)point);
                    continue;
                }
                catch (NumberFormatException n) {
                    BDialog.error((BWidget)BTabularConvDialog.this, (Object)kitIoLex.get("tabularConvDialog.invalidFormatError"));
                    return;
                }
            }
            try {
                BIFile file = (BIFile)fileOrd.get();
                XWriter xwriter = new XWriter(file.getOutputStream());
                xwriter.prolog();
                xroot.write(xwriter);
                xwriter.close();
            }
            catch (Exception e) {
                BDialog.error((BWidget)BTabularConvDialog.this, (String)kitIoLex.get("tabularConvDialog.writingError"), (Object)e);
                return;
            }
        }
    }

    class ImportCmd
    extends Command {
        public ImportCmd() {
            super((BWidget)BTabularConvDialog.this, Lexicon.make((String)"kitIo"), "tabularConversion.importButton");
        }

        public CommandArtifact doInvoke() {
            BFileOrdChooser chooser = new BFileOrdChooser();
            chooser.addFilter((IFileFilter)new ExtFileFilter("Xml Files (*.xml)", "xml"));
            BOrd ord = chooser.openChooser((BWidget)BTabularConvDialog.this, (BObject)BTabularConvDialog.this, BOrd.make((String)"file:^"), null);
            if (ord == null) {
                return null;
            }
            if (BDialog.confirm((BWidget)BTabularConvDialog.this, (String)BDialog.TITLE_CONFIRM, (Object)kitIoLex.get("tabularConvDialog.confirmMessage")) == 8) {
                return null;
            }
            try {
                this.loadFile(ord);
            }
            catch (KitIoException e) {
                BDialog.error((BWidget)BTabularConvDialog.this, (String)BDialog.TITLE_ERROR, (Object)kitIoLex.get("tabularConvDialog.importError"), (Throwable)e);
            }
            return null;
        }

        private void loadFile(BOrd fileOrd) throws KitIoException {
            InputStream stream = null;
            BTabularConversion conv = null;
            Array arr = new Array(BTabularConversion.XYPoint.class);
            try {
                BXmlFile file = (BXmlFile)fileOrd.get();
                if (file == null) {
                    throw new KitIoException("File not defined.");
                }
                stream = file.getInputStream();
                XParser parser = XParser.make((InputStream)stream);
                XElem thermistorElem = parser.parse();
                XElem descriptionElem = thermistorElem.elem("description");
                String description = descriptionElem.string();
                XElem tableElem = thermistorElem.elem("table");
                if (tableElem == null) {
                    throw new KitIoException("Improperly formatted file: No 'table' elemnent.");
                }
                XElem[] pointElems = tableElem.elems("point");
                if (pointElems.length < 2) {
                    throw new KitIoException("Must have at least two points.");
                }
                for (int i = 0; i < pointElems.length; ++i) {
                    arr.add((Object)new BTabularConversion.XYPoint(pointElems[i].getd("src"), pointElems[i].getd("result")));
                }
                arr.sort();
                conv = BTabularConversion.make((String)description, (Array)arr);
            }
            catch (KitIoException n) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw n;
            }
            catch (Exception e) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new KitIoException(e.getMessage());
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            BTabularConvDialog.this.desc.setText(conv.getDescription());
            BTabularConvDialog.this.desc.getSelection().deselect();
            BTabularConvDialog.this.desc.moveCaretPosition(new Position(0, 0));
            BTabularConvDialog.this.buildTablePane(conv.getPoints());
        }
    }

    class DeleteAllCmd
    extends Command {
        public DeleteAllCmd() {
            super((BWidget)BTabularConvDialog.this, Lexicon.make((String)"kitIo"), "tabularConversion.deleteAllButton");
        }

        public CommandArtifact doInvoke() {
            if (BTabularConvDialog.this.map.size() == 0) {
                return null;
            }
            for (int i = 0; i < BTabularConvDialog.this.map.size(); ++i) {
                String xname = "x" + BTabularConvDialog.this.map.get(i);
                String yname = "y" + BTabularConvDialog.this.map.get(i);
                String dname = "d" + BTabularConvDialog.this.map.get(i);
                BTabularConvDialog.this.tablePane.remove(xname);
                BTabularConvDialog.this.tablePane.remove(yname);
                BTabularConvDialog.this.tablePane.remove(dname);
            }
            BTabularConvDialog.this.map.clear();
            BTabularConvDialog.this.tablePane.remove("xh");
            BTabularConvDialog.this.tablePane.remove("yh");
            BTabularConvDialog.this.tablePane.remove("dh");
            BTabularConvDialog.this.nextIndex = 0;
            BTabularConvDialog.this.desc.setText("");
            BTabularConvDialog.this.desc.getSelection().deselect();
            BTabularConvDialog.this.desc.moveCaretPosition(new Position(0, 0));
            return null;
        }
    }

    class ResortCmd
    extends Command {
        public ResortCmd() {
            super((BWidget)BTabularConvDialog.this, Lexicon.make((String)"kitIo"), "tabularConversion.resortButton");
        }

        public CommandArtifact doInvoke() {
            Array array = new Array(TextXYPoint.class);
            for (int i = 0; i < BTabularConvDialog.this.map.size(); ++i) {
                String xname = "x" + BTabularConvDialog.this.map.get(i);
                String yname = "y" + BTabularConvDialog.this.map.get(i);
                BTextField xfield = (BTextField)BTabularConvDialog.this.tablePane.get(xname);
                BTextField yfield = (BTextField)BTabularConvDialog.this.tablePane.get(yname);
                TextXYPoint pnt = new TextXYPoint(xfield.getText(), yfield.getText());
                array.add((Object)pnt);
            }
            array = array.sort();
            BTabularConvDialog.this.buildTablePane(array);
            return null;
        }
    }

    class AddCmd
    extends Command {
        public AddCmd() {
            super((BWidget)BTabularConvDialog.this, Lexicon.make((String)"kitIo"), "tabularConversion.addButton");
        }

        public CommandArtifact doInvoke() {
            BTextField xfield = new BTextField("", 10);
            BTextField yfield = new BTextField("", 10);
            DeleteCmd deleteCmd = new DeleteCmd(BTabularConvDialog.this.nextIndex);
            BButton dfield = new BButton((Command)deleteCmd);
            dfield.setButtonStyle(BButtonStyle.toolBar);
            BTabularConvDialog.this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
            if (BTabularConvDialog.this.map.size() == 0) {
                BTabularConvDialog.this.tablePane.add("xh", (BValue)new BLabel(kitIoLex.get("tabularConvDialog.srcColumnLabel")));
                BTabularConvDialog.this.tablePane.add("yh", (BValue)new BLabel(kitIoLex.get("tabularConvDialog.resultColumnLabel")));
                BTabularConvDialog.this.tablePane.add("dh", (BValue)new BNullWidget());
            }
            xfield.setExpandHeight(true);
            yfield.setExpandHeight(true);
            BTabularConvDialog.this.tablePane.add("x" + BTabularConvDialog.this.nextIndex, (BValue)xfield);
            BTabularConvDialog.this.tablePane.add("y" + BTabularConvDialog.this.nextIndex, (BValue)yfield);
            BTabularConvDialog.this.tablePane.add("d" + BTabularConvDialog.this.nextIndex, (BValue)dfield);
            BTabularConvDialog.this.linkTo(null, (BComponent)xfield, (Slot)BTextField.textModified, (Slot)setModified);
            BTabularConvDialog.this.linkTo(null, (BComponent)yfield, (Slot)BTextField.textModified, (Slot)setModified);
            BTabularConvDialog.this.linkTo(null, (BComponent)dfield, (Slot)BButton.actionPerformed, (Slot)setModified);
            BTabularConvDialog.this.map.add((Object)BTabularConvDialog.this.nextIndex);
            BTabularConvDialog.this.nextIndex++;
            return null;
        }
    }

    class DeleteCmd
    extends Command {
        private int index;

        public DeleteCmd(int index) {
            super((BWidget)BTabularConvDialog.this, Lexicon.make((String)"kitIo"), "tabularConversion.deleteButton");
            this.index = index;
        }

        public CommandArtifact doInvoke() {
            BTabularConvDialog.this.tablePane.remove("x" + this.index);
            BTabularConvDialog.this.tablePane.remove("y" + this.index);
            BTabularConvDialog.this.tablePane.remove("d" + this.index);
            BTabularConvDialog.this.map.remove((Object)this.index);
            if (BTabularConvDialog.this.map.size() == 0) {
                BTabularConvDialog.this.tablePane.remove("xh");
                BTabularConvDialog.this.tablePane.remove("yh");
                BTabularConvDialog.this.tablePane.remove("dh");
            }
            return null;
        }
    }
}

